/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicPoint;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.Double2;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class BasicPointVector
extends AbstractVector {
    protected Double2[] values;

    public BasicPointVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicPointVector(List<Double2> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new Double2[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i);
            }
        }
    }

    public BasicPointVector(Double2[] array) {
        this(array, true);
    }

    protected BasicPointVector(Double2[] array, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = copy ? (Double2[])array.clone() : array;
    }

    protected BasicPointVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new Double2[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = new Double2(0.0, 0.0);
        }
    }

    protected BasicPointVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        ByteOrder bo;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new Double2[size];
        int totalBytes = size * 16;
        boolean littleEndian = in.isLittleEndian();
        ByteOrder byteOrder = bo = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (int off = 0; off < totalBytes; off += len) {
            len = Math.min(4096, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int start = off / 16;
            int end = len / 16;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                double x = byteBuffer.getDouble(i * 16);
                double y = byteBuffer.getDouble(i * 16 + 8);
                this.values[i + start] = new Double2(x, y);
            }
        }
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        ByteOrder bo;
        int totalBytes = count * 16;
        int off = 0;
        ByteOrder byteOrder = bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        while (off < totalBytes) {
            int len = Math.min(4096, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int end = len / 16;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                double x = byteBuffer.getDouble(i * 16);
                double y = byteBuffer.getDouble(i * 16 + 8);
                this.values[i + start] = new Double2(x, y);
            }
            off += len;
            start += end;
        }
    }

    @Override
    public Scalar get(int index) {
        return new BasicPoint(this.values[index].x, this.values[index].y);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        Double2[] sub = new Double2[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicPointVector(sub, false);
    }

    protected Double2[] getSubArray(int[] indices) {
        int length = indices.length;
        Double2[] sub = new Double2[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return sub;
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
        this.values[index].x = ((BasicPoint)value).getX();
        this.values[index].y = ((BasicPoint)value).getY();
    }

    public void setPoint(int index, double x, double y) {
        this.values[index].x = x;
        this.values[index].y = y;
    }

    @Override
    public int hashBucket(int index, int buckets) {
        return this.values[index].hashBucket(buckets);
    }

    @Override
    public Vector combine(Vector vector) {
        BasicPointVector v = (BasicPointVector)vector;
        int newSize = this.rows() + v.rows();
        Double2[] newValue = new Double2[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicPointVector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index].isNull();
    }

    @Override
    public void setNull(int index) {
        this.values[index].setNull();
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.BINARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_POINT;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicPoint.class;
    }

    @Override
    public int rows() {
        return this.values.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeDouble2Array(this.values);
    }

    @Override
    public int asof(Scalar value) {
        throw new RuntimeException("BasicPointVector.asof not supported.");
    }

    @Override
    protected ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        for (Double2 val : this.values) {
            buffer.putDouble(val.x);
            buffer.putDouble(val.y);
        }
        return buffer;
    }
}

