/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicInt;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;

public class BasicSecond
extends BasicInt {
    private static DateTimeFormatter format = DateTimeFormatter.ofPattern("HH:mm:ss");

    public BasicSecond(LocalTime value) {
        super(Utils.countSeconds(value));
    }

    public BasicSecond(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public BasicSecond(int value) {
        super(value);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_SECOND;
    }

    public LocalTime getSecond() {
        if (this.isNull()) {
            return null;
        }
        return Utils.parseSecond(this.getInt());
    }

    @Override
    public Temporal getTemporal() throws Exception {
        return this.getSecond();
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        return this.getSecond().format(format);
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return "\"" + this.getString() + "\"";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BasicSecond) || o == null) {
            return false;
        }
        return this.getInt() == ((BasicSecond)o).getInt();
    }
}

