/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.HashMap;

public interface Entity {
    public DATA_FORM getDataForm();

    public DATA_CATEGORY getDataCategory();

    public DATA_TYPE getDataType();

    public int rows();

    public int columns();

    public String getString();

    public void write(ExtendedDataOutput var1) throws IOException;

    default public void writeCompressed(ExtendedDataOutput output) throws IOException {
        throw new IOException("Only BasicTable and BasicVector support compression");
    }

    public boolean isScalar();

    public boolean isVector();

    public boolean isPair();

    public boolean isTable();

    public boolean isMatrix();

    public boolean isDictionary();

    public boolean isChart();

    public boolean isChunk();

    public static DATA_CATEGORY typeToCategory(DATA_TYPE type) {
        if (type == DATA_TYPE.DT_TIME || type == DATA_TYPE.DT_SECOND || type == DATA_TYPE.DT_MINUTE || type == DATA_TYPE.DT_DATE || type == DATA_TYPE.DT_DATETIME || type == DATA_TYPE.DT_MONTH || type == DATA_TYPE.DT_TIMESTAMP || type == DATA_TYPE.DT_NANOTIME || type == DATA_TYPE.DT_NANOTIMESTAMP || type == DATA_TYPE.DT_DATEHOUR || type == DATA_TYPE.DT_DATEMINUTE) {
            return DATA_CATEGORY.TEMPORAL;
        }
        if (type == DATA_TYPE.DT_INT || type == DATA_TYPE.DT_LONG || type == DATA_TYPE.DT_SHORT || type == DATA_TYPE.DT_BYTE) {
            return DATA_CATEGORY.INTEGRAL;
        }
        if (type == DATA_TYPE.DT_BOOL) {
            return DATA_CATEGORY.LOGICAL;
        }
        if (type == DATA_TYPE.DT_DOUBLE || type == DATA_TYPE.DT_FLOAT) {
            return DATA_CATEGORY.FLOATING;
        }
        if (type == DATA_TYPE.DT_STRING || type == DATA_TYPE.DT_SYMBOL) {
            return DATA_CATEGORY.LITERAL;
        }
        if (type == DATA_TYPE.DT_INT128 || type == DATA_TYPE.DT_UUID || type == DATA_TYPE.DT_IPADDR) {
            return DATA_CATEGORY.BINARY;
        }
        if (type == DATA_TYPE.DT_ANY) {
            return DATA_CATEGORY.MIXED;
        }
        if (type == DATA_TYPE.DT_VOID) {
            return DATA_CATEGORY.NOTHING;
        }
        return DATA_CATEGORY.SYSTEM;
    }

    public static enum DURATION {
        NS,
        US,
        MS,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        YEAR,
        BDAY;

    }

    public static enum PARTITION_TYPE {
        SEQ,
        VALUE,
        RANGE,
        LIST,
        COMPO,
        HASH;

    }

    public static enum DATA_FORM {
        DF_SCALAR,
        DF_VECTOR,
        DF_PAIR,
        DF_MATRIX,
        DF_SET,
        DF_DICTIONARY,
        DF_TABLE,
        DF_CHART,
        DF_CHUNK;

    }

    public static enum DATA_CATEGORY {
        NOTHING,
        LOGICAL,
        INTEGRAL,
        FLOATING,
        TEMPORAL,
        LITERAL,
        SYSTEM,
        MIXED,
        BINARY,
        ARRAY;

    }

    public static enum DATA_TYPE {
        DT_VOID("VOID", 0),
        DT_BOOL("BOOL", 1),
        DT_BYTE("CHAR", 2),
        DT_SHORT("SHORT", 3),
        DT_INT("INT", 4),
        DT_LONG("LONG", 5),
        DT_DATE("DATE", 6),
        DT_MONTH("MONTH", 7),
        DT_TIME("TIME", 8),
        DT_MINUTE("MINUTE", 9),
        DT_SECOND("SECOND", 10),
        DT_DATETIME("DATETIME", 11),
        DT_TIMESTAMP("TIMESTAMP", 12),
        DT_NANOTIME("NANOTIME", 13),
        DT_NANOTIMESTAMP("NANOTIMESTAMP", 14),
        DT_FLOAT("FLOAT", 15),
        DT_DOUBLE("DOUBLE", 16),
        DT_SYMBOL("SYMBOL", 17),
        DT_STRING("STRING", 18),
        DT_UUID("UUID", 19),
        DT_FUNCTIONDEF("FUNCTIONDEF", 20),
        DT_HANDLE("HANDLE", 21),
        DT_CODE("CODE", 22),
        DT_DATASOURCE("DATASOURCE", 23),
        DT_RESOURCE("RESOURCE", 24),
        DT_ANY("ANY", 25),
        DT_COMPRESS("COMPRESS", 26),
        DT_DICTIONARY("DICTIONARY", 27),
        DT_DATEHOUR("DATEHOUR", 28),
        DT_DATEMINUTE("DATEMINUTE", 29),
        DT_IPADDR("IPADDR", 30),
        DT_INT128("INT128", 31),
        DT_BLOB("BLOB", 32),
        DT_DECIMAL("DECIMAL", 33),
        DT_COMPLEX("COMPLEX", 34),
        DT_POINT("POINT", 35),
        DT_DURATION("DURATION", 36),
        DT_OBJECT("OBJECT", 37),
        DT_BOOL_ARRAY("BOOL[]", 65),
        DT_BYTE_ARRAY("CHAR[]", 66),
        DT_SHORT_ARRAY("SHORT[]", 67),
        DT_INT_ARRAY("INT[]", 68),
        DT_LONG_ARRAY("LONG[]", 69),
        DT_DATE_ARRAY("DATE[]", 70),
        DT_MONTH_ARRAY("MONTH[]", 71),
        DT_TIME_ARRAY("TIME[]", 72),
        DT_MINUTE_ARRAY("MINUTE[]", 73),
        DT_SECOND_ARRAY("SECOND[]", 74),
        DT_DATETIME_ARRAY("DATETIME[]", 75),
        DT_TIMESTAMP_ARRAY("TIMESTAMP[]", 76),
        DT_NANOTIME_ARRAY("NANOTIME[]", 77),
        DT_NANOTIMESTAMP_ARRAY("NANOTIMESTAMP[]", 78),
        DT_FLOAT_ARRAY("FLOAT[]", 79),
        DT_DOUBLE_ARRAY("DOUBLE[]", 80),
        DT_SYMBOL_ARRAY("SYMBOL[]", 81),
        DT_STRING_ARRAY("STRING[]", 82),
        DT_UUID_ARRAY("UUID[]", 83),
        DT_DATEHOUR_ARRAY("DATEHOUR[]", 92),
        DT_DATEMINUTE_ARRAY("DATEMINUTE[]", 93),
        DT_IPADDR_ARRAY("IPADDR[]", 94),
        DT_INT128_ARRAY("INT128[]", 95),
        DT_DECIMAL_ARRAY("DECIMAL[]", 97),
        DT_COMPLEX_ARRAY("COMPLEX[]", 98),
        DT_POINT_ARRAY("POINT[]", 99);

        private final String name;
        private final int value;
        private static HashMap<String, DATA_TYPE> nameMap;
        private static HashMap<Integer, DATA_TYPE> valueMap;

        private DATA_TYPE(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }

        public static DATA_TYPE valueOf(int type) {
            DATA_TYPE enumType = valueMap.get(type);
            if (enumType == null) {
                throw new RuntimeException("Can't find enum DATA_TYPE for value " + String.valueOf(type));
            }
            return enumType;
        }

        public static DATA_TYPE valueOfTypeName(String name) {
            DATA_TYPE enumType = nameMap.get(name);
            if (enumType == null) {
                throw new RuntimeException("Can't find enum DATA_TYPE for type name " + name);
            }
            return enumType;
        }

        static {
            nameMap = new HashMap();
            valueMap = new HashMap();
            for (DATA_TYPE type : DATA_TYPE.values()) {
                nameMap.put(type.getName(), type);
                valueMap.put(type.getValue(), type);
            }
        }
    }
}

