/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.time.temporal.Temporal;

public class BasicString
extends AbstractScalar
implements Comparable<BasicString> {
    private String value;

    public BasicString(String value) {
        this.value = value;
    }

    public BasicString(ExtendedDataInput in) throws IOException {
        this.value = in.readString();
    }

    @Override
    public String getString() {
        return this.value;
    }

    protected void setString(String value) {
        this.value = value;
    }

    @Override
    public boolean isNull() {
        return this.value.isEmpty();
    }

    @Override
    public void setNull() {
        this.value = "";
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.LITERAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_STRING;
    }

    @Override
    public Number getNumber() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicString) || o == null) {
            return false;
        }
        return this.value.equals(((BasicString)o).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeString(this.value);
    }

    @Override
    public int compareTo(BasicString o) {
        return this.value.compareTo(o.value);
    }
}

