/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.route;

import com.xxdb.DBConnection;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TableAppender {
    private DBConnection conn;
    private BasicDictionary tableInfo;
    private BasicString tableName;
    private int cols;

    public TableAppender(String tableName, String host, int port) throws IOException {
        this.tableName = new BasicString(tableName);
        this.conn = new DBConnection();
        this.conn.connect(host, port);
        this.tableInfo = (BasicDictionary)this.conn.run("schema(" + tableName + ")");
        int partitionColumnIdx = ((BasicInt)this.tableInfo.get(new BasicString("partitionColumnIndex"))).getInt();
        if (partitionColumnIdx != -1) {
            throw new RuntimeException("Table '" + tableName + "' is partitioned");
        }
        BasicTable colDefs = (BasicTable)this.tableInfo.get(new BasicString("colDefs"));
        this.cols = colDefs.getColumn(0).rows();
    }

    public int append(List<Entity> row) throws IOException {
        if (row.size() != this.cols) {
            throw new RuntimeException("expect " + this.cols + " columns of values, got " + row.size() + " columns of values");
        }
        ArrayList<Entity> args = new ArrayList<Entity>();
        args.add(this.tableName);
        args.addAll(row);
        BasicInt affected = (BasicInt)this.conn.run("tableInsert", args);
        return affected.getInt();
    }
}

