/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.route;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.route.TableRouter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class LiteralListPartitionedTableRouter
implements TableRouter {
    private Map<String, List<String>> locationMap;

    LiteralListPartitionedTableRouter(AbstractVector values, BasicAnyVector locations) {
        this.initialize(values, locations);
    }

    private void initialize(AbstractVector values, BasicAnyVector locations) {
        int j;
        int i;
        boolean isScalar;
        if (values.getDataType() != Entity.DATA_TYPE.DT_ANY || values.getDataForm() != Entity.DATA_FORM.DF_VECTOR) {
            throw new RuntimeException("expect a vector of partitioning lists");
        }
        if (values.rows() <= 0) {
            throw new RuntimeException("requires at least one partitioning list");
        }
        if (locations.rows() <= 0) {
            throw new RuntimeException("requires at least one location");
        }
        if (locations.getEntity(0).getDataType() != Entity.DATA_TYPE.DT_STRING) {
            throw new RuntimeException("location must be a string");
        }
        if (values.rows() != locations.rows()) {
            throw new RuntimeException("expect # locations == # partitioning lists");
        }
        this.locationMap = new HashMap<String, List<String>>();
        List[] locationListArray = new List[locations.rows()];
        boolean bl = isScalar = locations.getEntity(0).getDataForm() == Entity.DATA_FORM.DF_SCALAR;
        if (isScalar) {
            for (i = 0; i < locations.rows(); ++i) {
                BasicString location = (BasicString)locations.get(i);
                locationListArray[i] = Arrays.asList(location.getString());
            }
        } else {
            for (i = 0; i < locations.rows(); ++i) {
                BasicStringVector locationVector = (BasicStringVector)locations.getEntity(i);
                locationListArray[i] = new ArrayList();
                for (j = 0; j < locationVector.rows(); ++j) {
                    BasicString location = (BasicString)locationVector.get(j);
                    locationListArray[i].add(location.getString());
                }
            }
        }
        for (i = 0; i < values.rows(); ++i) {
            AbstractVector partitioningList = (AbstractVector)((BasicAnyVector)values).getEntity(i);
            if (partitioningList.rows() <= 0) {
                throw new RuntimeException("expect partitioning list to be nonempty");
            }
            if (partitioningList.getDataCategory() != Entity.DATA_CATEGORY.LITERAL) {
                throw new RuntimeException("expect partitioning column values to be LITERAL.");
            }
            for (j = 0; j < partitioningList.rows(); ++j) {
                try {
                    String val = partitioningList.get(j).getString();
                    this.locationMap.put(val, locationListArray[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public String route(Scalar partitionColumn) {
        if (partitionColumn.getDataCategory() != Entity.DATA_CATEGORY.LITERAL) {
            throw new RuntimeException("invalid column category type" + partitionColumn.getDataCategory().name() + ", expect LITERAL category.");
        }
        try {
            String stringVal = partitionColumn.getString();
            List<String> locations = this.locationMap.get(stringVal);
            if (locations == null) {
                throw new RuntimeException(partitionColumn.getNumber().longValue() + " not in any partitioning list!");
            }
            return locations.get(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

