/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb;

import com.xxdb.DBConnection;
import com.xxdb.DBTask;
import com.xxdb.data.Entity;
import java.util.List;
import java.util.concurrent.Semaphore;

public class BasicDBTask
implements DBTask {
    private String script;
    private List<Entity> args;
    private DBConnection conn;
    private Entity result = null;
    private String errMsg = null;
    private boolean successful = false;
    private Semaphore semaphore = new Semaphore(1);

    public void waitFor() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void finish() {
        this.semaphore.release();
    }

    public BasicDBTask(String script, List<Entity> args) {
        this.script = script;
        this.args = args;
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public BasicDBTask(String script) {
        this.script = script;
        this.args = null;
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public Entity call() {
        try {
            this.result = this.args != null ? this.conn.run(this.script, this.args) : this.conn.run(this.script);
            this.errMsg = null;
            this.successful = true;
            return this.result;
        }
        catch (Exception t) {
            this.successful = false;
            this.result = null;
            this.errMsg = t.getMessage();
            return null;
        }
    }

    @Override
    public void setDBConnection(DBConnection conn) {
        this.conn = conn;
    }

    @Override
    public Entity getResult() {
        return this.result;
    }

    @Override
    public String getErrorMsg() {
        return this.errMsg;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public boolean isFinished() {
        return this.successful || this.errMsg.length() > 0;
    }
}

