/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.compression;

import com.xxdb.compression.AbstractDecoder;
import com.xxdb.compression.DeltaOfDeltaBlockDecoder;
import com.xxdb.io.BigEndianDataInputStream;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.LittleEndianDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DeltaOfDeltaDecoder
extends AbstractDecoder {
    @Override
    public ExtendedDataInput decompress(DataInput in, int length, int unitLength, int elementCount, boolean isLittleEndian, int extra) throws IOException {
        int blockSize;
        long[] src;
        int offset = 8;
        ByteBuffer dest = this.createColumnVector(elementCount, unitLength, isLittleEndian, 0, extra);
        byte[] out = dest.array();
        int outLength = out.length - offset;
        DeltaOfDeltaBlockDecoder blockDecoder = new DeltaOfDeltaBlockDecoder(unitLength);
        for (int count = 0; length > 0 && count < outLength; count += blockDecoder.decompress(src, dest) * unitLength, length -= blockSize) {
            blockSize = in.readInt();
            if (blockSize < 0) {
                blockSize &= Integer.MAX_VALUE;
            }
            if ((blockSize = Math.min(blockSize, length -= 4)) == 0) break;
            src = new long[blockSize / 8];
            for (int i = 0; i < src.length; ++i) {
                src[i] = in.readLong();
            }
        }
        return isLittleEndian ? new LittleEndianDataInputStream(new ByteArrayInputStream(out)) : new BigEndianDataInputStream(new ByteArrayInputStream(out));
    }
}

