/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.io.Long2;
import java.io.IOException;
import java.time.temporal.Temporal;

public class BasicInt128
extends AbstractScalar {
    protected Long2 value;

    public BasicInt128(long high, long low) {
        this.value = new Long2(high, low);
    }

    public BasicInt128(ExtendedDataInput in) throws IOException {
        this.value = in.readLong2();
    }

    public Long2 getLong2() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value.isNull();
    }

    @Override
    public void setNull() {
        this.value.setNull();
    }

    public long getMostSignicantBits() {
        return this.value.high;
    }

    public long getLeastSignicantBits() {
        return this.value.low;
    }

    @Override
    public Number getNumber() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.BINARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_INT128;
    }

    @Override
    public String getString() {
        return String.format("%016x%016x", this.value.high, this.value.low);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicInt128) || o == null) {
            return false;
        }
        return this.value.equals(((BasicInt128)o).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int hashBucket(int buckets) {
        return this.value.hashBucket(buckets);
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return "\"" + this.getString() + "\"";
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeLong2(this.value);
    }

    public static BasicInt128 fromString(String num) {
        if (num.length() != 32) {
            throw new NumberFormatException("Invalid int128 string.");
        }
        long high = Long.parseUnsignedLong(num.substring(0, 16), 16);
        long low = Long.parseUnsignedLong(num.substring(16), 16);
        return new BasicInt128(high, low);
    }
}

