/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.SymbolBase;
import com.xxdb.data.SymbolBaseCollection;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.route.BitConverter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class BasicStringVector
extends AbstractVector {
    private String[] values;
    private boolean isSymbol;
    private boolean isBlob = false;
    private List<byte[]> blobValues;

    public BasicStringVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size, false);
    }

    public BasicStringVector(List<String> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i) != null ? list.get(i) : "";
            }
        }
        this.isSymbol = false;
    }

    public BasicStringVector(List<String> list, boolean blob) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (blob) {
            int rows = list.size();
            this.blobValues = new ArrayList<byte[]>();
            for (int i = 0; i < rows; ++i) {
                this.blobValues.add(list.get(i).getBytes(StandardCharsets.UTF_8));
            }
        }
        if (list != null) {
            this.values = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i) != null ? list.get(i) : "";
            }
        }
        this.isSymbol = false;
        this.isBlob = blob;
    }

    public BasicStringVector(byte[][] array) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.blobValues = new ArrayList<byte[]>(array.length);
        ArrayList<byte[]> arraycopy = new ArrayList<byte[]>();
        for (int i = 0; i < array.length; ++i) {
            arraycopy.add(array[i]);
        }
        this.blobValues.addAll(arraycopy);
        this.isBlob = true;
    }

    public BasicStringVector(String[] array) {
        this(array, false, true);
    }

    public BasicStringVector(String[] array, boolean blob) {
        this(array, blob, true);
    }

    public BasicStringVector(String[] array, boolean blob, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (blob) {
            if (copy) {
                String[] valuecopy = (String[])array.clone();
                for (int i = 0; i < valuecopy.length; ++i) {
                    this.blobValues.add(valuecopy[i].getBytes(StandardCharsets.UTF_8));
                }
            } else {
                for (int i = 0; i < this.values.length; ++i) {
                    this.blobValues.add(array[i].getBytes(StandardCharsets.UTF_8));
                }
            }
        } else {
            this.values = copy ? (String[])array.clone() : array;
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] != null) continue;
                this.values[i] = "";
            }
        }
        this.isSymbol = false;
        this.isBlob = blob;
    }

    protected BasicStringVector(Entity.DATA_FORM df, int size, boolean isSymbol) {
        super(df);
        this.values = new String[size];
        this.isSymbol = isSymbol;
    }

    protected BasicStringVector(Entity.DATA_FORM df, int size, boolean isSymbol, boolean isBlob) {
        super(df);
        if (isBlob) {
            this.blobValues = new ArrayList<byte[]>(size);
            for (int i = 0; i < size; ++i) {
                this.blobValues.add(null);
            }
        } else {
            this.values = new String[size];
        }
        this.isSymbol = isSymbol;
        this.isBlob = isBlob;
    }

    protected BasicStringVector(Entity.DATA_FORM df, ExtendedDataInput in, boolean isSymbol, boolean blob) throws IOException {
        super(df);
        this.isBlob = blob;
        this.isSymbol = isSymbol;
        int rows = in.readInt();
        int columns = in.readInt();
        int size = rows * columns;
        if (blob) {
            this.blobValues = new ArrayList<byte[]>(rows);
            for (int i = 0; i < rows; ++i) {
                this.blobValues.add(in.readBlob());
            }
        } else {
            this.values = new String[size];
            for (int i = 0; i < size; ++i) {
                this.values[i] = in.readString();
            }
        }
    }

    protected BasicStringVector(Entity.DATA_FORM df, ExtendedDataInput in, boolean blob, SymbolBaseCollection collection) throws IOException {
        super(df);
        this.isBlob = blob;
        int rows = in.readInt();
        int columns = in.readInt();
        int size = rows * columns;
        if (!blob) {
            this.values = new String[size];
            if (collection != null) {
                SymbolBase symbase = collection.add(in);
                for (int i = 0; i < size; ++i) {
                    this.values[i] = symbase.getSymbol(in.readInt());
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    this.values[i] = in.readString();
                }
            }
        } else {
            this.blobValues = new ArrayList<byte[]>(size);
            for (int i = 0; i < size; ++i) {
                this.blobValues.add(in.readBlob());
            }
        }
    }

    @Override
    public Scalar get(int index) {
        if (this.isBlob) {
            return new BasicString(this.blobValues.get(index), true);
        }
        return new BasicString(this.values[index], false);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        if (this.isBlob) {
            String[] subBlobV = new String[length];
            for (int i = 0; i < length; ++i) {
                subBlobV[i] = new String(this.blobValues.get(indices[i]), StandardCharsets.UTF_8);
            }
            return new BasicStringVector(subBlobV, true, false);
        }
        String[] sub = new String[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicStringVector(sub, false, false);
    }

    @Override
    public String getString(int index) {
        if (this.isBlob) {
            return new String(this.blobValues.get(index), StandardCharsets.UTF_8);
        }
        return this.values[index];
    }

    @Override
    public int getUnitLength() {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(int index, Scalar value) throws Exception {
        if (this.isBlob) {
            if (value.getDataType() != Entity.DATA_TYPE.DT_BLOB) throw new Exception("The value must be a blob scalar. ");
            this.blobValues.set(index, ((BasicString)value).getBytes());
            return;
        } else {
            if (value.getDataType() != Entity.DATA_TYPE.DT_STRING) throw new Exception("The value must be a string scalar. ");
            this.values[index] = ((BasicString)value).getString();
        }
    }

    public void setString(int index, String value) {
        if (this.isBlob) {
            this.blobValues.set(index, value.getBytes(StandardCharsets.UTF_8));
        } else {
            this.values[index] = value;
        }
    }

    @Override
    public int hashBucket(int index, int buckets) {
        return this.get(index).hashBucket(buckets);
    }

    @Override
    public Vector combine(Vector vector) {
        BasicStringVector v = (BasicStringVector)vector;
        int newSize = this.rows() + v.rows();
        String[] newValue = new String[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicStringVector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        if (this.isBlob) {
            return this.blobValues.get(index).length == 0;
        }
        return this.values[index] == null || this.values[index].length() == 0;
    }

    @Override
    public void setNull(int index) {
        if (this.isBlob) {
            this.blobValues.set(index, new byte[0]);
        } else {
            this.values[index] = "";
        }
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.LITERAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        if (this.isBlob) {
            return Entity.DATA_TYPE.DT_BLOB;
        }
        return this.isSymbol ? Entity.DATA_TYPE.DT_SYMBOL : Entity.DATA_TYPE.DT_STRING;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicString.class;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        if (this.isBlob) {
            for (int i = 0; i < count; ++i) {
                out.writeBlob(this.blobValues.get(start + i));
            }
        } else {
            for (int i = 0; i < count; ++i) {
                out.writeString(this.values[start + i]);
            }
        }
    }

    @Override
    public int rows() {
        if (this.isBlob) {
            return this.blobValues.size();
        }
        return this.values.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        if (this.isBlob) {
            for (byte[] str : this.blobValues) {
                out.writeBlob(str);
            }
        } else {
            for (String str : this.values) {
                if (str == null) {
                    out.writeString("");
                    continue;
                }
                out.writeString(str);
            }
        }
    }

    private static int compare(byte[] b1, byte[] b2) {
        int minLength = Math.min(b1.length, b2.length);
        for (int i = 0; i < minLength; ++i) {
            if (b1[i] < b2[i]) {
                return -1;
            }
            if (b1[i] <= b2[i]) continue;
            return 1;
        }
        if (b1.length > b2.length) {
            return 1;
        }
        if (b1.length == b2.length) {
            return 0;
        }
        return -1;
    }

    @Override
    public int asof(Scalar value) {
        if (this.isBlob) {
            if (value.getDataType() != Entity.DATA_TYPE.DT_BLOB) {
                throw new RuntimeException("value must be a blob scalar. ");
            }
            byte[] target = ((BasicString)value).getBytes();
            int start = 0;
            int end = this.blobValues.size() - 1;
            while (start <= end) {
                int mid = (start + end) / 2;
                if (BasicStringVector.compare(this.blobValues.get(mid), target) <= 0) {
                    start = mid + 1;
                    continue;
                }
                end = mid - 1;
            }
            return end;
        }
        String target = value.getString();
        int start = 0;
        int end = this.values.length - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.values[mid].compareTo(target) <= 0) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return end;
    }

    @Override
    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        if (this.isBlob) {
            for (byte[] val : this.blobValues) {
                while (val.length + 1 + buffer.position() > buffer.limit()) {
                    buffer = Utils.reAllocByteBuffer(buffer, Math.max(buffer.capacity() * 2, 1024));
                }
                buffer.putInt(val.length);
                buffer.put(val);
            }
        } else {
            for (String val : this.values) {
                byte[] tmp = val.getBytes(StandardCharsets.UTF_8);
                while (tmp.length + 1 + buffer.position() > buffer.limit()) {
                    buffer = Utils.reAllocByteBuffer(buffer, Math.max(buffer.capacity() * 2, 1024));
                }
                buffer.put(tmp, 0, tmp.length);
                buffer.put((byte)0);
            }
        }
        return buffer;
    }

    public int serialize(byte[] buf, int bufSize, int start, int elementCount, AbstractVector.Offect offect) {
        int count;
        int len = 0;
        int total = this.blobValues.size();
        if (this.isBlob) {
            byte[] str;
            int strLen;
            for (count = 0; len < bufSize && count < elementCount && start + count < total && (strLen = (str = this.blobValues.get(start + count)).length) + 4 + 1 < bufSize - len; len += strLen + 4, ++count) {
                byte[] lenTmp = BitConverter.getBytes(strLen);
                System.arraycopy(lenTmp, 0, buf, len, 4);
                System.arraycopy(str, 0, buf, len + 4, strLen);
            }
        } else {
            String str;
            int strLen;
            while (len < bufSize && count < elementCount && start + count < total && (strLen = (str = this.values[start + count]).length()) + 1 < bufSize - len) {
                byte[] strTmp = str.getBytes(Charset.defaultCharset());
                System.arraycopy(strTmp, 0, buf, len, strLen);
                buf[(len += strLen + 1) - 1] = 0;
                ++count;
            }
        }
        offect.offect = start + count;
        return len;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        int readByte = 0;
        targetNumElement = Math.min(targetNumElement, this.isBlob ? this.blobValues.size() - indexStart : this.values.length - indexStart);
        numElementAndPartial.numElement = 0;
        int i = 0;
        while (i < targetNumElement) {
            byte[] data;
            if (this.isBlob) {
                data = this.blobValues.get(i);
                if (4 + data.length > out.remaining()) break;
                out.putInt(data.length);
                out.put(data);
                readByte += 4 + data.length;
            } else {
                data = this.values[indexStart + i].getBytes(Charset.defaultCharset());
                if (1 + data.length > out.remaining()) break;
                out.put(data);
                out.put((byte)0);
                readByte += 1 + data.length;
            }
            ++i;
            ++numElementAndPartial.numElement;
        }
        numElementAndPartial.partial = 0;
        if (numElementAndPartial.numElement == 0) {
            throw new RuntimeException("too large data. ");
        }
        return readByte;
    }
}

