/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.compression.VectorDecompressor;
import com.xxdb.data.AbstractEntity;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicSymbolVector;
import com.xxdb.data.Entity;
import com.xxdb.data.SymbolBaseCollection;
import com.xxdb.data.Table;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicTable
extends AbstractEntity
implements Table {
    private List<Vector> columns_ = new ArrayList<Vector>();
    private List<String> names_ = new ArrayList<String>();
    private Map<String, Integer> name2index_ = new HashMap<String, Integer>();
    private int[] colCompresses_ = null;

    public BasicTable(ExtendedDataInput in) throws IOException {
        int rows = in.readInt();
        int cols = in.readInt();
        String tableName = in.readString();
        for (int i = 0; i < cols; ++i) {
            String name = in.readString();
            this.name2index_.put(name, this.name2index_.size());
            this.names_.add(name);
        }
        VectorDecompressor decompressor = null;
        SymbolBaseCollection collection = null;
        for (int i = 0; i < cols; ++i) {
            Vector vector;
            boolean extended;
            short flag = in.readShort();
            int form = flag >> 8;
            int type = flag & 0xFF;
            boolean bl = extended = type >= 128;
            if (type >= 128) {
                type -= 128;
            }
            Entity.DATA_FORM df = Entity.DATA_FORM.values()[form];
            Entity.DATA_TYPE dt = Entity.DATA_TYPE.valueOf(type);
            if (df != Entity.DATA_FORM.DF_VECTOR) {
                throw new IOException("Invalid form for column [" + this.names_.get(i) + "] for table " + tableName);
            }
            if (dt == Entity.DATA_TYPE.DT_SYMBOL && extended) {
                if (collection == null) {
                    collection = new SymbolBaseCollection();
                }
                vector = new BasicSymbolVector(df, in, collection);
            } else if (dt == Entity.DATA_TYPE.DT_COMPRESS) {
                if (decompressor == null) {
                    decompressor = new VectorDecompressor();
                }
                vector = decompressor.decompress(BasicEntityFactory.instance(), in, extended, true);
            } else {
                vector = (Vector)BasicEntityFactory.instance().createEntity(df, dt, in, extended);
            }
            if (vector.rows() != rows && vector.rows() != 1) {
                throw new IOException("The number of rows for column " + this.names_.get(i) + " is not consistent with other columns");
            }
            this.columns_.add(vector);
        }
        if (collection != null) {
            collection.clear();
        }
    }

    public BasicTable(List<String> colNames, List<Vector> cols) {
        if (colNames.size() != cols.size()) {
            throw new Error("The length of column name and column data is unequal.");
        }
        int rowsCount = cols.get(0).rows();
        for (int i = 0; i < cols.size(); ++i) {
            Vector v = cols.get(i);
            if (v.rows() == rowsCount) continue;
            throw new Error("The length of column " + colNames.get(i) + "  must be the same as the first column length.");
        }
        this.setColName(colNames);
        this.setColumns(cols);
    }

    @Override
    public void setColumnCompressTypes(int[] colCompresses) {
        if (colCompresses != null && colCompresses.length != this.columns_.size()) {
            throw new RuntimeException("Compress type size must match column size " + this.columns_.size() + ".");
        }
        if (colCompresses != null) {
            for (int i = 0; i < colCompresses.length; ++i) {
                if (colCompresses[i] != 2) continue;
                Vector column = this.getColumn(i);
                Entity.DATA_TYPE dataType = column.getDataType();
                if (column.getDataCategory() != Entity.DATA_CATEGORY.TEMPORAL && dataType != Entity.DATA_TYPE.DT_SHORT && dataType != Entity.DATA_TYPE.DT_INT && dataType != Entity.DATA_TYPE.DT_LONG) {
                    throw new RuntimeException("Delta compression only supports short/int/long and temporal data.");
                }
                if (dataType.getValue() < Entity.DATA_TYPE.DT_BOOL_ARRAY.getValue() || dataType.getValue() > Entity.DATA_TYPE.DT_POINT_ARRAY.getValue()) continue;
                throw new RuntimeException("Delta compression doesn't support array vector.");
            }
        }
        if (colCompresses != null) {
            this.colCompresses_ = new int[colCompresses.length];
            System.arraycopy(colCompresses, 0, this.colCompresses_, 0, colCompresses.length);
        } else {
            this.colCompresses_ = null;
        }
    }

    public void setColName(List<String> colNames) {
        this.names_.clear();
        this.name2index_.clear();
        for (String name : colNames) {
            this.names_.add(name);
            this.name2index_.put(name, this.name2index_.size());
        }
    }

    public void setColumns(List<Vector> cols) {
        this.columns_.clear();
        for (Vector vector : cols) {
            this.columns_.add(vector);
        }
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.MIXED;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DICTIONARY;
    }

    @Override
    public Entity.DATA_FORM getDataForm() {
        return Entity.DATA_FORM.DF_TABLE;
    }

    @Override
    public int rows() {
        if (this.columns() <= 0) {
            return 0;
        }
        return this.columns_.get(0).rows();
    }

    @Override
    public int columns() {
        return this.columns_.size();
    }

    @Override
    public Vector getColumn(int index) {
        return this.columns_.get(index);
    }

    @Override
    public Vector getColumn(String name) {
        Integer index = this.name2index_.get(name);
        if (index == null) {
            return null;
        }
        return this.getColumn(index);
    }

    @Override
    public String getColumnName(int index) {
        return this.names_.get(index);
    }

    @Override
    public String getString() {
        int i;
        int rows = Math.min(20, this.rows());
        int strColMaxWidth = 100 / Math.min(this.columns(), 100) + 5;
        int length = 0;
        int curCol = 0;
        StringBuilder[] list = new StringBuilder[rows + 1];
        StringBuilder separator = new StringBuilder();
        String[] listTmp = new String[rows + 1];
        for (i = 0; i < list.length; ++i) {
            list[i] = new StringBuilder();
        }
        while (length < 100 && curCol < this.columns()) {
            listTmp[0] = this.getColumnName(curCol);
            int maxColWidth = 0;
            for (i = 0; i < rows; ++i) {
                listTmp[i + 1] = this.getColumn(curCol).get(i).getString();
                if (listTmp[i + 1].length() <= maxColWidth) continue;
                maxColWidth = listTmp[i + 1].length();
            }
            if (maxColWidth > strColMaxWidth && this.getColumn(curCol).getDataCategory() == Entity.DATA_CATEGORY.LITERAL) {
                maxColWidth = strColMaxWidth;
            }
            if (listTmp[0].length() > maxColWidth) {
                maxColWidth = Math.min(strColMaxWidth, listTmp[0].length());
            }
            if (length + maxColWidth > 100 && curCol + 1 < this.columns()) break;
            for (int k = 0; k < maxColWidth; ++k) {
                separator.append('-');
            }
            if (curCol < this.columns() - 1) {
                ++maxColWidth;
                separator.append(' ');
            }
            for (i = 0; i <= rows; ++i) {
                int curSize = listTmp[i].length();
                if (curSize <= maxColWidth) {
                    list[i].append(listTmp[i]);
                    if (curSize >= maxColWidth) continue;
                    for (int j = 0; j < maxColWidth - curSize; ++j) {
                        list[i].append(' ');
                    }
                    continue;
                }
                if (maxColWidth > 3) {
                    list[i].append(listTmp[i].substring(0, maxColWidth - 3));
                }
                list[i].append("...");
                separator.append("---");
            }
            length += maxColWidth;
            ++curCol;
        }
        if (curCol < this.columns()) {
            for (i = 0; i <= rows; ++i) {
                list[i].append("...");
            }
        }
        StringBuilder resultStr = new StringBuilder(list[0]);
        resultStr.append("\n");
        resultStr.append((CharSequence)separator);
        resultStr.append("\n");
        for (i = 1; i <= rows; ++i) {
            resultStr.append((CharSequence)list[i]);
            resultStr.append("\n");
        }
        if (rows < this.rows()) {
            resultStr.append("...\n");
        }
        return resultStr.toString();
    }

    public String getRowJson(int rowIndex) {
        StringBuilder jsonStr = new StringBuilder();
        if (rowIndex < this.rows()) {
            jsonStr.append("{");
            for (int i = 0; i < this.names_.size(); ++i) {
                jsonStr.append(this.names_.get(i));
                jsonStr.append(":");
                jsonStr.append(this.columns_.get(i).get(rowIndex).getJsonString());
                if (i >= this.names_.size() - 1) continue;
                jsonStr.append(",");
            }
            jsonStr.delete(jsonStr.length() - 1, jsonStr.length() - 1);
            jsonStr.append("}");
        }
        return jsonStr.toString();
    }

    @Override
    public void write(ExtendedDataOutput out) throws IOException {
        int flag = (Entity.DATA_FORM.DF_TABLE.ordinal() << 8) + this.getDataType().getValue();
        out.writeShort(flag);
        out.writeInt(this.rows());
        out.writeInt(this.columns());
        out.writeString("");
        for (String colName : this.names_) {
            out.writeString(colName);
        }
        SymbolBaseCollection collection = null;
        for (Vector vector : this.columns_) {
            if (vector instanceof BasicSymbolVector) {
                if (collection == null) {
                    collection = new SymbolBaseCollection();
                }
                ((BasicSymbolVector)vector).write(out, collection);
                continue;
            }
            vector.write(out);
        }
    }

    @Override
    public void writeCompressed(ExtendedDataOutput output) throws IOException {
        int i;
        short flag = (short)(Entity.DATA_FORM.DF_TABLE.ordinal() << 8 | 8);
        output.writeShort(flag);
        int rows = this.rows();
        int cols = this.columns();
        output.writeInt(rows);
        output.writeInt(cols);
        output.writeString("");
        for (i = 0; i < cols; ++i) {
            output.writeString(this.getColumnName(i));
        }
        for (i = 0; i < cols; ++i) {
            AbstractVector v = (AbstractVector)this.getColumn(i);
            if (v.getDataType() == Entity.DATA_TYPE.DT_SYMBOL) {
                v.write(output);
                continue;
            }
            if (this.colCompresses_ != null) {
                v.setCompressedMethod(this.colCompresses_[i]);
            }
            v.writeCompressed(output);
        }
    }

    public BasicTable combine(BasicTable table) {
        ArrayList<Vector> newCol = new ArrayList<Vector>();
        for (int i = 0; i < this.columns(); ++i) {
            newCol.add(this.getColumn(i).combine(table.getColumn(i)));
        }
        return new BasicTable(this.names_, newCol);
    }

    @Override
    public Table getSubTable(int[] indices) {
        int colCount = this.columns_.size();
        ArrayList<Vector> cols = new ArrayList<Vector>(colCount);
        for (int i = 0; i < colCount; ++i) {
            cols.add(this.columns_.get(i).getSubVector(indices));
        }
        return new BasicTable(this.names_, cols);
    }

    @Override
    public void addColumn(String colName, Vector col) {
        this.names_.add(colName);
        this.name2index_.put(colName, this.name2index_.size());
        this.columns_.add(col);
    }
}

