/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.multithreadedtablewriter;

import com.xxdb.DBConnection;
import com.xxdb.comm.ErrorCodeInfo;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicArrayVector;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.route.Domain;
import com.xxdb.route.DomainFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class MultithreadedTableWriter {
    private Logger logger_ = Logger.getLogger(this.getClass().getName());
    private String dbName_;
    private String tableName_;
    private int batchSize_;
    private int throttleMilsecond_;
    private boolean isPartionedTable_;
    private boolean hasError_;
    private String partitionedColName_;
    private List<String> colNames_ = new ArrayList<String>();
    private List<String> colTypeString_ = new ArrayList<String>();
    private List<Entity.DATA_TYPE> colTypes_ = new ArrayList<Entity.DATA_TYPE>();
    private int[] compressTypes_ = null;
    private Domain partitionDomain_;
    private int partitionColumnIdx_;
    private int threadByColIndexForNonPartion_;
    private int sentRowsAfterGc_;
    private List<WriterThread> threads_ = new ArrayList<WriterThread>();
    private ErrorCodeInfo errorCodeInfo_ = new ErrorCodeInfo();

    public MultithreadedTableWriter(String hostName, int port, String userId, String password, String dbName, String tableName, boolean useSSL, boolean enableHighAvailability, String[] highAvailabilitySites, int batchSize, float throttle, int threadCount, String partitionCol, int[] compressTypes) throws Exception {
        this.init(hostName, port, userId, password, dbName, tableName, useSSL, enableHighAvailability, highAvailabilitySites, batchSize, throttle, threadCount, partitionCol, compressTypes);
    }

    public MultithreadedTableWriter(String hostName, int port, String userId, String password, String dbName, String tableName, boolean useSSL, boolean enableHighAvailability, String[] highAvailabilitySites, int batchSize, float throttle, int threadCount, String partitionCol) throws Exception {
        this.init(hostName, port, userId, password, dbName, tableName, useSSL, enableHighAvailability, highAvailabilitySites, batchSize, throttle, threadCount, partitionCol, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(String hostName, int port, String userId, String password, String dbName, String tableName, boolean useSSL, boolean enableHighAvailability, String[] highAvailabilitySites, int batchSize, float throttle, int threadCount, String partitionCol, int[] compressTypes) throws Exception {
        DBConnection pConn;
        this.dbName_ = dbName;
        this.tableName_ = tableName;
        this.batchSize_ = batchSize;
        this.throttleMilsecond_ = (int)throttle * 1000;
        this.hasError_ = false;
        if (threadCount < 1) {
            throw new RuntimeException("The parameter threadCount must be greater than or equal to 1.");
        }
        if (batchSize < 1) {
            throw new RuntimeException("The parameter batchSize must be greater than or equal to 1.");
        }
        if (throttle < 0.0f) {
            throw new RuntimeException("The parameter throttle must be greater than or equal to 0.");
        }
        if (threadCount > 1 && partitionCol.length() < 1) {
            throw new RuntimeException("The parameter partitionCol must be specified when threadCount is greater than 1.");
        }
        boolean isCompress = false;
        if (compressTypes != null && compressTypes.length > 0) {
            for (int one : compressTypes) {
                if (one == 1 || one == 2) continue;
                throw new RuntimeException("Unsupported compress method " + one);
            }
            isCompress = true;
            this.compressTypes_ = new int[compressTypes.length];
            System.arraycopy(compressTypes, 0, this.compressTypes_, 0, compressTypes.length);
        }
        if ((pConn = this.newConn(hostName, port, userId, password, dbName, tableName, useSSL, enableHighAvailability, highAvailabilitySites, isCompress)) == null) {
            throw new RuntimeException("Failed to connect to server " + hostName + ":" + port);
        }
        BasicDictionary schema = dbName.isEmpty() ? (BasicDictionary)pConn.run("schema(" + tableName + ")") : (BasicDictionary)pConn.run("schema(loadTable(\"" + dbName + "\",\"" + tableName + "\"))");
        Entity partColNames = schema.get(new BasicString("partitionColumnName"));
        if (partColNames != null) {
            this.isPartionedTable_ = true;
        } else {
            if (!dbName.isEmpty() && threadCount > 1) {
                throw new RuntimeException("The parameter threadCount must be 1 for a dimension table.");
            }
            this.isPartionedTable_ = false;
        }
        BasicTable colDefs = (BasicTable)schema.get(new BasicString("colDefs"));
        BasicIntVector colDefsTypeInt = (BasicIntVector)colDefs.getColumn("typeInt");
        int columnSize = colDefs.rows();
        if (this.compressTypes_ != null && this.compressTypes_.length != columnSize) {
            throw new RuntimeException("The number of elements in parameter compressMethods does not match the column size " + columnSize);
        }
        BasicStringVector colDefsName = (BasicStringVector)colDefs.getColumn("name");
        BasicStringVector colDefsTypeString = (BasicStringVector)colDefs.getColumn("typeString");
        for (int i = 0; i < columnSize; ++i) {
            this.colNames_.add(colDefsName.getString(i));
            if (this.compressTypes_ != null) {
                boolean check = AbstractVector.checkCompressedMethod(Entity.DATA_TYPE.valueOf(colDefsTypeInt.getInt(i)), this.compressTypes_[i]);
                if (!check) throw new RuntimeException("Compression Failed: only support integral and temporal data, not support " + (Object)((Object)Entity.DATA_TYPE.valueOf(colDefsTypeInt.getInt(i))));
                this.colTypes_.add(Entity.DATA_TYPE.valueOf(colDefsTypeInt.getInt(i)));
            } else {
                this.colTypes_.add(Entity.DATA_TYPE.valueOf(colDefsTypeInt.getInt(i)));
            }
            this.colTypeString_.add(colDefsTypeString.getString(i));
        }
        if (this.isPartionedTable_) {
            int partitionType;
            Entity partitionSchema;
            if (partColNames.isScalar()) {
                if (!partColNames.getString().equals(partitionCol)) {
                    throw new RuntimeException("The parameter partionCol must be the partitioning column " + partColNames.getString() + " in the table.");
                }
                this.partitionColumnIdx_ = ((BasicInt)schema.get(new BasicString("partitionColumnIndex"))).getInt();
                partitionSchema = schema.get(new BasicString("partitionSchema"));
                partitionType = ((BasicInt)schema.get(new BasicString("partitionType"))).getInt();
            } else {
                BasicStringVector partColNamesVec = (BasicStringVector)partColNames;
                int dims = partColNamesVec.rows();
                if (dims > 1 && partitionCol.isEmpty()) {
                    throw new RuntimeException("The parameter partitionCol must be specified for a partitioned table.");
                }
                int index = -1;
                for (int i = 0; i < dims; ++i) {
                    if (!partColNamesVec.getString(i).equals(partitionCol)) continue;
                    index = i;
                    break;
                }
                if (index < 0) {
                    throw new RuntimeException("The parameter partionCol must be the partitioning columns in the partitioned table. ");
                }
                this.partitionColumnIdx_ = ((BasicIntVector)schema.get(new BasicString("partitionColumnIndex"))).getInt(index);
                partitionSchema = ((BasicAnyVector)schema.get(new BasicString("partitionSchema"))).getEntity(index);
                partitionType = ((BasicIntVector)schema.get(new BasicString("partitionType"))).getInt(index);
            }
            Entity.DATA_TYPE dataColType = this.colTypes_.get(this.partitionColumnIdx_);
            Entity.PARTITION_TYPE partitionColtype = Entity.PARTITION_TYPE.values()[partitionType];
            this.partitionDomain_ = DomainFactory.createDomain(partitionColtype, dataColType, partitionSchema);
        } else if (!partitionCol.isEmpty()) {
            int threadcolindex = -1;
            for (int i = 0; i < this.colNames_.size(); ++i) {
                if (!this.colNames_.get(i).equals(partitionCol)) continue;
                threadcolindex = i;
                break;
            }
            if (threadcolindex < 0) {
                throw new RuntimeException("No match found for " + partitionCol);
            }
            this.threadByColIndexForNonPartion_ = threadcolindex;
        }
        for (int i = 0; i < threadCount; ++i) {
            if (pConn == null) {
                pConn = this.newConn(hostName, port, userId, password, dbName, tableName, useSSL, enableHighAvailability, highAvailabilitySites, isCompress);
            }
            WriterThread writerThread = new WriterThread(this, pConn);
            this.threads_.add(writerThread);
            pConn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Entity>> getUnwrittenData() throws InterruptedException {
        ArrayList<List<Entity>> unwrittenData = new ArrayList<List<Entity>>();
        for (WriterThread writeThread : this.threads_) {
            Object object = writeThread.busyLock_;
            synchronized (object) {
                List<List<Entity>> list = writeThread.failedQueue_;
                synchronized (list) {
                    unwrittenData.addAll(writeThread.failedQueue_);
                    writeThread.failedQueue_.clear();
                }
                list = writeThread.writeQueue_;
                synchronized (list) {
                    unwrittenData.addAll(writeThread.writeQueue_);
                    writeThread.writeQueue_.clear();
                }
            }
        }
        return unwrittenData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Entity>> getFailedData() throws InterruptedException {
        ArrayList<List<Entity>> failedData = new ArrayList<List<Entity>>();
        for (WriterThread writeThread : this.threads_) {
            Object object = writeThread.busyLock_;
            synchronized (object) {
                List<List<Entity>> list = writeThread.failedQueue_;
                synchronized (list) {
                    failedData.addAll(writeThread.failedQueue_);
                    writeThread.failedQueue_.clear();
                }
            }
        }
        return failedData;
    }

    public Status getStatus() {
        Status status = new Status();
        status.errorCode = this.errorCodeInfo_.errorCode;
        status.errorInfo = this.errorCodeInfo_.errorInfo;
        status.unsentRows = 0L;
        status.sentRows = 0L;
        status.sendFailedRows = 0L;
        status.isExiting = this.isExiting();
        for (WriterThread writeThread : this.threads_) {
            ThreadStatus threadStatus = new ThreadStatus();
            writeThread.getStatus(threadStatus);
            status.threadStatusList.add(threadStatus);
            status.sentRows += threadStatus.sentRows;
            status.unsentRows += threadStatus.unsentRows;
            status.sendFailedRows += threadStatus.sendFailedRows;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForThreadCompletion() throws InterruptedException {
        for (WriterThread one : this.threads_) {
            one.exit();
        }
        for (WriterThread one : this.threads_) {
            Thread thread = one.writeThread_;
            synchronized (thread) {
                if (!one.isFinished_) {
                    one.writeThread_.wait();
                }
            }
            one.conn_ = null;
        }
        this.setError(ErrorCodeInfo.Code.EC_None, "");
    }

    public ErrorCodeInfo insertUnwrittenData(List<List<Entity>> records) {
        if (this.isExiting()) {
            throw new RuntimeException("Thread is exiting. ");
        }
        if (this.threads_.size() > 1) {
            if (this.isPartionedTable_) {
                Vector pvector = BasicEntityFactory.instance().createVectorWithDefaultValue(this.colTypes_.get(this.partitionColumnIdx_), records.size());
                int rowindex = 0;
                try {
                    for (List<Entity> row : records) {
                        if (row.size() != this.colTypes_.size()) {
                            return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidParameter, "Column counts don't match.");
                        }
                        if (row.get(this.partitionColumnIdx_) != null) {
                            Scalar scalar = (Scalar)row.get(this.partitionColumnIdx_);
                            if (scalar != null) {
                                pvector.set(rowindex, scalar);
                            } else {
                                pvector.setNull(rowindex);
                            }
                        } else {
                            pvector.setNull(rowindex);
                        }
                        ++rowindex;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidParameter, "Row in records " + rowindex + " mismatch type " + (Object)((Object)this.colTypes_.get(this.partitionColumnIdx_)));
                }
                List<Integer> threadindexes = this.partitionDomain_.getPartitionKeys(pvector);
                for (int row = 0; row < threadindexes.size(); ++row) {
                    this.insertThreadWrite(threadindexes.get(row), records.get(row));
                }
            } else {
                Vector partionvector = BasicEntityFactory.instance().createVectorWithDefaultValue(this.colTypes_.get(this.threadByColIndexForNonPartion_), records.size());
                int rowindex = 0;
                try {
                    for (List<Entity> row : records) {
                        if (row.size() != this.colTypes_.size()) {
                            return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidParameter, "Column counts don't match.");
                        }
                        Scalar scalar = (Scalar)row.get(this.threadByColIndexForNonPartion_);
                        if (scalar != null) {
                            partionvector.set(rowindex, scalar);
                        } else {
                            partionvector.setNull(rowindex);
                        }
                        ++rowindex;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidParameter, "Row in records " + rowindex + " mismatch type " + (Object)((Object)this.colTypes_.get(this.partitionColumnIdx_)));
                }
                for (rowindex = 0; rowindex < records.size(); ++rowindex) {
                    int threadindex = partionvector.hashBucket(rowindex, this.threads_.size());
                    this.insertThreadWrite(threadindex, records.get(rowindex));
                }
            }
        } else {
            for (List<Entity> row : records) {
                this.insertThreadWrite(0, row);
            }
        }
        return new ErrorCodeInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertThreadWrite(int threadhashkey, List<Entity> row) {
        if (threadhashkey < 0) {
            threadhashkey = 0;
        }
        int threadIndex = threadhashkey % this.threads_.size();
        WriterThread writerThread = this.threads_.get(threadIndex);
        List<List<Entity>> list = writerThread.writeQueue_;
        synchronized (list) {
            writerThread.writeQueue_.add(row);
            writerThread.writeQueue_.notify();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ErrorCodeInfo insert(Object ... args) {
        if (this.isExiting()) {
            throw new RuntimeException("Thread is exiting. ");
        }
        if (args.length != this.colTypes_.size()) {
            return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidParameter, "Column counts don't match.");
        }
        try {
            int threadindex;
            ArrayList<Entity> prow = new ArrayList<Entity>();
            int colindex = 0;
            boolean isAllNull = true;
            for (Object one : args) {
                Entity.DATA_TYPE dataType = this.colTypes_.get(colindex);
                isAllNull = false;
                Entity entity = BasicEntityFactory.createScalar(dataType, one);
                if (entity == null) {
                    return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidObject, "Data conversion error: " + (Object)((Object)dataType));
                }
                prow.add(entity);
                ++colindex;
            }
            if (isAllNull) {
                return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidObject, "Can't insert a Null row.");
            }
            if (this.threads_.size() > 1) {
                if (this.isPartionedTable_) {
                    Vector pvector = BasicEntityFactory.instance().createVectorWithDefaultValue(this.colTypes_.get(this.partitionColumnIdx_), 1);
                    if (prow.get(this.partitionColumnIdx_) != null) {
                        pvector.set(0, (Scalar)prow.get(this.partitionColumnIdx_));
                        List<Integer> indexes = this.partitionDomain_.getPartitionKeys(pvector);
                        if (indexes.isEmpty()) return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_Server, "Failed to obtain the partition scheme.");
                        threadindex = indexes.get(0);
                    } else {
                        threadindex = 0;
                    }
                } else if (prow.get(this.threadByColIndexForNonPartion_) != null) {
                    Vector pvector = BasicEntityFactory.instance().createVectorWithDefaultValue(this.colTypes_.get(this.threadByColIndexForNonPartion_), 1);
                    pvector.set(0, (Scalar)prow.get(this.threadByColIndexForNonPartion_));
                    threadindex = pvector.hashBucket(0, this.threads_.size());
                } else {
                    threadindex = 0;
                }
            } else {
                threadindex = 0;
            }
            this.insertThreadWrite(threadindex, prow);
            return new ErrorCodeInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidObject, "Invalid object error " + e);
        }
    }

    private boolean isExiting() {
        return this.hasError_;
    }

    private DBConnection newConn(String hostName, int port, String userId, String password, String dbName, String tableName, boolean useSSL, boolean enableHighAvailability, String[] highAvailabilitySites, boolean compress) throws IOException {
        DBConnection pConn = new DBConnection(false, useSSL, compress);
        boolean ret = pConn.connect(hostName, port, userId, password, null, enableHighAvailability, highAvailabilitySites);
        if (!ret) {
            return null;
        }
        return pConn;
    }

    private void setError(ErrorCodeInfo.Code code, String info) {
        if (this.hasError_) {
            return;
        }
        this.hasError_ = true;
        this.errorCodeInfo_ = new ErrorCodeInfo(code, info);
    }

    static class WriterThread
    implements Runnable {
        MultithreadedTableWriter tableWriter_;
        DBConnection conn_;
        Object busyLock_ = new Object();
        String scriptTableInsert_;
        String scriptSaveTable_;
        List<List<Entity>> writeQueue_ = new ArrayList<List<Entity>>();
        List<List<Entity>> failedQueue_ = new ArrayList<List<Entity>>();
        Thread writeThread_;
        long sentRows_;
        boolean exit_;
        boolean isFinished_;

        WriterThread(MultithreadedTableWriter tableWriter, DBConnection conn) {
            this.tableWriter_ = tableWriter;
            this.sentRows_ = 0L;
            this.conn_ = conn;
            this.exit_ = false;
            this.isFinished_ = false;
            this.writeThread_ = new Thread(this);
            this.writeThread_.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            if (!this.init()) {
                return;
            }
            while (!this.isExiting()) {
                try {
                    object = this.writeQueue_;
                    synchronized (object) {
                        this.writeQueue_.wait();
                        if (!this.isExiting() && this.tableWriter_.batchSize_ > 1 && this.tableWriter_.throttleMilsecond_ > 0) {
                            long diff;
                            long batchWaitTimeout = System.currentTimeMillis() + (long)this.tableWriter_.throttleMilsecond_;
                            while (!this.isExiting() && this.writeQueue_.size() < this.tableWriter_.batchSize_ && (diff = batchWaitTimeout - System.currentTimeMillis()) > 0L) {
                                this.writeQueue_.wait(diff);
                            }
                        }
                    }
                    while (!this.isExiting() && this.writeAllData()) {
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.tableWriter_.errorCodeInfo_.set(ErrorCodeInfo.Code.EC_None, e.getMessage());
                    break;
                }
            }
            while (!this.tableWriter_.isExiting() && this.writeAllData()) {
            }
            object = this.writeThread_;
            synchronized (object) {
                this.isFinished_ = true;
                this.writeThread_.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean writeAllData() {
            Object object = this.busyLock_;
            synchronized (object) {
                Object runscript;
                ArrayList<List<Entity>> items = new ArrayList<List<Entity>>();
                List<List<Entity>> list = this.writeQueue_;
                synchronized (list) {
                    items.addAll(this.writeQueue_);
                    this.writeQueue_.clear();
                }
                int size = items.size();
                if (size < 1) {
                    return false;
                }
                boolean isWriteDone = true;
                BasicTable writeTable = null;
                int addRowCount = 0;
                try {
                    ArrayList<Vector> columns = new ArrayList<Vector>();
                    int colCount = 0;
                    for (Entity.DATA_TYPE dATA_TYPE : this.tableWriter_.colTypes_) {
                        Vector vector;
                        ArrayList<Vector> VectorList = new ArrayList<Vector>();
                        if (dATA_TYPE.getValue() >= 65) {
                            for (int i = 0; i < size; ++i) {
                                VectorList.add((Vector)((List)items.get(i)).get(colCount));
                            }
                            vector = new BasicArrayVector(VectorList);
                        } else {
                            vector = BasicEntityFactory.instance().createVectorWithDefaultValue(dATA_TYPE, size);
                        }
                        ++colCount;
                        columns.add(vector);
                    }
                    writeTable = new BasicTable(this.tableWriter_.colNames_, columns);
                    writeTable.setColumnCompressTypes(this.tableWriter_.compressTypes_);
                    for (List list2 : items) {
                        try {
                            for (int colindex = 0; colindex < columns.size(); ++colindex) {
                                Vector col = (Vector)columns.get(colindex);
                                if (col instanceof BasicArrayVector) continue;
                                Scalar scalar = (Scalar)list2.get(colindex);
                                if (scalar != null) {
                                    col.set(addRowCount, scalar);
                                    continue;
                                }
                                col.setNull(addRowCount);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            isWriteDone = false;
                            this.tableWriter_.logger_.warning("threadid = " + this.writeThread_.getId() + " sendindex = " + this.sentRows_ + " Failed to append data to the table. " + e);
                            this.tableWriter_.setError(ErrorCodeInfo.Code.EC_InvalidObject, "Failed to append data to the table. " + e);
                            break;
                        }
                        ++addRowCount;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.tableWriter_.logger_.warning("threadid=" + this.writeThread_.getId() + " Create table error: " + e);
                    this.tableWriter_.setError(ErrorCodeInfo.Code.EC_InvalidObject, "Create table error: " + e);
                    isWriteDone = false;
                }
                if (isWriteDone && writeTable != null && addRowCount > 0) {
                    runscript = "";
                    try {
                        ArrayList<Entity> args = new ArrayList<Entity>();
                        args.add(writeTable);
                        runscript = this.scriptTableInsert_;
                        BasicInt result = (BasicInt)this.conn_.run((String)runscript, args);
                        if (result.getInt() != addRowCount) {
                            // empty if block
                        }
                        if (this.scriptSaveTable_ != null && !this.scriptSaveTable_.isEmpty()) {
                            runscript = this.scriptSaveTable_;
                            this.conn_.run((String)runscript);
                        }
                        this.sentRows_ += (long)addRowCount;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.tableWriter_.logger_.warning("threadid=" + this.writeThread_.getId() + " sendindex=" + this.sentRows_ + " Save table error: " + e + " script:" + (String)runscript);
                        this.tableWriter_.setError(ErrorCodeInfo.Code.EC_Server, "Failed to save the inserted data: " + e + " script: " + (String)runscript);
                        this.conn_ = null;
                        isWriteDone = false;
                    }
                }
                if (!isWriteDone) {
                    runscript = this.failedQueue_;
                    synchronized (runscript) {
                        this.failedQueue_.addAll(items);
                    }
                }
                if (addRowCount > 0) {
                    boolean startgc = false;
                    MultithreadedTableWriter multithreadedTableWriter = this.tableWriter_;
                    synchronized (multithreadedTableWriter) {
                        MultithreadedTableWriter multithreadedTableWriter2 = this.tableWriter_;
                        multithreadedTableWriter2.sentRowsAfterGc_ = multithreadedTableWriter2.sentRowsAfterGc_ + addRowCount;
                        if (this.tableWriter_.sentRowsAfterGc_ > 10000) {
                            this.tableWriter_.sentRowsAfterGc_ = 0;
                            startgc = true;
                        }
                    }
                    if (startgc && Runtime.getRuntime().freeMemory() < 0x6400000L) {
                        System.gc();
                    }
                }
            }
            return true;
        }

        boolean init() {
            this.scriptTableInsert_ = this.tableWriter_.dbName_.isEmpty() ? "tableInsert{\"" + this.tableWriter_.tableName_ + "\"}" : (this.tableWriter_.isPartionedTable_ ? "tableInsert{loadTable(\"" + this.tableWriter_.dbName_ + "\",\"" + this.tableWriter_.tableName_ + "\")}" : "tableInsert{loadTable(\"" + this.tableWriter_.dbName_ + "\",\"" + this.tableWriter_.tableName_ + "\")}");
            return true;
        }

        void getStatus(ThreadStatus status) {
            status.threadId = this.writeThread_.getId();
            status.sentRows = this.sentRows_;
            status.unsentRows = this.writeQueue_.size();
            status.sendFailedRows = this.failedQueue_.size();
        }

        boolean isExiting() {
            return this.exit_ || this.tableWriter_.hasError_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void exit() {
            this.exit_ = true;
            List<List<Entity>> list = this.writeQueue_;
            synchronized (list) {
                this.writeQueue_.notify();
            }
        }
    }

    public static class Status
    extends ErrorCodeInfo {
        public boolean isExiting;
        public long sentRows;
        public long unsentRows;
        public long sendFailedRows;
        public List<ThreadStatus> threadStatusList = new ArrayList<ThreadStatus>();

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("errorCode     : " + this.errorCode + "\n");
            sb.append("errorInfo     : " + this.errorInfo + "\n");
            sb.append("isExiting     : " + this.isExiting + "\n");
            sb.append("sentRows      : " + this.sentRows + "\n");
            sb.append("unsentRows    : " + this.unsentRows + "\n");
            sb.append("sendFailedRows: " + this.sendFailedRows + "\n");
            sb.append("threadStatus  :\n");
            sb.append(String.format("%16s", "threadId") + String.format("%16s", "sentRows") + String.format("%16s", "unsentRows") + String.format("%16s", "sendFailedRows") + "\n");
            for (int i = 0; i < this.threadStatusList.size(); ++i) {
                sb.append(this.threadStatusList.get(i).toString());
            }
            return sb.toString();
        }
    }

    public static class ThreadStatus {
        public long threadId;
        public long sentRows;
        public long unsentRows;
        public long sendFailedRows;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%16s", this.threadId) + String.format("%16s", this.sentRows) + String.format("%16s", this.unsentRows) + String.format("%16s", this.unsentRows) + "\n");
            return sb.toString();
        }
    }
}

