/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.route;

import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.route.Domain;
import java.util.ArrayList;
import java.util.List;

public class RangeDomain
implements Domain {
    private Entity.DATA_TYPE type;
    private Entity.DATA_CATEGORY cat;
    private Vector range;

    public RangeDomain(Vector range, Entity.DATA_TYPE type, Entity.DATA_CATEGORY cat) {
        this.type = type;
        this.cat = cat;
        this.range = range;
    }

    @Override
    public List<Integer> getPartitionKeys(Vector partitionCol) {
        if (partitionCol.getDataCategory() != this.cat) {
            throw new RuntimeException("Data category incompatible.");
        }
        if (this.cat == Entity.DATA_CATEGORY.TEMPORAL && this.type != partitionCol.getDataType()) {
            Entity.DATA_TYPE old = partitionCol.getDataType();
            if ((partitionCol = (Vector)Utils.castDateTime(partitionCol, this.type)) == null) {
                throw new RuntimeException("Can't convert type from " + old.name() + " to " + this.type.name());
            }
        }
        int partitions = this.range.rows() - 1;
        int rows = partitionCol.rows();
        ArrayList<Integer> keys = new ArrayList<Integer>(rows);
        for (int i = 0; i < rows; ++i) {
            int index = this.range.asof(partitionCol.get(i));
            if (index >= partitions) {
                keys.add(-1);
                continue;
            }
            keys.add(index);
        }
        return keys;
    }
}

