/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb;

import com.xxdb.RSAUtils;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicBoolean;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.BasicTableSchema;
import com.xxdb.data.Entity;
import com.xxdb.data.EntityBlockReader;
import com.xxdb.data.EntityFactory;
import com.xxdb.data.Utils;
import com.xxdb.data.Void;
import com.xxdb.io.AbstractExtendedDataInputStream;
import com.xxdb.io.AbstractExtendedDataOutputStream;
import com.xxdb.io.BigEndianDataInputStream;
import com.xxdb.io.BigEndianDataOutputStream;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.io.LittleEndianDataInputStream;
import com.xxdb.io.LittleEndianDataOutputStream;
import com.xxdb.io.ProgressListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class DBConnection {
    private static final int MAX_FORM_VALUE = Entity.DATA_FORM.values().length - 1;
    private static final int MAX_TYPE_VALUE = Entity.DATA_TYPE.DT_POINT_ARRAY.getValue();
    private static final int DEFAULT_PRIORITY = 4;
    private static final int DEFAULT_PARALLELISM = 2;
    private static final int localAPIVersion = 210;
    private ReentrantLock mutex_;
    private DBConnectionImpl conn_;
    private String uid_;
    private String pwd_;
    private String initialScript_ = null;
    private boolean enableHighAvailability_;
    private boolean enableSSL_;
    private boolean asynTask_;
    private List<Node> nodes_ = new ArrayList<Node>();
    private int lastConnNodeIndex_ = 0;
    private boolean compress_ = false;
    private int connTimeout_ = 0;
    private String[] highAvailabilitySites_ = null;
    private boolean python_ = false;
    private boolean closed_ = false;
    private boolean loadBalance_ = true;

    public DBConnection() {
        this(false, false, false);
    }

    public DBConnection(boolean asynchronousTask) {
        this(asynchronousTask, false, false);
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL) {
        this(asynchronousTask, useSSL, false);
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress) {
        this(asynchronousTask, useSSL, compress, false);
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress, boolean usePython) {
        this.asynTask_ = asynchronousTask;
        this.enableSSL_ = useSSL;
        this.compress_ = compress;
        this.python_ = usePython;
        this.conn_ = new DBConnectionImpl(asynchronousTask, useSSL, compress);
        this.mutex_ = new ReentrantLock();
    }

    public boolean isBusy() {
        if (!this.mutex_.tryLock()) {
            return true;
        }
        this.mutex_.unlock();
        return false;
    }

    private int getVersionNumber(String ver) {
        try {
            String[] s = ver.split(" ");
            if (s.length >= 2) {
                String vernum = s[0].replace(".", "");
                return Integer.parseInt(vernum);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public void setLoadBalance(boolean loadBalance) {
        this.loadBalance_ = loadBalance;
    }

    private int generateRequestFlag(boolean clearSessionMemory) {
        int flag = 0;
        if (this.asynTask_) {
            flag += 4;
        }
        if (clearSessionMemory) {
            flag += 16;
        }
        if (this.compress_) {
            flag += 64;
        }
        if (this.python_) {
            flag += 2048;
        }
        return flag;
    }

    public boolean connect(String hostName, int port) throws IOException {
        return this.connect(hostName, port, "", "", null, false, null);
    }

    public boolean connect(String hostName, int port, int timeout) throws IOException {
        this.connTimeout_ = timeout;
        return this.connect(hostName, port, "", "", null, false, null);
    }

    public boolean connect(String hostName, int port, int timeout, boolean reconnect) throws IOException {
        this.connTimeout_ = timeout;
        return this.connect(hostName, port, "", "", null, false, null, reconnect);
    }

    public boolean connect(String hostName, int port, String initialScript) throws IOException {
        return this.connect(hostName, port, "", "", initialScript, false, null);
    }

    public boolean connect(String hostName, int port, String initialScript, boolean enableHighAvailability) throws IOException {
        return this.connect(hostName, port, "", "", initialScript, enableHighAvailability, null);
    }

    public boolean connect(String hostName, int port, boolean enableHighAvailability) throws IOException {
        return this.connect(hostName, port, "", "", null, enableHighAvailability, null);
    }

    public boolean connect(String hostName, int port, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, "", "", null, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String initialScript, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, "", "", initialScript, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String userId, String password) throws IOException {
        return this.connect(hostName, port, userId, password, null, false, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, boolean enableHighAvailability) throws IOException {
        return this.connect(hostName, port, userId, password, null, enableHighAvailability, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, userId, password, null, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, false, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean enableHighAvailability) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, enableHighAvailability, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean enableHighAvailability, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, enableHighAvailability, highAvailabilitySites, false);
    }

    /*
     * Unable to fully structure code
     */
    public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean enableHighAvailability, String[] highAvailabilitySites, boolean reconnect) throws IOException {
        this.mutex_.lock();
        try {
            this.uid_ = userId;
            this.pwd_ = password;
            this.initialScript_ = initialScript;
            this.enableHighAvailability_ = enableHighAvailability;
            this.highAvailabilitySites_ = highAvailabilitySites;
            if (!enableHighAvailability) ** GOTO lbl89
            this.nodes_.add(new Node(hostName, port));
            if (highAvailabilitySites != null) {
                for (String site : highAvailabilitySites) {
                    node = new Node(site);
                    this.nodes_.add(node);
                }
            }
            connectedNode = new Node();
            bt = null;
            while (!this.closed_) {
                block15: while (!this.conn_.isConnected() && !this.closed_) {
                    for (Node one : this.nodes_) {
                        if (this.connectNode(one)) {
                            connectedNode = one;
                            continue block15;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            var14_22 = false;
                            this.mutex_.unlock();
                            return var14_22;
                        }
                    }
                }
                try {
                    bt = (BasicTable)DBConnectionImpl.access$800(this.conn_, "rpc(getControllerAlias(), getClusterPerf)");
                    break;
                }
                catch (Exception e) {
                    System.out.println("ERROR getting other data nodes, exception: " + e.getMessage());
                    node1 = new Node();
                    if (this.isConnected()) {
                        type = this.parseException(e.getMessage(), node1);
                        if (type == ExceptionType.ET_IGNORE || type != ExceptionType.ET_NEWLEADER && type != ExceptionType.ET_NODENOTAVAIL) continue;
                        this.switchDataNode(node1);
                        continue;
                    }
                    this.switchDataNode(node1);
                }
            }
            if (bt.getDataForm() != Entity.DATA_FORM.DF_TABLE) {
                throw new IOException("Run getClusterPerf() failed.");
            }
            if (this.loadBalance_) {
                colHost = (BasicStringVector)bt.getColumn("host");
                colPort = (BasicIntVector)bt.getColumn("port");
                colMode = (BasicIntVector)bt.getColumn("mode");
                colmaxConnections = (BasicIntVector)bt.getColumn("maxConnections");
                colconnectionNum = (BasicIntVector)bt.getColumn("connectionNum");
                colworkerNum = (BasicIntVector)bt.getColumn("workerNum");
                colexecutorNum = (BasicIntVector)bt.getColumn("executorNum");
                for (i = 0; i < colMode.rows(); ++i) {
                    if (colMode.getInt(i) != 0) continue;
                    nodex = new Node(colHost.getString(i), colPort.getInt(i));
                    pexistNode = null;
                    if (highAvailabilitySites != null) {
                        for (Node node : this.nodes_) {
                            if (!Node.access$500(node).equals(Node.access$500(nodex)) || Node.access$600(node) != Node.access$600(nodex)) continue;
                            pexistNode = node;
                            break;
                        }
                        if (pexistNode == null) continue;
                    }
                    load = colconnectionNum.getInt(i) < colmaxConnections.getInt(i) ? (double)(colconnectionNum.getInt(i) + colworkerNum.getInt(i) + colexecutorNum.getInt(i)) / 3.0 : 1.7976931348623157E308;
                    if (pexistNode != null) {
                        Node.access$902(pexistNode, load);
                        continue;
                    }
                    this.nodes_.add(new Node(colHost.getString(i), colPort.getInt(i), load));
                }
                pMinNode = null;
                for (Node one : this.nodes_) {
                    if (pMinNode != null && Node.access$900(pMinNode) != -1.0 && !(Node.access$900(pMinNode) > Node.access$900(one))) continue;
                    pMinNode = one;
                }
                if (!pMinNode.isEqual(connectedNode)) {
                    System.out.println("Connect to min load node: " + Node.access$500(pMinNode) + ":" + Node.access$600(pMinNode));
                    this.conn_.close();
                    this.switchDataNode(pMinNode);
                    var21_31 = true;
                    return var21_31;
                }
            } else {
                var11_15 = 1;
                return (boolean)var11_15;
lbl89:
                // 1 sources

                if (reconnect) {
                    this.nodes_.add(new Node(hostName, port));
                    this.switchDataNode(new Node(hostName, port));
                } else if (!this.connectNode(new Node(hostName, port))) {
                    connectedNode = false;
                    return connectedNode;
                }
            }
            if (this.initialScript_ != null && this.initialScript_.length() > 0) {
                this.run(this.initialScript_);
            }
            connectedNode = true;
            return connectedNode;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public void switchDataNode(Node node) throws IOException {
        boolean connected = false;
        do {
            if (node.hostName != null && node.hostName.length() > 0 && this.connectNode(node)) {
                connected = true;
                break;
            }
            if (this.nodes_.isEmpty()) {
                throw new RuntimeException("Failed to connect to " + node.hostName + ":" + node.port);
            }
            for (int i = this.nodes_.size() - 1; i >= 0; --i) {
                this.lastConnNodeIndex_ = (this.lastConnNodeIndex_ + 1) % this.nodes_.size();
                if (!this.connectNode(this.nodes_.get(this.lastConnNodeIndex_))) continue;
                connected = true;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        } while (!connected && !this.closed_);
        if (this.initialScript_ != null && this.initialScript_.length() > 0) {
            this.run(this.initialScript_);
        }
    }

    public boolean connectNode(Node node) throws IOException {
        System.out.println("Connect to " + node.hostName + ":" + node.port + ".");
        while (!this.closed_) {
            try {
                return this.conn_.connect(node.hostName, node.port, this.uid_, this.pwd_, this.enableSSL_, this.asynTask_, this.compress_);
            }
            catch (Exception e) {
                if (this.isConnected()) {
                    ExceptionType type = this.parseException(e.getMessage(), node);
                    if (type != ExceptionType.ET_NEWLEADER) {
                        if (type == ExceptionType.ET_IGNORE) {
                            return true;
                        }
                        if (type == ExceptionType.ET_NODENOTAVAIL) {
                            return false;
                        }
                        throw e;
                    }
                } else {
                    System.out.println(e.getMessage());
                    return false;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    public ExceptionType parseException(String msg, Node node) {
        int index = msg.indexOf("<NotLeader>");
        if (index != -1) {
            index = msg.indexOf(">");
            String ipport = msg.substring(index + 1);
            this.parseIpPort(ipport, node);
            System.out.println("New leader is " + node.hostName + ":" + node.port);
            return ExceptionType.ET_NEWLEADER;
        }
        index = msg.indexOf("<DataNodeNotAvail>");
        if (index == -1) {
            return ExceptionType.ET_UNKNOW;
        }
        index = msg.indexOf(">");
        String ipport = msg.substring(index + 1);
        Node nanode = new Node();
        this.parseIpPort(ipport, nanode);
        Node lastnode = new Node();
        this.conn_.getNode(lastnode);
        if (!lastnode.hostName.equals(nanode.hostName) && lastnode.port == nanode.port) {
            System.out.println("This node " + nanode.hostName + ":" + nanode.port + " is not avail.");
            return ExceptionType.ET_NODENOTAVAIL;
        }
        System.out.println("Other node " + nanode.hostName + ":" + nanode.port + " is not avail.");
        return ExceptionType.ET_IGNORE;
    }

    public void parseIpPort(String ipport, Node node) {
        String[] v = ipport.split(":");
        if (v.length < 2) {
            throw new RuntimeException("The ipPort '" + ipport + "' is invalid.");
        }
        node.hostName = v[0];
        node.port = Integer.parseInt(v[1]);
    }

    public boolean connected() {
        try {
            BasicInt ret = (BasicInt)this.conn_.run("1+1");
            return !ret.isNull() && ret.getInt() == 2;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void login(String userID, String password, boolean enableEncryption) throws IOException {
        this.conn_.login(userID, password, enableEncryption);
        this.uid_ = userID;
        this.pwd_ = password;
    }

    public boolean getRemoteLittleEndian() {
        return this.conn_.getRemoteLittleEndian();
    }

    public Entity tryRun(String script) throws IOException {
        return this.tryRun(script, 4, 2);
    }

    public Entity tryRun(String script, int priority, int parallelism) throws IOException {
        return this.tryRun(script, priority, parallelism, 0, false);
    }

    public Entity tryRun(String script, int priority, int parallelism, boolean clearSessionMemory) throws IOException {
        return this.tryRun(script, priority, parallelism, 0, clearSessionMemory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity tryRun(String script, int priority, int parallelism, int fetchSize, boolean clearSessionMemory) throws IOException {
        if (!this.mutex_.tryLock()) {
            return null;
        }
        try {
            Entity entity = this.run(script, null, priority, parallelism, fetchSize, clearSessionMemory);
            return entity;
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public Entity run(String script, String tableName) throws IOException {
        return this.run(script, null, 4, 2, 0, false, tableName);
    }

    public Entity run(String script) throws IOException {
        return this.run(script, (ProgressListener)null, 4, 2);
    }

    public Entity run(String script, int priority) throws IOException {
        return this.run(script, (ProgressListener)null, priority, 2);
    }

    public Entity run(String script, int priority, int parallelism) throws IOException {
        return this.run(script, (ProgressListener)null, priority, parallelism);
    }

    public Entity run(String script, ProgressListener listener) throws IOException {
        return this.run(script, listener, 4, 2);
    }

    public Entity run(String script, ProgressListener listener, boolean clearSessionMemory) throws IOException {
        return this.run(script, listener, 4, 2, 0, clearSessionMemory);
    }

    public Entity run(String script, int priority, boolean clearSessionMemory) throws IOException {
        return this.run(script, null, priority, 2, 0, clearSessionMemory);
    }

    public Entity run(String script, ProgressListener listener, int priority, int parallelism) throws IOException {
        return this.run(script, listener, priority, parallelism, 0, false);
    }

    public Entity run(String script, ProgressListener listener, int priority, int parallelism, boolean clearSessionMemory) throws IOException {
        return this.run(script, listener, priority, parallelism, 0, clearSessionMemory);
    }

    public Entity run(String script, int priority, int parallelism, boolean clearSessionMemory) throws IOException {
        return this.run(script, null, priority, parallelism, 0, clearSessionMemory);
    }

    public Entity run(String script, ProgressListener listener, int priority, int parallelism, int fetchSize) throws IOException {
        return this.run(script, listener, priority, parallelism, fetchSize, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity tryRun(String script, boolean clearSessionMemory) throws IOException {
        if (!this.mutex_.tryLock()) {
            return null;
        }
        try {
            Entity entity = this.run(script, null, 4, 2, 0, clearSessionMemory);
            return entity;
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public Entity run(String script, boolean clearSessionMemory) throws IOException {
        return this.run(script, null, 4, 2, 0, clearSessionMemory);
    }

    public Entity run(String script, ProgressListener listener, int priority, int parallelism, int fetchSize, boolean clearSessionMemory) throws IOException {
        return this.run(script, listener, priority, parallelism, fetchSize, clearSessionMemory, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Entity run(String script, ProgressListener listener, int priority, int parallelism, int fetchSize, boolean clearSessionMemory, String tableName) throws IOException {
        this.mutex_.lock();
        try {
            if (!this.nodes_.isEmpty()) {
                while (!this.closed_) {
                    try {
                        var8_9 = DBConnectionImpl.access$1200(this.conn_, script, listener, priority, parallelism, fetchSize, clearSessionMemory, tableName);
                        return var8_9;
                    }
                    catch (IOException e) {
                        block13: {
                            block12: {
                                node = new Node();
                                if (!this.connected()) break block12;
                                type = this.parseException(e.getMessage(), node);
                                if (type == ExceptionType.ET_IGNORE) {
                                    var11_14 = new Void();
                                    this.mutex_.unlock();
                                    return var11_14;
                                }
                                ** if (type != ExceptionType.ET_UNKNOW) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    throw e;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    break block13;
                                }
                            }
                            this.parseException(e.getMessage(), node);
                        }
                        this.switchDataNode(node);
                    }
                }
                var8_10 = null;
                return var8_10;
            }
            var8_11 = DBConnectionImpl.access$1200(this.conn_, script, listener, priority, parallelism, fetchSize, clearSessionMemory, tableName);
            return var8_11;
            {
                catch (Throwable var12_15) {
                    throw var12_15;
                }
            }
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public Entity tryRun(String function, List<Entity> arguments) throws IOException {
        return this.tryRun(function, arguments, 4, 2);
    }

    public Entity tryRun(String function, List<Entity> arguments, int priority, int parallelism) throws IOException {
        return this.tryRun(function, arguments, priority, parallelism, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity tryRun(String function, List<Entity> arguments, int priority, int parallelism, int fetchSize) throws IOException {
        if (!this.mutex_.tryLock()) {
            return null;
        }
        try {
            Entity entity = this.run(function, arguments, priority, parallelism, fetchSize);
            return entity;
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public Entity run(String function, List<Entity> arguments) throws IOException {
        return this.run(function, arguments, 4, 2);
    }

    public Entity run(String function, List<Entity> arguments, int priority) throws IOException {
        return this.run(function, arguments, priority, 2);
    }

    public Entity run(String function, List<Entity> arguments, int priority, int parallelism) throws IOException {
        return this.run(function, arguments, priority, parallelism, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Entity run(String function, List<Entity> arguments, int priority, int parallelism, int fetchSize) throws IOException {
        this.mutex_.lock();
        try {
            if (!this.nodes_.isEmpty()) {
                while (!this.closed_) {
                    try {
                        var6_7 = DBConnectionImpl.access$1300(this.conn_, function, null, arguments, priority, parallelism, fetchSize, false);
                        return var6_7;
                    }
                    catch (IOException e) {
                        block13: {
                            block12: {
                                node = new Node();
                                if (!this.connected()) break block12;
                                type = this.parseException(e.getMessage(), node);
                                if (type == ExceptionType.ET_IGNORE) {
                                    var9_12 = new Void();
                                    this.mutex_.unlock();
                                    return var9_12;
                                }
                                ** if (type != ExceptionType.ET_UNKNOW) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    throw e;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    break block13;
                                }
                            }
                            this.parseException(e.getMessage(), node);
                        }
                        this.switchDataNode(node);
                    }
                }
                var6_8 = null;
                return var6_8;
            }
            var6_9 = DBConnectionImpl.access$1300(this.conn_, function, null, arguments, priority, parallelism, fetchSize, false);
            return var6_9;
            {
                catch (Throwable var10_13) {
                    throw var10_13;
                }
            }
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public void tryUpload(Map<String, Entity> variableObjectMap) throws IOException {
        if (!this.mutex_.tryLock()) {
            throw new IOException("The connection is in use.");
        }
        try {
            this.upload(variableObjectMap);
        }
        finally {
            this.mutex_.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(Map<String, Entity> variableObjectMap) throws IOException {
        this.mutex_.lock();
        try {
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<Entity> objs = new ArrayList<Entity>();
            if (!this.nodes_.isEmpty()) {
                while (!this.closed_) {
                    try {
                        for (String key : variableObjectMap.keySet()) {
                            if (variableObjectMap.size() == 1) {
                                Entity obj = variableObjectMap.get(key);
                                this.conn_.upload(key, obj);
                                continue;
                            }
                            keys.add(key);
                            objs.add(variableObjectMap.get(key));
                        }
                        if (variableObjectMap.size() <= 1) continue;
                        this.conn_.upload(keys, objs);
                    }
                    catch (Exception e) {
                        Node node = new Node();
                        if (this.connected()) {
                            ExceptionType type = this.parseException(e.getMessage(), node);
                            if (type == ExceptionType.ET_IGNORE) continue;
                            if (type == ExceptionType.ET_UNKNOW) {
                                throw e;
                            }
                        } else {
                            this.parseException(e.getMessage(), node);
                        }
                        this.switchDataNode(node);
                    }
                }
            } else {
                for (String key : variableObjectMap.keySet()) {
                    if (variableObjectMap.size() == 1) {
                        Entity obj = variableObjectMap.get(key);
                        this.conn_.upload(key, obj);
                        continue;
                    }
                    keys.add(key);
                    objs.add(variableObjectMap.get(key));
                }
                if (variableObjectMap.size() > 1) {
                    this.conn_.upload(keys, objs);
                }
            }
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public void close() {
        this.mutex_.lock();
        try {
            this.closed_ = true;
            this.conn_.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public String getHostName() {
        return this.conn_.hostName_;
    }

    public int getPort() {
        return this.conn_.port_;
    }

    public String getSessionID() {
        return this.conn_.sessionID_;
    }

    public InetAddress getLocalAddress() {
        return this.conn_.socket_.getLocalAddress();
    }

    public boolean isConnected() {
        return this.conn_.socket_ != null && this.conn_.socket_.isConnected();
    }

    private SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }}, new SecureRandom());
            return context.getSocketFactory();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void compareRequiredAPIVersion() throws IOException {
        block3: {
            try {
                Entity ret = this.run("getRequiredAPIVersion(`java)");
                if (210 < ((BasicInt)((BasicAnyVector)ret).get(0)).getInt()) {
                    throw new IOException("API version is too low and needs to be upgraded");
                }
            }
            catch (IOException e) {
                if (e.getMessage().equals("Syntax Error: [line #1] Cannot recognize the token getRequiredAPIVersion")) break block3;
                throw e;
            }
        }
    }

    private class DBConnectionImpl {
        private Socket socket_;
        private String sessionID_ = "";
        private String hostName_;
        private int port_;
        private String userId_;
        private String pwd_;
        private boolean encrypted_ = true;
        private boolean isConnected_;
        private boolean sslEnable_ = false;
        private boolean asynTask_ = false;
        private boolean compress_ = false;
        private int connTimeout_ = 0;
        private ExtendedDataOutput out_;
        private ExtendedDataInput in_;
        private boolean remoteLittleEndian_;
        private ReentrantLock lock_;

        private DBConnectionImpl(boolean sslEnable, boolean asynTask, boolean compress) {
            this.sslEnable_ = sslEnable;
            this.asynTask_ = asynTask;
            this.compress_ = compress;
            this.lock_ = new ReentrantLock();
        }

        private boolean connect(String hostName, int port, String userId, String password, boolean sslEnable, boolean asynTask, boolean compress) throws IOException {
            this.hostName_ = hostName;
            this.port_ = port;
            this.userId_ = userId;
            this.pwd_ = password;
            this.sslEnable_ = sslEnable;
            this.asynTask_ = asynTask;
            this.compress_ = compress;
            return this.connect();
        }

        private boolean connect() throws IOException {
            this.isConnected_ = false;
            this.socket_ = this.sslEnable_ ? DBConnection.this.getSSLSocketFactory().createSocket() : new Socket();
            if (this.connTimeout_ > 0) {
                this.socket_.connect(new InetSocketAddress(this.hostName_, this.port_), this.connTimeout_);
            } else {
                this.socket_.connect(new InetSocketAddress(this.hostName_, this.port_), 3000);
            }
            if (this.connTimeout_ > 0) {
                this.socket_.setSoTimeout(this.connTimeout_);
            }
            this.socket_.setKeepAlive(true);
            this.socket_.setTcpNoDelay(true);
            this.out_ = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket_.getOutputStream()));
            LittleEndianDataInputStream input = new LittleEndianDataInputStream(new BufferedInputStream(this.socket_.getInputStream()));
            String body = "connect\n";
            this.out_.writeBytes("API 0 ");
            this.out_.writeBytes(String.valueOf(body.length()));
            int flag = DBConnection.this.generateRequestFlag(false);
            this.out_.writeBytes(" / " + String.valueOf(flag) + "_1_" + String.valueOf(4) + "_" + String.valueOf(2));
            this.out_.writeByte(10);
            this.out_.writeBytes(body);
            this.out_.flush();
            String line = input.readLine();
            int endPos = line.indexOf(32);
            if (endPos <= 0) {
                this.close();
                return false;
            }
            this.sessionID_ = line.substring(0, endPos);
            int startPos = endPos + 1;
            if ((endPos = line.indexOf(32, startPos)) != line.length() - 2) {
                this.close();
                return false;
            }
            this.isConnected_ = true;
            if (line.charAt(endPos + 1) == '0') {
                this.remoteLittleEndian_ = false;
                this.out_ = new BigEndianDataOutputStream(new BufferedOutputStream(this.socket_.getOutputStream()));
            } else {
                this.remoteLittleEndian_ = true;
            }
            ExtendedDataInput extendedDataInput = this.in_ = this.remoteLittleEndian_ ? new LittleEndianDataInputStream(new BufferedInputStream(this.socket_.getInputStream())) : new BigEndianDataInputStream(new BufferedInputStream(this.socket_.getInputStream()));
            if (!this.userId_.isEmpty() && !this.pwd_.isEmpty()) {
                if (this.asynTask_) {
                    this.login(this.userId_, this.pwd_, false);
                } else {
                    this.login();
                }
            }
            if (!this.asynTask_) {
                DBConnection.this.compareRequiredAPIVersion();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void login(String userId, String password, boolean enableEncryption) throws IOException {
            this.lock_.lock();
            try {
                this.userId_ = userId;
                this.pwd_ = password;
                this.encrypted_ = enableEncryption;
                this.login();
            }
            finally {
                this.lock_.unlock();
            }
        }

        private void login() throws IOException {
            ArrayList<Entity> args = new ArrayList<Entity>();
            if (this.encrypted_) {
                BasicString keyCode = (BasicString)this.run("getDynamicPublicKey", new ArrayList<Entity>());
                PublicKey key = RSAUtils.getPublicKey(keyCode.getString());
                byte[] usr = RSAUtils.encryptByPublicKey(this.userId_.getBytes(), key);
                byte[] pass = RSAUtils.encryptByPublicKey(this.pwd_.getBytes(), key);
                args.add(new BasicString(Base64.getMimeEncoder().encodeToString(usr)));
                args.add(new BasicString(Base64.getMimeEncoder().encodeToString(pass)));
                args.add(new BasicBoolean(true));
            } else {
                args.add(new BasicString(this.userId_));
                args.add(new BasicString(this.pwd_));
            }
            this.run("login", args);
        }

        private Entity run(String script) throws IOException {
            ArrayList<Entity> args = new ArrayList<Entity>();
            return this.run(script, "script", null, args, 4, 2, 0, false);
        }

        private Entity run(String script, ProgressListener listener, int priority, int parallelism, int fetchSize, boolean clearMemory, String tableName) throws IOException {
            ArrayList<Entity> args = new ArrayList<Entity>();
            return this.run(script, "script", listener, args, priority, parallelism, fetchSize, clearMemory, tableName);
        }

        private Entity run(String function, List<Entity> arguments) throws IOException {
            return this.run(function, "function", null, arguments, 4, 2, 0, false);
        }

        private Entity run(String function, String scriptType, List<Entity> arguments) throws IOException {
            return this.run(function, scriptType, null, arguments, 4, 2, 0, false);
        }

        private Entity run(String function, ProgressListener listener, List<Entity> args, int priority, int parallelism, int fetchSize, boolean clearMemory) throws IOException {
            return this.run(function, "function", listener, args, priority, parallelism, fetchSize, clearMemory);
        }

        private Entity run(String script, String scriptType, ProgressListener listener, List<Entity> args, int priority, int parallelism, int fetchSize, boolean clearMemory) throws IOException {
            return this.run(script, scriptType, listener, args, priority, parallelism, fetchSize, clearMemory, "");
        }

        private Entity run(String script, String scriptType, ProgressListener listener, List<Entity> args, int priority, int parallelism, int fetchSize, boolean clearMemory, String tableName) throws IOException {
            if (!this.isConnected_) {
                throw new IOException("Couldn't send script/function to the remote host because the connection has been closed");
            }
            if (fetchSize > 0 && fetchSize < 8192) {
                throw new IOException("fetchSize must be greater than 8192");
            }
            if (this.socket_ == null || !this.socket_.isConnected() || this.socket_.isClosed()) {
                if (this.sessionID_.isEmpty()) {
                    throw new IOException("Database connection is not established yet.");
                }
                this.socket_ = new Socket(this.hostName_, this.port_);
                this.socket_.setKeepAlive(true);
                this.socket_.setTcpNoDelay(true);
                this.out_ = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket_.getOutputStream()));
                ExtendedDataInput extendedDataInput = this.in_ = this.remoteLittleEndian_ ? new LittleEndianDataInputStream(new BufferedInputStream(this.socket_.getInputStream())) : new BigEndianDataInputStream(new BufferedInputStream(this.socket_.getInputStream()));
            }
            if (!tableName.equals("")) {
                script = tableName + "=" + script;
                this.run(script);
                BasicDictionary schema = (BasicDictionary)this.run(tableName + ".schema()");
                BasicTable colDefs = (BasicTable)schema.get(new BasicString("colDefs"));
                BasicStringVector colDefsName = (BasicStringVector)colDefs.getColumn("name");
                BasicIntVector colDefsTypeInt = (BasicIntVector)colDefs.getColumn("typeInt");
                int cols = colDefs.rows();
                int rows = ((BasicInt)this.run("rows(" + tableName + ")")).getInt();
                HashMap<Integer, Entity.DATA_TYPE> types2Index = new HashMap<Integer, Entity.DATA_TYPE>();
                HashMap<Integer, String> name2Index = new HashMap<Integer, String>();
                for (int i = 0; i < cols; ++i) {
                    types2Index.put(types2Index.size(), Entity.DATA_TYPE.valueOf(colDefsTypeInt.getInt(i)));
                    name2Index.put(name2Index.size(), colDefsName.getString(i));
                }
                return new BasicTableSchema(types2Index, name2Index, rows, cols, tableName, DBConnection.this);
            }
            StringBuilder body = new StringBuilder();
            int argCount = args.size();
            if (scriptType == "script") {
                body.append("script\n" + script);
            } else {
                body.append(scriptType + "\n" + script);
                body.append("\n" + String.valueOf(argCount));
                body.append("\n");
                body.append(this.remoteLittleEndian_ ? "1" : "0");
            }
            try {
                this.out_.writeBytes((listener != null ? "API2 " : "API ") + this.sessionID_ + " ");
                this.out_.writeBytes(String.valueOf(AbstractExtendedDataOutputStream.getUTFlength(body.toString(), 0, 0)));
                int flag = DBConnection.this.generateRequestFlag(clearMemory);
                this.out_.writeBytes(" / " + String.valueOf(flag) + "_1_" + String.valueOf(priority) + "_" + String.valueOf(parallelism));
                if (fetchSize > 0) {
                    this.out_.writeBytes("__" + String.valueOf(fetchSize));
                }
                this.out_.writeByte(10);
                this.out_.writeBytes(body.toString());
                if (argCount > 0) {
                    for (int i = 0; i < args.size(); ++i) {
                        if (this.compress_ && args.get(i).isTable()) {
                            args.get(i).writeCompressed(this.out_);
                            continue;
                        }
                        args.get(i).write(this.out_);
                    }
                    this.out_.flush();
                } else {
                    this.out_.flush();
                }
            }
            catch (IOException ex) {
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Couldn't send script/function to the remote host because the connection has been closed");
            }
            if (this.asynTask_) {
                return null;
            }
            AbstractExtendedDataInputStream in = this.remoteLittleEndian_ ? new LittleEndianDataInputStream(new BufferedInputStream(this.socket_.getInputStream())) : new BigEndianDataInputStream(new BufferedInputStream(this.socket_.getInputStream()));
            String header = null;
            try {
                header = in.readLine();
                while (header.equals("MSG")) {
                    String msg = in.readString();
                    if (listener != null) {
                        listener.progress(msg);
                    }
                    header = in.readLine();
                }
            }
            catch (IOException ex) {
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Failed to read response header from the socket with IO error " + ex.getMessage());
            }
            String[] headers = header.split(" ");
            if (headers.length != 3) {
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Received invalid header");
            }
            int numObject = Integer.parseInt(headers[1]);
            try {
                header = in.readLine();
            }
            catch (IOException ex) {
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Failed to read response header from the socket with IO error " + ex.getMessage());
            }
            if (!header.equals("OK")) {
                if (scriptType == "script") {
                    throw new IOException(this.hostName_ + ":" + this.port_ + " Server response: '" + header + "' script: '" + script + "'");
                }
                throw new IOException(this.hostName_ + ":" + this.port_ + " Server response: '" + header + "' " + scriptType + ": '" + script + "'");
            }
            if (numObject == 0) {
                return new Void();
            }
            try {
                boolean extended;
                short flag = in.readShort();
                int form = flag >> 8;
                int type = flag & 0xFF;
                boolean bl = extended = type >= 128;
                if (type >= 128) {
                    type -= 128;
                }
                if (form < 0 || form > MAX_FORM_VALUE) {
                    throw new IOException("Invalid form value: " + form);
                }
                if (type < 0 || type > MAX_TYPE_VALUE) {
                    throw new IOException("Invalid type value: " + type);
                }
                Entity.DATA_FORM df = Entity.DATA_FORM.values()[form];
                Entity.DATA_TYPE dt = Entity.DATA_TYPE.valueOf(type);
                if (fetchSize > 0 && df == Entity.DATA_FORM.DF_VECTOR && dt == Entity.DATA_TYPE.DT_ANY) {
                    return new EntityBlockReader(in);
                }
                EntityFactory factory = BasicEntityFactory.instance();
                return factory.createEntity(df, dt, in, extended);
            }
            catch (IOException ex) {
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Failed to read object flag from the socket with IO error type " + ex.getMessage());
            }
        }

        public void upload(String name, Entity obj) throws IOException {
            if (!Utils.isVariableCandidate(name)) {
                throw new RuntimeException(name + " is not a qualified variable name.");
            }
            ArrayList<Entity> args = new ArrayList<Entity>();
            args.add(obj);
            this.run(name, "variable", args);
        }

        public void upload(List<String> names, List<Entity> objs) throws IOException {
            if (names.size() != objs.size()) {
                throw new RuntimeException("the size of variable names doesn't match the size of objects.");
            }
            if (names.isEmpty()) {
                return;
            }
            StringBuilder varNames = new StringBuilder();
            for (int i = 0; i < names.size(); ++i) {
                if (!Utils.isVariableCandidate(names.get(i))) {
                    throw new RuntimeException(names.get(i) + " is not a qualified variable name.");
                }
                if (i > 0) {
                    varNames.append(",");
                }
                varNames.append(names.get(i));
            }
            this.run(varNames.toString(), "variable", objs);
        }

        public void close() {
            this.lock_.lock();
            try {
                if (this.socket_ != null) {
                    this.socket_.close();
                    this.socket_ = null;
                    this.sessionID_ = "";
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                this.lock_.unlock();
            }
            this.isConnected_ = false;
        }

        public boolean isConnected() {
            return this.isConnected_;
        }

        public void getNode(Node node) {
            node.hostName = this.hostName_;
            node.port = this.port_;
        }

        public boolean getRemoteLittleEndian() {
            return this.remoteLittleEndian_;
        }

        static /* synthetic */ Entity access$1200(DBConnectionImpl x0, String x1, ProgressListener x2, int x3, int x4, int x5, boolean x6, String x7) throws IOException {
            return x0.run(x1, x2, x3, x4, x5, x6, x7);
        }

        static /* synthetic */ Entity access$1300(DBConnectionImpl x0, String x1, ProgressListener x2, List x3, int x4, int x5, int x6, boolean x7) throws IOException {
            return x0.run(x1, x2, x3, x4, x5, x6, x7);
        }
    }

    private static class Node {
        private String hostName;
        private int port;
        private double load = -1.0;

        public Node() {
            this.load = -1.0;
        }

        public Node(String hostName, int port, double load) {
            this.hostName = hostName;
            this.port = port;
            this.load = load;
        }

        public Node(String hostName, int port) {
            this.hostName = hostName;
            this.port = port;
            this.load = -1.0;
        }

        public Node(String ipPort, double loadValue) {
            String[] v = ipPort.split(":");
            if (v.length < 2) {
                throw new RuntimeException("The ipPort '" + ipPort + "' is invalid.");
            }
            this.hostName = v[0];
            this.port = Integer.parseInt(v[1]);
        }

        public Node(String ipPort) {
            String[] v = ipPort.split(":");
            if (v.length < 2) {
                throw new RuntimeException("The ipPort '" + ipPort + "' is invalid.");
            }
            this.hostName = v[0];
            this.port = Integer.parseInt(v[1]);
            this.load = -1.0;
        }

        public boolean isEqual(Node node) {
            return this.hostName.equals(node.hostName) && this.port == node.port;
        }

        static /* synthetic */ double access$902(Node x0, double x1) {
            x0.load = x1;
            return x0.load;
        }

        static /* synthetic */ double access$900(Node x0) {
            return x0.load;
        }
    }

    private static enum ExceptionType {
        ET_IGNORE(0),
        ET_UNKNOW(1),
        ET_NEWLEADER(2),
        ET_NODENOTAVAIL(3);

        public int value;

        private ExceptionType(int value) {
            this.value = value;
        }
    }

    private static enum ServerExceptionState {
        NEW_LEADER,
        WAIT,
        CONN_FAIL,
        OTHER_EXCEPTION,
        DATA_NODE_NOT_AVAILABLE;

    }
}

