/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.Double2;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.time.temporal.Temporal;

public class BasicComplex
extends AbstractScalar {
    protected Double2 value;

    public BasicComplex(double real, double image) {
        this.value = new Double2(real, image);
    }

    public BasicComplex(ExtendedDataInput in) throws IOException {
        this.value = in.readDouble2();
    }

    public Double2 getDouble2() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value.isNull();
    }

    @Override
    public void setNull() {
        this.value.setNull();
    }

    public double getReal() {
        return this.value.x;
    }

    public double getImage() {
        return this.value.y;
    }

    @Override
    public Number getNumber() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.BINARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_COMPLEX;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.value.x);
        if (this.value.y >= 0.0) {
            sb.append('+');
        }
        sb.append(this.value.y);
        sb.append('i');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicComplex) || o == null) {
            return false;
        }
        return this.value.equals(((BasicComplex)o).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int hashBucket(int buckets) {
        return this.value.hashBucket(buckets);
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return "\"" + this.getString() + "\"";
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeDouble2(this.value);
    }
}

