/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractScalar;
import com.xxdb.data.BasicDecimal32;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.time.temporal.Temporal;

public class BasicDecimal64
extends AbstractScalar
implements Comparable<BasicDecimal32> {
    private int scale_ = 0;
    private long value_;

    public BasicDecimal64(ExtendedDataInput in) throws IOException {
        this.scale_ = in.readInt();
        this.value_ = in.readLong();
    }

    public BasicDecimal64(int scale, long value) {
        this.scale_ = scale;
        this.value_ = value;
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.DECIMAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DECIMAL64;
    }

    @Override
    public String getString() {
        if (this.scale_ == 0 && !this.isNull()) {
            return String.valueOf(this.value_);
        }
        if (this.isNull()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append((long)((double)this.value_ / Math.pow(10.0, this.scale_)));
        int sign = this.value_ < 0L ? -1 : 1;
        double data = (double)this.value_ % Math.pow(10.0, this.scale_) * (double)sign;
        sb.append(".");
        if (data == 0.0) {
            for (int i = 0; i < this.scale_; ++i) {
                sb.append("0");
            }
        } else {
            sb.append((int)data);
        }
        return sb.toString();
    }

    @Override
    public boolean isNull() {
        return this.value_ == Long.MIN_VALUE;
    }

    @Override
    public void setNull() {
        this.value_ = Long.MIN_VALUE;
    }

    @Override
    public Number getNumber() throws Exception {
        return this.value_;
    }

    @Override
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public int hashBucket(int buckets) {
        return 0;
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return this.getString();
    }

    @Override
    public int compareTo(BasicDecimal32 o) {
        return 0;
    }
}

