/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicDecimal64;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BasicDecimal64Vector
extends AbstractVector {
    protected int scale_ = 0;
    protected long[] values;

    public BasicDecimal64Vector(Entity.DATA_FORM df) {
        super(df);
    }

    public BasicDecimal64Vector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicDecimal64Vector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new long[size];
    }

    public BasicDecimal64Vector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        ByteOrder bo;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new long[size];
        this.scale_ = in.readInt();
        int totalBytes = size * 8;
        boolean little = in.isLittleEndian();
        ByteOrder byteOrder = bo = little ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (int off = 0; off < totalBytes; off += len) {
            len = Math.min(4096, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int start = off / 8;
            int end = len / 8;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                long value;
                this.values[i + start] = value = byteBuffer.getLong(i * 8);
            }
        }
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
    }

    @Override
    public Vector combine(Vector vector) {
        return null;
    }

    @Override
    public Vector getSubVector(int[] indices) {
        return null;
    }

    @Override
    public int asof(Scalar value) {
        return 0;
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == Long.MIN_VALUE;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = Long.MIN_VALUE;
    }

    @Override
    public Scalar get(int index) {
        return new BasicDecimal64(this.scale_, this.values[index]);
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDecimal64.class;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
    }

    @Override
    public int getUnitLength() {
        return 8;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.DECIMAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DECIMAL64;
    }

    @Override
    public int rows() {
        return this.values.length;
    }
}

