/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicArrayVector;
import com.xxdb.data.BasicBoolean;
import com.xxdb.data.BasicBooleanMatrix;
import com.xxdb.data.BasicBooleanVector;
import com.xxdb.data.BasicByte;
import com.xxdb.data.BasicByteMatrix;
import com.xxdb.data.BasicByteVector;
import com.xxdb.data.BasicChart;
import com.xxdb.data.BasicChunkMeta;
import com.xxdb.data.BasicComplex;
import com.xxdb.data.BasicComplexMatrix;
import com.xxdb.data.BasicComplexVector;
import com.xxdb.data.BasicDate;
import com.xxdb.data.BasicDateHour;
import com.xxdb.data.BasicDateHourMatrix;
import com.xxdb.data.BasicDateHourVector;
import com.xxdb.data.BasicDateMatrix;
import com.xxdb.data.BasicDateTime;
import com.xxdb.data.BasicDateTimeMatrix;
import com.xxdb.data.BasicDateTimeVector;
import com.xxdb.data.BasicDateVector;
import com.xxdb.data.BasicDecimal32;
import com.xxdb.data.BasicDecimal32Vector;
import com.xxdb.data.BasicDecimal64;
import com.xxdb.data.BasicDecimal64Vector;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicDouble;
import com.xxdb.data.BasicDoubleMatrix;
import com.xxdb.data.BasicDoubleVector;
import com.xxdb.data.BasicDuration;
import com.xxdb.data.BasicDurationVector;
import com.xxdb.data.BasicFloat;
import com.xxdb.data.BasicFloatMatrix;
import com.xxdb.data.BasicFloatVector;
import com.xxdb.data.BasicIPAddr;
import com.xxdb.data.BasicIPAddrVector;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicInt128;
import com.xxdb.data.BasicInt128Vector;
import com.xxdb.data.BasicIntMatrix;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicLong;
import com.xxdb.data.BasicLongMatrix;
import com.xxdb.data.BasicLongVector;
import com.xxdb.data.BasicMinute;
import com.xxdb.data.BasicMinuteMatrix;
import com.xxdb.data.BasicMinuteVector;
import com.xxdb.data.BasicMonth;
import com.xxdb.data.BasicMonthMatrix;
import com.xxdb.data.BasicMonthVector;
import com.xxdb.data.BasicNanoTime;
import com.xxdb.data.BasicNanoTimeMatrix;
import com.xxdb.data.BasicNanoTimeVector;
import com.xxdb.data.BasicNanoTimestamp;
import com.xxdb.data.BasicNanoTimestampMatrix;
import com.xxdb.data.BasicNanoTimestampVector;
import com.xxdb.data.BasicPoint;
import com.xxdb.data.BasicPointVector;
import com.xxdb.data.BasicSecond;
import com.xxdb.data.BasicSecondMatrix;
import com.xxdb.data.BasicSecondVector;
import com.xxdb.data.BasicSet;
import com.xxdb.data.BasicShort;
import com.xxdb.data.BasicShortMatrix;
import com.xxdb.data.BasicShortVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringMatrix;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicSymbolVector;
import com.xxdb.data.BasicSystemEntity;
import com.xxdb.data.BasicTable;
import com.xxdb.data.BasicTime;
import com.xxdb.data.BasicTimeMatrix;
import com.xxdb.data.BasicTimeVector;
import com.xxdb.data.BasicTimestamp;
import com.xxdb.data.BasicTimestampMatrix;
import com.xxdb.data.BasicTimestampVector;
import com.xxdb.data.BasicUuid;
import com.xxdb.data.BasicUuidVector;
import com.xxdb.data.Entity;
import com.xxdb.data.EntityFactory;
import com.xxdb.data.Matrix;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.data.Void;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;

public class BasicEntityFactory
implements EntityFactory {
    private TypeFactory[] factories;
    private TypeFactory[] factoriesExt;
    private static EntityFactory factory = new BasicEntityFactory();

    public static EntityFactory instance() {
        return factory;
    }

    public BasicEntityFactory() {
        int typeCount = Entity.DATA_TYPE.DT_OBJECT.getValue() + 1;
        this.factories = new TypeFactory[typeCount];
        this.factoriesExt = new TypeFactory[typeCount];
        this.factories[Entity.DATA_TYPE.DT_BOOL.getValue()] = new BooleanFactory();
        this.factories[Entity.DATA_TYPE.DT_BYTE.getValue()] = new ByteFactory();
        this.factories[Entity.DATA_TYPE.DT_SHORT.getValue()] = new ShortFactory();
        this.factories[Entity.DATA_TYPE.DT_INT.getValue()] = new IntFactory();
        this.factories[Entity.DATA_TYPE.DT_LONG.getValue()] = new LongFactory();
        this.factories[Entity.DATA_TYPE.DT_FLOAT.getValue()] = new FloatFactory();
        this.factories[Entity.DATA_TYPE.DT_DOUBLE.getValue()] = new DoubleFactory();
        this.factories[Entity.DATA_TYPE.DT_MINUTE.getValue()] = new MinuteFactory();
        this.factories[Entity.DATA_TYPE.DT_SECOND.getValue()] = new SecondFactory();
        this.factories[Entity.DATA_TYPE.DT_TIME.getValue()] = new TimeFactory();
        this.factories[Entity.DATA_TYPE.DT_NANOTIME.getValue()] = new NanoTimeFactory();
        this.factories[Entity.DATA_TYPE.DT_DATE.getValue()] = new DateFactory();
        this.factories[Entity.DATA_TYPE.DT_DATEHOUR.getValue()] = new DateHourFactory();
        this.factories[Entity.DATA_TYPE.DT_MONTH.getValue()] = new MonthFactory();
        this.factories[Entity.DATA_TYPE.DT_DATETIME.getValue()] = new DateTimeFactory();
        this.factories[Entity.DATA_TYPE.DT_TIMESTAMP.getValue()] = new TimestampFactory();
        this.factories[Entity.DATA_TYPE.DT_NANOTIMESTAMP.getValue()] = new NanoTimestampFactory();
        this.factories[Entity.DATA_TYPE.DT_SYMBOL.getValue()] = new SymbolFactory();
        this.factories[Entity.DATA_TYPE.DT_STRING.getValue()] = new StringFactory();
        this.factories[Entity.DATA_TYPE.DT_BLOB.getValue()] = new BlobFactory();
        this.factories[Entity.DATA_TYPE.DT_FUNCTIONDEF.getValue()] = new FunctionDefFactory();
        this.factories[Entity.DATA_TYPE.DT_HANDLE.getValue()] = new SystemHandleFactory();
        this.factories[Entity.DATA_TYPE.DT_CODE.getValue()] = new MetaCodeFactory();
        this.factories[Entity.DATA_TYPE.DT_DATASOURCE.getValue()] = new DataSourceFactory();
        this.factories[Entity.DATA_TYPE.DT_RESOURCE.getValue()] = new ResourceFactory();
        this.factories[Entity.DATA_TYPE.DT_COMPRESS.getValue()] = new CompressFactory();
        this.factories[Entity.DATA_TYPE.DT_UUID.getValue()] = new UuidFactory();
        this.factories[Entity.DATA_TYPE.DT_INT128.getValue()] = new Int128Factory();
        this.factories[Entity.DATA_TYPE.DT_IPADDR.getValue()] = new IPAddrFactory();
        this.factories[Entity.DATA_TYPE.DT_COMPLEX.getValue()] = new ComplexFactory();
        this.factories[Entity.DATA_TYPE.DT_POINT.getValue()] = new PointFactory();
        this.factories[Entity.DATA_TYPE.DT_DURATION.getValue()] = new DurationFactory();
        this.factories[Entity.DATA_TYPE.DT_DECIMAL32.getValue()] = new Decimal32Factory();
        this.factories[Entity.DATA_TYPE.DT_DECIMAL64.getValue()] = new Decimal64Factory();
        this.factoriesExt[Entity.DATA_TYPE.DT_SYMBOL.getValue()] = new ExtendedSymbolFactory();
    }

    @Override
    public Entity createEntity(Entity.DATA_FORM form, Entity.DATA_TYPE type, ExtendedDataInput in, boolean extended) throws IOException {
        if (form == Entity.DATA_FORM.DF_TABLE) {
            return new BasicTable(in);
        }
        if (form == Entity.DATA_FORM.DF_CHART) {
            return new BasicChart(in);
        }
        if (form == Entity.DATA_FORM.DF_DICTIONARY) {
            return new BasicDictionary(type, in);
        }
        if (form == Entity.DATA_FORM.DF_SET) {
            return new BasicSet(type, in);
        }
        if (form == Entity.DATA_FORM.DF_CHUNK) {
            return new BasicChunkMeta(in);
        }
        if (type == Entity.DATA_TYPE.DT_ANY && (form == Entity.DATA_FORM.DF_VECTOR || form == Entity.DATA_FORM.DF_PAIR)) {
            return new BasicAnyVector(in);
        }
        if (type.getValue() >= Entity.DATA_TYPE.DT_BOOL_ARRAY.getValue() && type.getValue() <= Entity.DATA_TYPE.DT_POINT_ARRAY.getValue()) {
            return new BasicArrayVector(type, in);
        }
        if (type == Entity.DATA_TYPE.DT_VOID && form == Entity.DATA_FORM.DF_SCALAR) {
            in.readBoolean();
            return new Void();
        }
        int index = type.getValue();
        if (this.factories[index] == null) {
            throw new IOException("Data type " + type.name() + " is not supported yet.");
        }
        if (form == Entity.DATA_FORM.DF_VECTOR) {
            if (!extended) {
                return this.factories[index].createVector(in);
            }
            return this.factoriesExt[index].createVector(in);
        }
        if (form == Entity.DATA_FORM.DF_SCALAR) {
            return this.factories[index].createScalar(in);
        }
        if (form == Entity.DATA_FORM.DF_MATRIX) {
            return this.factories[index].createMatrix(in);
        }
        if (form == Entity.DATA_FORM.DF_PAIR) {
            return this.factories[index].createPair(in);
        }
        throw new IOException("Data form " + form.name() + " is not supported yet.");
    }

    @Override
    public Matrix createMatrixWithDefaultValue(Entity.DATA_TYPE type, int rows, int columns) {
        int index = type.getValue();
        if (this.factories[index] == null) {
            return null;
        }
        return this.factories[index].createMatrixWithDefaultValue(rows, columns);
    }

    @Override
    public Vector createVectorWithDefaultValue(Entity.DATA_TYPE type, int size) {
        int index = type.getValue();
        if (this.factories[index] == null) {
            return null;
        }
        return this.factories[index].createVectorWithDefaultValue(size);
    }

    @Override
    public Vector createPairWithDefaultValue(Entity.DATA_TYPE type) {
        int index = type.getValue();
        if (this.factories[index] == null) {
            return null;
        }
        return this.factories[index].createPairWithDefaultValue();
    }

    @Override
    public Scalar createScalarWithDefaultValue(Entity.DATA_TYPE type) {
        int index = type.getValue();
        if (this.factories[index] == null) {
            return null;
        }
        return this.factories[index].createScalarWithDefaultValue();
    }

    public static Entity createScalar(Entity.DATA_TYPE dataType, Object object) throws Exception {
        if (object == null && dataType.getValue() < 65) {
            Scalar scalar = BasicEntityFactory.instance().createScalarWithDefaultValue(dataType);
            scalar.setNull();
            return scalar;
        }
        if (object == null && dataType.getValue() >= 65) {
            dataType = Entity.DATA_TYPE.values()[dataType.getValue() - 64];
            Vector vector = BasicEntityFactory.instance().createVectorWithDefaultValue(dataType, 0);
            return vector;
        }
        if (object instanceof Boolean) {
            return BasicEntityFactory.createScalar(dataType, (Boolean)object);
        }
        if (object instanceof Boolean[]) {
            return BasicEntityFactory.createAnyVector(dataType, (Boolean[])object);
        }
        if (object instanceof Byte) {
            return BasicEntityFactory.createScalar(dataType, (Byte)object);
        }
        if (object instanceof Byte[]) {
            return BasicEntityFactory.createAnyVector(dataType, (Byte[])object);
        }
        if (object instanceof Character) {
            return BasicEntityFactory.createScalar(dataType, ((Character)object).charValue());
        }
        if (object instanceof Character[]) {
            return BasicEntityFactory.createAnyVector(dataType, (Character[])object);
        }
        if (object instanceof Short) {
            return BasicEntityFactory.createScalar(dataType, (Short)object);
        }
        if (object instanceof Short[]) {
            return BasicEntityFactory.createAnyVector(dataType, (Short[])object);
        }
        if (object instanceof Integer) {
            return BasicEntityFactory.createScalar(dataType, (Integer)object);
        }
        if (object instanceof Integer[]) {
            return BasicEntityFactory.createAnyVector(dataType, (Integer[])object);
        }
        if (object instanceof Long) {
            return BasicEntityFactory.createScalar(dataType, (Long)object);
        }
        if (object instanceof Long[]) {
            return BasicEntityFactory.createAnyVector(dataType, (Long[])object);
        }
        if (object instanceof Double) {
            return BasicEntityFactory.createScalar(dataType, (Double)object);
        }
        if (object instanceof Double[]) {
            return BasicEntityFactory.createAnyVector(dataType, (Double[])object);
        }
        if (object instanceof Float) {
            return BasicEntityFactory.createScalar(dataType, ((Float)object).floatValue());
        }
        if (object instanceof Float[]) {
            return BasicEntityFactory.createAnyVector(dataType, (Float[])object);
        }
        if (object instanceof String) {
            return BasicEntityFactory.createScalar(dataType, (String)object);
        }
        if (object instanceof String[]) {
            return BasicEntityFactory.createAnyVector(dataType, (String[])object);
        }
        if (object instanceof LocalTime) {
            return BasicEntityFactory.createScalar(dataType, (LocalTime)object);
        }
        if (object instanceof LocalTime[]) {
            return BasicEntityFactory.createAnyVector(dataType, (LocalTime[])object);
        }
        if (object instanceof LocalDate) {
            return BasicEntityFactory.createScalar(dataType, (LocalDate)object);
        }
        if (object instanceof LocalDate[]) {
            return BasicEntityFactory.createAnyVector(dataType, (LocalDate[])object);
        }
        if (object instanceof LocalDateTime) {
            return BasicEntityFactory.createScalar(dataType, (LocalDateTime)object);
        }
        if (object instanceof LocalDateTime[]) {
            return BasicEntityFactory.createAnyVector(dataType, (LocalDateTime[])object);
        }
        if (object instanceof Date) {
            return BasicEntityFactory.createScalar(dataType, (Date)object);
        }
        if (object instanceof Date[]) {
            return BasicEntityFactory.createAnyVector(dataType, (Date[])object);
        }
        if (object instanceof Calendar) {
            return BasicEntityFactory.createScalar(dataType, (Calendar)object);
        }
        if (object instanceof Calendar[]) {
            return BasicEntityFactory.createAnyVector(dataType, (Calendar[])object);
        }
        if (object instanceof Entity) {
            return BasicEntityFactory.createScalar(dataType, (Entity)object);
        }
        if (object instanceof Entity[]) {
            return BasicEntityFactory.createAnyVector(dataType, (Entity[])object);
        }
        throw new RuntimeException("Failed to insert data. invalid data type for " + (Object)((Object)dataType) + ".");
    }

    private static <T> Vector createAnyVector(Entity.DATA_TYPE dataType, T[] val) throws Exception {
        if (dataType.getValue() < 64) {
            throw new RuntimeException("Failed to insert data, only arrayVector support data vector for " + (Object)((Object)dataType) + ".");
        }
        dataType = Entity.DATA_TYPE.values()[dataType.getValue() - 64];
        int count = val.length;
        Vector vector = BasicEntityFactory.instance().createVectorWithDefaultValue(dataType, count);
        for (int i = 0; i < count; ++i) {
            Entity t = BasicEntityFactory.createScalar(dataType, val[i]);
            vector.set(i, (Scalar)t);
        }
        return vector;
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, LocalDate val) {
        switch (dataType) {
            case DT_DATE: {
                return new BasicDate(val);
            }
            case DT_MONTH: {
                return new BasicMonth(val.getYear(), val.getMonth());
            }
        }
        throw new RuntimeException("Failed to insert data. Cannot convert LocalDate to " + (Object)((Object)dataType) + ".");
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, LocalDateTime val) {
        switch (dataType) {
            case DT_DATETIME: {
                return new BasicDateTime(val);
            }
            case DT_DATEHOUR: {
                return new BasicDateHour(val);
            }
            case DT_TIMESTAMP: {
                return new BasicTimestamp(val);
            }
            case DT_NANOTIME: {
                return new BasicNanoTime(val);
            }
            case DT_NANOTIMESTAMP: {
                return new BasicNanoTimestamp(val);
            }
        }
        throw new RuntimeException("Failed to insert data. Cannot convert LocalDateTime to " + (Object)((Object)dataType) + ".");
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, LocalTime val) {
        switch (dataType) {
            case DT_TIME: {
                return new BasicTime(val);
            }
            case DT_SECOND: {
                return new BasicSecond(val);
            }
            case DT_MINUTE: {
                return new BasicMinute(val);
            }
            case DT_NANOTIME: {
                return new BasicNanoTime(val);
            }
        }
        throw new RuntimeException("Failed to insert data. Cannot convert LocalTime to " + (Object)((Object)dataType) + ".");
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, Date val) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(val);
        return BasicEntityFactory.createScalar(dataType, calendar);
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, Calendar val) {
        switch (dataType) {
            case DT_DATE: {
                return new BasicDate(val);
            }
            case DT_MONTH: {
                return new BasicMonth(val);
            }
            case DT_TIME: {
                return new BasicTime(val);
            }
            case DT_SECOND: {
                return new BasicSecond(val);
            }
            case DT_MINUTE: {
                return new BasicMinute(val);
            }
            case DT_DATETIME: {
                return new BasicDateTime(val);
            }
            case DT_DATEHOUR: {
                return new BasicDateHour(val);
            }
            case DT_TIMESTAMP: {
                return new BasicTimestamp(val);
            }
        }
        throw new RuntimeException("Failed to insert data. Cannot convert Calendar to " + (Object)((Object)dataType) + ".");
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, Entity val) {
        if (val.isScalar() && val.getDataType() == dataType || dataType == Entity.DATA_TYPE.DT_SYMBOL) {
            return (Scalar)val;
        }
        throw new RuntimeException("Failed to insert data. Cannot convert Entity to " + (Object)((Object)dataType) + ".");
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, boolean val) {
        switch (dataType) {
            case DT_BOOL: {
                return new BasicBoolean(val);
            }
        }
        throw new RuntimeException("Failed to insert data. Cannot convert boolean to " + (Object)((Object)dataType) + ".");
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, char val) {
        if (val >= '\uffffff80' && val <= '\u007f') {
            return BasicEntityFactory.createScalar(dataType, (byte)val);
        }
        throw new RuntimeException("Failed to insert data, char cannot be converted because it exceeds the range of " + (Object)((Object)dataType) + ".");
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, byte val) {
        switch (dataType) {
            case DT_BYTE: {
                return new BasicByte(val);
            }
            case DT_SHORT: {
                return new BasicShort(val);
            }
            case DT_INT: {
                return new BasicInt(val);
            }
            case DT_LONG: {
                return new BasicLong(val);
            }
        }
        throw new RuntimeException("Failed to insert data. Cannot convert byte to " + (Object)((Object)dataType) + ".");
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, short val) {
        switch (dataType) {
            case DT_BYTE: {
                if (val >= -128 && val <= 127) {
                    return new BasicByte((byte)val);
                }
                throw new RuntimeException("Failed to insert data, short cannot be converted because it exceeds the range of " + (Object)((Object)dataType) + ".");
            }
            case DT_SHORT: {
                return new BasicShort(val);
            }
            case DT_INT: {
                return new BasicInt(val);
            }
            case DT_LONG: {
                return new BasicLong(val);
            }
        }
        throw new RuntimeException("Failed to insert data. Cannot convert short to " + (Object)((Object)dataType) + ".");
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, char[] val) {
        return BasicEntityFactory.createScalar(dataType, new String(val));
    }

    private static boolean isScalarValid(Entity.DATA_TYPE scalarType, Entity.DATA_TYPE expectedType) {
        if (scalarType == expectedType) {
            return true;
        }
        return scalarType == Entity.DATA_TYPE.DT_STRING && expectedType == Entity.DATA_TYPE.DT_SYMBOL;
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, String val) {
        switch (dataType) {
            case DT_INT128: {
                return BasicInt128.fromString(val);
            }
            case DT_UUID: {
                return BasicUuid.fromString(val);
            }
            case DT_IPADDR: {
                return BasicIPAddr.fromString(val);
            }
            case DT_SYMBOL: 
            case DT_BLOB: {
                return new BasicString(val, dataType == Entity.DATA_TYPE.DT_BLOB);
            }
            case DT_STRING: {
                return new BasicString(val);
            }
        }
        throw new RuntimeException("Failed to insert data. Cannot convert String to " + (Object)((Object)dataType) + ".");
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, float val) {
        switch (dataType) {
            case DT_FLOAT: {
                return new BasicFloat(val);
            }
            case DT_DOUBLE: {
                return new BasicDouble(val);
            }
        }
        throw new RuntimeException("Failed to insert data. Cannot convert float to " + (Object)((Object)dataType) + ".");
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, double val) {
        switch (dataType) {
            case DT_FLOAT: {
                if (val >= (double)1.4E-45f && val <= 3.4028234663852886E38 || val >= -3.4028234663852886E38 && val <= (double)-1.4E-45f) {
                    return new BasicFloat((float)val);
                }
                throw new RuntimeException("Failed to insert data, double cannot be converted because it exceeds the range of " + (Object)((Object)dataType) + ".");
            }
            case DT_DOUBLE: {
                return new BasicDouble(val);
            }
        }
        throw new RuntimeException("Failed to insert data. Cannot convert double to " + (Object)((Object)dataType) + ".");
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, int val) {
        switch (dataType) {
            case DT_BYTE: {
                if (val >= -128 && val <= 127) {
                    return new BasicByte((byte)val);
                }
                throw new RuntimeException("Failed to insert data, int cannot be converted because it exceeds the range of " + (Object)((Object)dataType) + ".");
            }
            case DT_SHORT: {
                if (val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) {
                    return new BasicShort((short)val);
                }
                throw new RuntimeException("Failed to insert data, int cannot be converted because it exceeds the range of " + (Object)((Object)dataType) + ".");
            }
            case DT_INT: {
                return new BasicInt(val);
            }
            case DT_LONG: {
                return new BasicLong(val);
            }
            case DT_DATE: {
                return new BasicDate(val);
            }
            case DT_MONTH: {
                return new BasicMonth(val);
            }
            case DT_TIME: {
                return new BasicTime(val);
            }
            case DT_SECOND: {
                return new BasicSecond(val);
            }
            case DT_MINUTE: {
                return new BasicMinute(val);
            }
            case DT_DATETIME: {
                return new BasicDateTime(val);
            }
            case DT_DATEHOUR: {
                return new BasicDateHour(val);
            }
        }
        throw new RuntimeException("Failed to insert data. Cannot convert int to " + (Object)((Object)dataType) + ".");
    }

    private static Scalar createScalar(Entity.DATA_TYPE dataType, long val) {
        switch (dataType) {
            case DT_BYTE: {
                if (val >= -128L && val <= 127L) {
                    return new BasicByte((byte)val);
                }
                throw new RuntimeException("Failed to insert data, long cannot be converted because it exceeds the range of " + (Object)((Object)dataType) + ".");
            }
            case DT_SHORT: {
                if (val >= -32768L && val <= 32767L) {
                    return new BasicShort((short)val);
                }
                throw new RuntimeException("Failed to insert data, long cannot be converted because it exceeds the range of " + (Object)((Object)dataType) + ".");
            }
            case DT_INT: {
                if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
                    return new BasicInt((int)val);
                }
                throw new RuntimeException("Failed to insert data, long cannot be converted because it exceeds the range of " + (Object)((Object)dataType) + ".");
            }
            case DT_LONG: {
                return new BasicLong(val);
            }
            case DT_NANOTIME: {
                return new BasicNanoTime(val);
            }
            case DT_NANOTIMESTAMP: {
                return new BasicNanoTimestamp(val);
            }
            case DT_TIMESTAMP: {
                return new BasicTimestamp(val);
            }
        }
        throw new RuntimeException("Failed to insert data. Cannot convert long to " + (Object)((Object)dataType) + ".");
    }

    private class CompressFactory
    extends StringFactory {
        private CompressFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicSystemEntity(in, Entity.DATA_TYPE.DT_COMPRESS);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicByteVector(Entity.DATA_FORM.DF_VECTOR, in);
        }
    }

    private class ResourceFactory
    extends StringFactory {
        private ResourceFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicSystemEntity(in, Entity.DATA_TYPE.DT_RESOURCE);
        }
    }

    private class SystemHandleFactory
    extends StringFactory {
        private SystemHandleFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicSystemEntity(in, Entity.DATA_TYPE.DT_HANDLE);
        }
    }

    private class DataSourceFactory
    extends StringFactory {
        private DataSourceFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicSystemEntity(in, Entity.DATA_TYPE.DT_DATASOURCE);
        }
    }

    private class MetaCodeFactory
    extends StringFactory {
        private MetaCodeFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicSystemEntity(in, Entity.DATA_TYPE.DT_CODE);
        }
    }

    private class FunctionDefFactory
    extends StringFactory {
        private FunctionDefFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicSystemEntity(in, Entity.DATA_TYPE.DT_FUNCTIONDEF);
        }
    }

    private class BlobFactory
    implements TypeFactory {
        private BlobFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicString(in, true);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicStringVector(Entity.DATA_FORM.DF_VECTOR, in, false, true);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, in, false, true);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicStringMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicString("", true);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicStringVector(Entity.DATA_FORM.DF_VECTOR, size, false, true);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, 2, false, true);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicStringMatrix(rows, columns);
        }
    }

    private class ExtendedSymbolFactory
    implements TypeFactory {
        private ExtendedSymbolFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicString(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicSymbolVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicSymbolVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicStringMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicString("");
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicSymbolVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, 2, true);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicStringMatrix(rows, columns);
        }
    }

    private class SymbolFactory
    implements TypeFactory {
        private SymbolFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicString(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicStringVector(Entity.DATA_FORM.DF_VECTOR, in, false, false);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, in, false, false);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicStringMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicString("");
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicStringVector(Entity.DATA_FORM.DF_VECTOR, size, true);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, 2, true);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicStringMatrix(rows, columns);
        }
    }

    private class StringFactory
    implements TypeFactory {
        private StringFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicString(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicStringVector(Entity.DATA_FORM.DF_VECTOR, in, false, false);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, in, false, false);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicStringMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicString("");
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicStringVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, 2, false);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicStringMatrix(rows, columns);
        }
    }

    private class DurationFactory
    implements TypeFactory {
        private DurationFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicDuration(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            throw new RuntimeException("Vector for Duration not supported yet.");
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicDurationVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            throw new RuntimeException("Matrix for Duration not supported yet.");
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicDuration(Entity.DURATION.NS, 0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            throw new RuntimeException("Vector for Duration not supported yet.");
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicDurationVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            throw new RuntimeException("Matrix for Duration not supported yet.");
        }
    }

    private class PointFactory
    implements TypeFactory {
        private PointFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicPoint(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicPointVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicPointVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            throw new RuntimeException("Matrix for Point not supported yet.");
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicPoint(0.0, 0.0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicPointVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicPointVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            throw new RuntimeException("Matrix for Point not supported yet.");
        }
    }

    private class ComplexFactory
    implements TypeFactory {
        private ComplexFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicComplex(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicComplexVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicComplexVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicComplexMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicComplex(0.0, 0.0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicComplexVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicComplexVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicComplexMatrix(rows, columns);
        }
    }

    private class IPAddrFactory
    implements TypeFactory {
        private IPAddrFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicIPAddr(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicIPAddrVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicIPAddrVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            throw new RuntimeException("Matrix for IPADDR not supported yet.");
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicIPAddr(0L, 0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicIPAddrVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicIPAddrVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            throw new RuntimeException("Matrix for IPADDR not supported yet.");
        }
    }

    private class UuidFactory
    implements TypeFactory {
        private UuidFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicUuid(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicUuidVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicUuidVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            throw new RuntimeException("Matrix for UUID not supported yet.");
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicUuid(0L, 0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicUuidVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicUuidVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            throw new RuntimeException("Matrix for UUID not supported yet.");
        }
    }

    private class Int128Factory
    implements TypeFactory {
        private Int128Factory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicInt128(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicInt128Vector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicInt128Vector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            throw new RuntimeException("Matrix for INT128 not supported yet.");
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicInt128(0L, 0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicInt128Vector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicInt128Vector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            throw new RuntimeException("Matrix for INT128 not supported yet.");
        }
    }

    private class NanoTimestampFactory
    implements TypeFactory {
        private NanoTimestampFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicNanoTimestamp(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicNanoTimestampVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicNanoTimestampVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicNanoTimestampMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicNanoTimestamp(0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicNanoTimestampVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicNanoTimestampVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicNanoTimestampMatrix(rows, columns);
        }
    }

    private class TimestampFactory
    implements TypeFactory {
        private TimestampFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicTimestamp(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicTimestampVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicTimestampVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicTimestampMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicTimestamp(0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicTimestampVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicTimestampVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicTimestampMatrix(rows, columns);
        }
    }

    private class DateTimeFactory
    implements TypeFactory {
        private DateTimeFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicDateTime(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicDateTimeVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicDateTimeVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicDateTimeMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicDateTime(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicDateTimeVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicDateTimeVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicDateTimeMatrix(rows, columns);
        }
    }

    private class MonthFactory
    implements TypeFactory {
        private MonthFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicMonth(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicMonthVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicMonthVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicMonthMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicMonth(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicMonthVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicMonthVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicMonthMatrix(rows, columns);
        }
    }

    private class DateHourFactory
    implements TypeFactory {
        private DateHourFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicDateHour(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicDateHourVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicDateHourVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicDateHourMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicDateHour(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicDateHourVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicDateHourVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicDateHourMatrix(rows, columns);
        }
    }

    private class DateFactory
    implements TypeFactory {
        private DateFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicDate(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicDateVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicDateVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicDateMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicDate(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicDateVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicDateVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicDateMatrix(rows, columns);
        }
    }

    private class NanoTimeFactory
    implements TypeFactory {
        private NanoTimeFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicNanoTime(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicNanoTimeVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicNanoTimeVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicNanoTimeMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicNanoTime(0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicNanoTimeVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicNanoTimeVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicNanoTimeMatrix(rows, columns);
        }
    }

    private class TimeFactory
    implements TypeFactory {
        private TimeFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicTime(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicTimeVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicTimeVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicTimeMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicTime(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicTimeVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicTimeVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicTimeMatrix(rows, columns);
        }
    }

    private class SecondFactory
    implements TypeFactory {
        private SecondFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicSecond(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicSecondVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicSecondVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicSecondMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicInt(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicSecondVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicSecondVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicSecondMatrix(rows, columns);
        }
    }

    private class MinuteFactory
    implements TypeFactory {
        private MinuteFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicMinute(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicMinuteVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicMinuteVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicMinuteMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicMinute(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicMinuteVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicMinuteVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicMinuteMatrix(rows, columns);
        }
    }

    private class DoubleFactory
    implements TypeFactory {
        private DoubleFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicDouble(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicDoubleVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicDoubleVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicDoubleMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicDouble(0.0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicDoubleVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicDoubleVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicDoubleMatrix(rows, columns);
        }
    }

    private class FloatFactory
    implements TypeFactory {
        private FloatFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicFloat(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicFloatVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicFloatVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicFloatMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicFloat(0.0f);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicFloatVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicFloatVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicFloatMatrix(rows, columns);
        }
    }

    private class LongFactory
    implements TypeFactory {
        private LongFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicLong(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicLongVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicLongVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicLongMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicLong(0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicLongVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicLongVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicLongMatrix(rows, columns);
        }
    }

    private class IntFactory
    implements TypeFactory {
        private IntFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicInt(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicIntVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicIntVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicIntMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicInt(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicIntVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicIntVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicIntMatrix(rows, columns);
        }
    }

    private class ShortFactory
    implements TypeFactory {
        private ShortFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicShort(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicShortVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicShortVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicShortMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicShort(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicShortVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicShortVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicShortMatrix(rows, columns);
        }
    }

    private class ByteFactory
    implements TypeFactory {
        private ByteFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicByte(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicByteVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicByteVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicByteMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicByte(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicByteVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicByteVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicByteMatrix(rows, columns);
        }
    }

    private class BooleanFactory
    implements TypeFactory {
        private BooleanFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicBoolean(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicBooleanVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicBooleanVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicBooleanMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicBoolean(false);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicBooleanVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicBooleanVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicBooleanMatrix(rows, columns);
        }
    }

    private class Decimal32Factory
    implements TypeFactory {
        private Decimal32Factory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicDecimal32(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicDecimal32Vector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return null;
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return null;
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicDecimal32(0, 0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicDecimal32Vector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return null;
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return null;
        }
    }

    private class Decimal64Factory
    implements TypeFactory {
        private Decimal64Factory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicDecimal64(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicDecimal64Vector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return null;
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return null;
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicDecimal64(0, 0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicDecimal64Vector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return null;
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return null;
        }
    }

    private static interface TypeFactory {
        public Scalar createScalar(ExtendedDataInput var1) throws IOException;

        public Vector createVector(ExtendedDataInput var1) throws IOException;

        public Vector createPair(ExtendedDataInput var1) throws IOException;

        public Matrix createMatrix(ExtendedDataInput var1) throws IOException;

        public Scalar createScalarWithDefaultValue();

        public Vector createVectorWithDefaultValue(int var1);

        public Vector createPairWithDefaultValue();

        public Matrix createMatrixWithDefaultValue(int var1, int var2);
    }
}

