/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicInt128;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.io.Long2;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class BasicInt128Vector
extends AbstractVector {
    protected Long2[] values;

    public BasicInt128Vector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicInt128Vector(List<Long2> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new Long2[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i) != null ? list.get(i) : new Long2(0L, 0L);
            }
        }
    }

    public BasicInt128Vector(Long2[] array) {
        this(array, true);
    }

    protected BasicInt128Vector(Long2[] array, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = copy ? (Long2[])array.clone() : array;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != null) continue;
            this.values[i] = new Long2(0L, 0L);
        }
    }

    protected BasicInt128Vector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new Long2[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = new Long2(0L, 0L);
        }
    }

    protected BasicInt128Vector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        ByteOrder bo;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new Long2[size];
        int totalBytes = size * 16;
        boolean littleEndian = in.isLittleEndian();
        ByteOrder byteOrder = bo = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (int off = 0; off < totalBytes; off += len) {
            int i;
            len = Math.min(4096, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int start = off / 16;
            int end = len / 16;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            if (littleEndian) {
                for (i = 0; i < end; ++i) {
                    long low = byteBuffer.getLong(i * 16);
                    long high = byteBuffer.getLong(i * 16 + 8);
                    this.values[i + start] = new Long2(high, low);
                }
                continue;
            }
            for (i = 0; i < end; ++i) {
                long high = byteBuffer.getLong(i * 16);
                long low = byteBuffer.getLong(i * 16 + 8);
                this.values[i + start] = new Long2(high, low);
            }
        }
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        int totalBytes = count * 16;
        int off = 0;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        boolean littleEndian = in.isLittleEndian();
        while (off < totalBytes) {
            int i;
            int len = Math.min(4096, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int end = len / 16;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            if (littleEndian) {
                for (i = 0; i < end; ++i) {
                    long low = byteBuffer.getLong(i * 16);
                    long high = byteBuffer.getLong(i * 16 + 8);
                    this.values[i + start] = new Long2(high, low);
                }
            } else {
                for (i = 0; i < end; ++i) {
                    long high = byteBuffer.getLong(i * 16);
                    long low = byteBuffer.getLong(i * 16 + 8);
                    this.values[i + start] = new Long2(high, low);
                }
            }
            off += len;
            start += end;
        }
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeLong2(this.values[start + i]);
        }
    }

    @Override
    public Scalar get(int index) {
        return new BasicInt128(this.values[index].high, this.values[index].low);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        Long2[] sub = new Long2[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicInt128Vector(sub, false);
    }

    protected Long2[] getSubArray(int[] indices) {
        int length = indices.length;
        Long2[] sub = new Long2[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return sub;
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
        this.values[index].high = ((BasicInt128)value).getMostSignicantBits();
        this.values[index].low = ((BasicInt128)value).getLeastSignicantBits();
    }

    public void setInt128(int index, long highValue, long lowValue) {
        this.values[index].high = highValue;
        this.values[index].low = lowValue;
    }

    @Override
    public int hashBucket(int index, int buckets) {
        return this.values[index].hashBucket(buckets);
    }

    @Override
    public int getUnitLength() {
        return 16;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicInt128Vector v = (BasicInt128Vector)vector;
        int newSize = this.rows() + v.rows();
        Long2[] newValue = new Long2[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicInt128Vector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index].isNull();
    }

    @Override
    public void setNull(int index) {
        this.values[index].setNull();
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.BINARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_INT128;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicInt128.class;
    }

    @Override
    public int rows() {
        return this.values.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeLong2Array(this.values);
    }

    @Override
    public int asof(Scalar value) {
        throw new RuntimeException("BasicInt128Vector.asof not supported.");
    }

    @Override
    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        boolean isLittleEndian = buffer.order() == ByteOrder.LITTLE_ENDIAN;
        for (Long2 val : this.values) {
            if (isLittleEndian) {
                buffer.putLong(val.low);
                buffer.putLong(val.high);
                continue;
            }
            buffer.putLong(val.high);
            buffer.putLong(val.low);
        }
        return buffer;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        boolean isLittleEndian = out.order() == ByteOrder.LITTLE_ENDIAN;
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            if (isLittleEndian) {
                out.putLong(this.values[indexStart + i].low);
                out.putLong(this.values[indexStart + i].high);
                continue;
            }
            out.putLong(this.values[indexStart + i].high);
            out.putLong(this.values[indexStart + i].low);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement * 16;
    }
}

