/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.time.temporal.Temporal;

public class BasicBoolean
extends AbstractScalar
implements Comparable<BasicBoolean> {
    private byte value;

    public BasicBoolean(boolean value) {
        this.value = value ? (byte)1 : 0;
    }

    public BasicBoolean(ExtendedDataInput in) throws IOException {
        this.value = in.readByte();
    }

    protected BasicBoolean(byte value) {
        this.value = value;
    }

    public boolean getBoolean() {
        return this.value != 0;
    }

    @Override
    public boolean isNull() {
        return this.value == -128;
    }

    @Override
    public void setNull() {
        this.value = (byte)-128;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.LOGICAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_BOOL;
    }

    @Override
    public Number getNumber() throws Exception {
        if (this.isNull()) {
            return (byte)-128;
        }
        return this.value;
    }

    @Override
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        return String.valueOf(this.getBoolean());
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicBoolean) || o == null) {
            return false;
        }
        return this.value == ((BasicBoolean)o).value;
    }

    public int hashCode() {
        return new Byte(this.value).hashCode();
    }

    @Override
    public int hashBucket(int buckets) {
        return -1;
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return this.getString();
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeByte(this.value);
    }

    @Override
    public int compareTo(BasicBoolean o) {
        return Byte.compare(this.value, o.value);
    }
}

