/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.time.temporal.Temporal;

public class BasicByte
extends AbstractScalar
implements Comparable<BasicByte> {
    private byte value;

    public BasicByte(byte value) {
        this.value = value;
    }

    public BasicByte(ExtendedDataInput in) throws IOException {
        this.value = in.readByte();
    }

    public byte getByte() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value == -128;
    }

    @Override
    public void setNull() {
        this.value = (byte)-128;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_BYTE;
    }

    @Override
    public Number getNumber() throws Exception {
        if (this.isNull()) {
            return (byte)-128;
        }
        return this.value;
    }

    @Override
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        if (this.value > 31 && this.value < 127) {
            return "'" + String.valueOf((char)this.value) + "'";
        }
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicByte) || o == null) {
            return false;
        }
        return this.value == ((BasicByte)o).value;
    }

    public int hashCode() {
        return new Byte(this.value).hashCode();
    }

    @Override
    public int hashBucket(int buckets) {
        if (this.value >= 0) {
            return this.value % buckets;
        }
        if (this.value == -128) {
            return -1;
        }
        return (int)((0x100000000L + (long)this.value) % (long)buckets);
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return this.getString();
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeByte(this.value);
    }

    @Override
    public int compareTo(BasicByte o) {
        return Byte.compare(this.value, o.value);
    }
}

