/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicDecimal64;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class BasicDecimal64Vector
extends AbstractVector {
    private int scale_ = 0;
    private long[] values;
    private int size;
    private int capaticy;

    BasicDecimal64Vector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicDecimal64Vector(int size, int scale) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.scale_ = scale;
        this.values = new long[size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    BasicDecimal64Vector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new long[size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicDecimal64Vector(Entity.DATA_FORM df, ExtendedDataInput in, int extra) throws IOException {
        super(df);
        int len;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new long[size];
        this.scale_ = extra != -1 ? extra : in.readInt();
        int totalBytes = size * 8;
        boolean little = in.isLittleEndian();
        ByteOrder bo = little ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        for (int off = 0; off < totalBytes; off += len) {
            len = Math.min(4096, totalBytes - off);
            in.readFully(buf, 0, len);
            int start = off / 8;
            int end = len / 8;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                long value;
                this.values[i + start] = value = byteBuffer.getLong(i * 8);
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicDecimal64Vector(double[] data, int scale) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.scale_ = scale;
        long[] newIntValue = new long[data.length];
        for (int i = 0; i < data.length; ++i) {
            BigDecimal pow = new BigDecimal(10);
            for (long j = 0L; j < (long)(this.scale_ - 1); ++j) {
                pow = pow.multiply(new BigDecimal(10));
            }
            BigDecimal dbvalue = new BigDecimal(Double.toString(data[i]));
            newIntValue[i] = dbvalue.multiply(pow).longValue();
        }
        this.values = newIntValue;
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        int totalBytes = count * 4;
        int off = 0;
        this.scale_ = in.readInt();
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        while (off < totalBytes) {
            int len = Math.min(4096, totalBytes - off);
            in.readFully(buf, 0, len);
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getLong(i * 4);
            }
            off += len;
            start += end;
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        long[] data = new long[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        out.writeInt(this.scale_);
        out.writeLongArray(data);
    }

    @Override
    public Vector combine(Vector vector) {
        return null;
    }

    @Override
    public Vector getSubVector(int[] indices) {
        return null;
    }

    @Override
    public int asof(Scalar value) {
        return 0;
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == Long.MIN_VALUE;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = Long.MIN_VALUE;
    }

    @Override
    public Entity get(int index) {
        return new BasicDecimal64(this.scale_, this.values[index]);
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        if (((Scalar)value).getScale() != this.scale_ && this.scale_ >= 0) {
            throw new RuntimeException("Value's scale is not the same as the vector's!");
        }
        this.scale_ = ((Scalar)value).getScale();
        if (((Scalar)value).isNull()) {
            this.values[index] = Long.MIN_VALUE;
        } else {
            double data = ((Scalar)value).getNumber().doubleValue();
            if (data == 0.0) {
                this.values[index] = 0L;
            } else {
                BigDecimal pow = new BigDecimal(10);
                for (long i = 0L; i < (long)(this.scale_ - 1); ++i) {
                    pow = pow.multiply(new BigDecimal(10));
                }
                BigDecimal dbvalue = new BigDecimal(Double.toString(data));
                this.values[index] = dbvalue.multiply(pow).longValue();
            }
        }
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDecimal64.class;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        throw new RuntimeException("Decimal32 does not support arrayVector");
    }

    @Override
    public int getUnitLength() {
        return 8;
    }

    public void add(double value) {
        if (this.scale_ < 0) {
            throw new RuntimeException("Please set scale first.");
        }
        if (this.size + 1 > this.capaticy && this.values.length > 0) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        } else if (this.values.length <= 0) {
            this.values = Arrays.copyOf(this.values, this.values.length + 1);
        }
        this.capaticy = this.values.length;
        if (value == 0.0) {
            this.values[this.size] = 0L;
        } else {
            BigDecimal pow = new BigDecimal(10);
            for (long i = 0L; i < (long)(this.scale_ - 1); ++i) {
                pow = pow.multiply(new BigDecimal(10));
            }
            BigDecimal dbvalue = new BigDecimal(Double.toString(value));
            this.values[this.size] = dbvalue.multiply(pow).longValue();
        }
        ++this.size;
    }

    void addRange(long[] valueList) {
        this.values = Arrays.copyOf(this.values, valueList.length + this.values.length);
        System.arraycopy(valueList, 0, this.values, this.size, valueList.length);
        this.size += valueList.length;
        this.capaticy = this.values.length;
    }

    public void addRange(double[] valueList) {
        if (this.scale_ < 0) {
            throw new RuntimeException("Please set scale first.");
        }
        long[] newLongValue = new long[valueList.length];
        for (int i = 0; i < valueList.length; ++i) {
            BigDecimal pow = new BigDecimal(10);
            for (long j = 0L; j < (long)(this.scale_ - 1); ++j) {
                pow = pow.multiply(new BigDecimal(10));
            }
            BigDecimal dbvalue = new BigDecimal(Double.toString(valueList[i]));
            newLongValue[i] = dbvalue.multiply(pow).longValue();
        }
        this.values = Arrays.copyOf(this.values, newLongValue.length + this.values.length);
        System.arraycopy(newLongValue, 0, this.values, this.size, newLongValue.length);
        this.size += newLongValue.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void Append(Scalar value) throws Exception {
        if (((BasicDecimal64)value).getScale() != this.scale_ && this.scale_ >= 0) {
            throw new RuntimeException("The value's scale is different from the inserted target.");
        }
        this.scale_ = ((BasicDecimal64)value).getScale();
        this.add(value.getNumber().doubleValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        if (((BasicDecimal64Vector)value).getScale() != this.scale_ && this.scale_ >= 0) {
            throw new RuntimeException("The value's scale is different from the inserted target.");
        }
        this.scale_ = ((BasicDecimal64Vector)value).getScale();
        this.addRange(((BasicDecimal64Vector)value).getdataArray());
    }

    public long[] getdataArray() {
        long[] data = new long[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        return data;
    }

    public void setScale(int scale) {
        this.scale_ = scale;
    }

    public int getScale() {
        return this.scale_;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.DENARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DECIMAL64;
    }

    @Override
    public int rows() {
        return this.size;
    }

    @Override
    public int getExtraParamForType() {
        return this.scale_;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            out.putLong(this.values[indexStart + i]);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement * 8;
    }
}

