/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicDouble;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;

public class BasicDoubleVector
extends AbstractVector {
    private double[] values;
    private int size;
    private int capaticy;

    public BasicDoubleVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicDoubleVector(List<Double> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new double[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i) != null ? list.get(i) : -1.7976931348623157E308;
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicDoubleVector(double[] array) {
        this(array, true);
    }

    public BasicDoubleVector(double[] array, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = copy ? (double[])array.clone() : array;
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicDoubleVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new double[size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicDoubleVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new double[size];
        int totalBytes = size * 8;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        for (int off = 0; off < totalBytes; off += len) {
            len = Math.min(4096, totalBytes - off);
            in.readFully(buf, 0, len);
            int start = off / 8;
            int end = len / 8;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getDouble(i * 8);
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        int totalBytes = count * 8;
        int off = 0;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        while (off < totalBytes) {
            int len = Math.min(4096, totalBytes - off);
            in.readFully(buf, 0, len);
            int end = len / 8;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getDouble(i * 8);
            }
            off += len;
            start += end;
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeDouble(this.values[start + i]);
        }
    }

    @Override
    public Entity get(int index) {
        return new BasicDouble(this.values[index]);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        double[] sub = new double[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicDoubleVector(sub, false);
    }

    public double getDouble(int index) {
        return this.values[index];
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        this.values[index] = ((Scalar)value).isNull() ? -1.7976931348623157E308 : ((Scalar)value).getNumber().doubleValue();
    }

    public void setDouble(int index, double value) {
        this.values[index] = value;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicDoubleVector v = (BasicDoubleVector)vector;
        int newSize = this.rows() + v.rows();
        double[] newValue = new double[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicDoubleVector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == -1.7976931348623157E308;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = -1.7976931348623157E308;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.FLOATING;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DOUBLE;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDouble.class;
    }

    @Override
    public int rows() {
        return this.size;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        double[] data = new double[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        out.writeDoubleArray(data);
    }

    @Override
    public int getUnitLength() {
        return 8;
    }

    public void add(double value) {
        if (this.size + 1 > this.capaticy && this.values.length > 0) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        } else if (this.values.length <= 0) {
            this.values = Arrays.copyOf(this.values, this.values.length + 1);
        }
        this.capaticy = this.values.length;
        this.values[this.size] = value;
        ++this.size;
    }

    public void addRange(double[] valueList) {
        this.values = Arrays.copyOf(this.values, valueList.length + this.values.length);
        System.arraycopy(valueList, 0, this.values, this.size, valueList.length);
        this.size += valueList.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().doubleValue());
    }

    @Override
    public void Append(Vector value) {
        this.addRange(((BasicDoubleVector)value).getdataArray());
    }

    public double[] getdataArray() {
        double[] data = new double[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        return data;
    }

    @Override
    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        double[] data = new double[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        for (double val : data) {
            buffer.putDouble(val);
        }
        return buffer;
    }

    @Override
    public int asof(Scalar value) {
        double target;
        try {
            target = value.getNumber().doubleValue();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        int start = 0;
        int end = this.size - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.values[mid] <= target) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return end;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            out.putDouble(this.values[indexStart + i]);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement * 8;
    }
}

