/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicDuration;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class BasicDurationVector
extends AbstractVector {
    private int[] values;
    private int size;
    private int capaticy;

    public BasicDurationVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    protected BasicDurationVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new int[2 * size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicDurationVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols * 2;
        this.values = new int[size];
        int totalBytes = size * 4;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        for (int off = 0; off < totalBytes; off += len) {
            len = Math.min(4096, totalBytes - off);
            in.readFully(buf, 0, len);
            int start = off / 4;
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getInt(i * 4);
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public Entity get(int index) {
        int unitIndex = this.values[2 * index + 1];
        if (unitIndex == Integer.MIN_VALUE) {
            return new BasicDuration(Entity.DURATION.NS, Integer.MIN_VALUE);
        }
        return new BasicDuration(Entity.DURATION.values()[this.values[2 * index + 1]], this.values[2 * index]);
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        BasicDuration duration = (BasicDuration)value;
        this.values[2 * index] = duration.getDuration();
        this.values[2 * index + 1] = duration.getUnit().ordinal();
    }

    @Override
    public int hashBucket(int index, int buckets) {
        return 0;
    }

    @Override
    public int getUnitLength() {
        return 4;
    }

    public void add(int value, int duration) {
        if (this.size + 1 > this.capaticy && this.values.length > 0) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        } else if (this.values.length <= 0) {
            this.values = Arrays.copyOf(this.values, this.values.length + 1);
        }
        this.capaticy = this.values.length;
        this.values[this.size] = value;
        this.values[this.size + 1] = duration;
        this.size += 2;
    }

    public void addRange(int[] valueList) {
        this.values = Arrays.copyOf(this.values, valueList.length + this.values.length);
        System.arraycopy(valueList, 0, this.values, this.size, valueList.length);
        this.size += valueList.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(((BasicDuration)value).getDuration(), ((BasicDuration)value).getUnit().ordinal());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicDurationVector)value).getdataArray());
    }

    public int[] getdataArray() {
        int[] data = new int[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        return data;
    }

    @Override
    public Vector combine(Vector vector) {
        throw new RuntimeException("BasicDurationVector.combine not implemented yet.");
    }

    @Override
    public boolean isNull(int index) {
        return this.values[2 * index + 1] == Integer.MIN_VALUE || this.values[2 * index] == Integer.MIN_VALUE;
    }

    @Override
    public void setNull(int index) {
        this.values[2 * index] = 0;
        this.values[2 * index + 1] = Integer.MIN_VALUE;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.SYSTEM;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DURATION;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDuration.class;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeInt(this.values[start + i]);
        }
    }

    @Override
    public int rows() {
        return this.size / 2;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        int[] data = new int[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        out.writeIntArray(data);
    }

    @Override
    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        int[] data = new int[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        for (int val : data) {
            buffer.putInt(val);
        }
        return buffer;
    }

    @Override
    public int asof(Scalar value) {
        throw new RuntimeException("BasicDurationVector.asof not implemented yet.");
    }

    @Override
    public Vector getSubVector(int[] indices) {
        throw new RuntimeException("BasicDurationVector.getSubVector not implemented yet.");
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            out.putInt(this.values[indexStart + i]);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement * 4;
    }
}

