/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicShort;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;

public class BasicShortVector
extends AbstractVector {
    private short[] values;
    private int size;
    private int capaticy;

    public BasicShortVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicShortVector(List<Short> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new short[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i) != null ? list.get(i) : (short)Short.MIN_VALUE;
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicShortVector(short[] array) {
        this(array, true);
    }

    public BasicShortVector(short[] array, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = copy ? (short[])array.clone() : array;
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicShortVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new short[size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicShortVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new short[size];
        int totalBytes = size * 2;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        for (int off = 0; off < totalBytes; off += len) {
            len = Math.min(4096, totalBytes - off);
            in.readFully(buf, 0, len);
            int start = off / 2;
            int end = len / 2;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getShort(i * 2);
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        int totalBytes = count * 2;
        int off = 0;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        while (off < totalBytes) {
            int len = Math.min(4096, totalBytes - off);
            in.readFully(buf, 0, len);
            int end = len / 2;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getShort(i * 2);
            }
            off += len;
            start += end;
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeShort(this.values[start + i]);
        }
    }

    public short getShort(int index) {
        return this.values[index];
    }

    @Override
    public Entity get(int index) {
        return new BasicShort(this.values[index]);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        short[] sub = new short[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicShortVector(sub, false);
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        this.values[index] = ((Scalar)value).isNull() ? Short.MIN_VALUE : ((Scalar)value).getNumber().shortValue();
    }

    public void setShort(int index, short value) {
        this.values[index] = value;
    }

    @Override
    public int hashBucket(int index, int buckets) {
        short value = this.values[index];
        if (value >= 0) {
            return value % buckets;
        }
        if (value == Short.MIN_VALUE) {
            return -1;
        }
        return (int)((0x100000000L + (long)value) % (long)buckets);
    }

    @Override
    public int getUnitLength() {
        return 2;
    }

    public void add(short value) {
        if (this.size + 1 > this.capaticy && this.values.length > 0) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        } else if (this.values.length <= 0) {
            this.values = Arrays.copyOf(this.values, this.values.length + 1);
        }
        this.capaticy = this.values.length;
        this.values[this.size] = value;
        ++this.size;
    }

    public void addRange(short[] valueList) {
        this.values = Arrays.copyOf(this.values, valueList.length + this.values.length);
        System.arraycopy(valueList, 0, this.values, this.size, valueList.length);
        this.size += valueList.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().shortValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicShortVector)value).getdataArray());
    }

    public short[] getdataArray() {
        short[] data = new short[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        return data;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicShortVector v = (BasicShortVector)vector;
        int newSize = this.rows() + v.rows();
        short[] newValue = new short[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicShortVector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == Short.MIN_VALUE;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = Short.MIN_VALUE;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_SHORT;
    }

    @Override
    public int rows() {
        return this.size;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicShort.class;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        short[] data = new short[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        out.writeShortArray(data);
    }

    @Override
    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        short[] data = new short[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        for (short val : data) {
            buffer.putShort(val);
        }
        return buffer;
    }

    @Override
    public int asof(Scalar value) {
        short target;
        try {
            target = value.getNumber().shortValue();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        int start = 0;
        int end = this.size - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.values[mid] <= target) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return end;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            out.putShort(this.values[indexStart + i]);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement * 2;
    }
}

