/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicDecimal32;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicLong;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class BasicDecimal32Vector
extends AbstractVector {
    private int scale_ = -1;
    private int[] values;
    private int size;
    private int capaticy;

    public BasicDecimal32Vector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicDecimal32Vector(int size, int scale) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.scale_ = scale;
        this.values = new int[size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    BasicDecimal32Vector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new int[size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    BasicDecimal32Vector(int[] dataValue, int scale) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.scale_ = scale;
        this.values = dataValue;
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicDecimal32Vector(Entity.DATA_FORM df, ExtendedDataInput in, int extra) throws IOException {
        super(df);
        int len;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new int[size];
        this.scale_ = extra != -1 ? extra : in.readInt();
        long totalBytes = (long)size * 4L;
        boolean little = in.isLittleEndian();
        ByteOrder bo = little ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        for (long off = 0L; off < totalBytes; off += (long)len) {
            len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(buf, 0, len);
            int start = (int)(off / 4L);
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                int value;
                this.values[i + start] = value = byteBuffer.getInt(i * 4);
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicDecimal32Vector(double[] data, int scale) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (scale < 0 || scale > 18) {
            throw new RuntimeException("Scale out of bound (valid range: [0, 9], but get: " + scale + ")");
        }
        this.scale_ = scale;
        int[] newIntValue = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            BigDecimal pow = new BigDecimal(1);
            for (long j = 0L; j < (long)this.scale_; ++j) {
                pow = pow.multiply(new BigDecimal(10));
            }
            BigDecimal dbvalue = new BigDecimal(Double.toString(data[i]));
            newIntValue[i] = dbvalue.multiply(pow).intValue();
        }
        this.values = newIntValue;
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        long totalBytes = (long)count * 4L;
        long off = 0L;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        while (off < totalBytes) {
            int len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(buf, 0, len);
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getInt(i * 4);
            }
            off += (long)len;
            start += end;
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        int[] data = new int[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        out.writeInt(this.scale_);
        out.writeIntArray(data);
    }

    @Override
    public Vector combine(Vector vector) {
        return null;
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        int[] sub = new int[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicDecimal32Vector(sub, this.scale_);
    }

    @Override
    public int asof(Scalar value) {
        return 0;
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == Integer.MIN_VALUE;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = Integer.MIN_VALUE;
    }

    @Override
    public Entity get(int index) {
        return new BasicDecimal32(new int[]{this.scale_, this.values[index]});
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        int newScale = ((Scalar)value).getScale();
        Entity.DATA_TYPE type = value.getDataType();
        if (this.scale_ < 0) {
            this.scale_ = newScale;
        }
        if (((Scalar)value).isNull()) {
            this.values[index] = Integer.MIN_VALUE;
        } else if (this.scale_ != newScale) {
            BigInteger newValue = type == Entity.DATA_TYPE.DT_LONG ? BigInteger.valueOf(((BasicLong)value).getLong()) : (type == Entity.DATA_TYPE.DT_INT ? BigInteger.valueOf(((BasicInt)value).getInt()) : BigInteger.valueOf(((BasicDecimal32)value).getInt()));
            BigInteger pow = BigInteger.valueOf(10L);
            if (newScale - this.scale_ > 0) {
                pow = pow.pow(newScale - this.scale_);
                newValue = newValue.divide(pow);
            } else {
                pow = pow.pow(this.scale_ - newScale);
                newValue = newValue.multiply(pow);
            }
            this.values[index] = newValue.intValue();
        } else {
            this.values[index] = ((BasicDecimal32)value).getInt();
        }
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDecimal32.class;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeInt(this.values[start + i]);
        }
    }

    @Override
    public int getUnitLength() {
        return 4;
    }

    public void add(double value) {
        if (this.scale_ < 0) {
            throw new RuntimeException("Please set scale first.");
        }
        if (this.size + 1 > this.capaticy && this.values.length > 0) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        } else if (this.values.length <= 0) {
            this.values = Arrays.copyOf(this.values, this.values.length + 1);
        }
        this.capaticy = this.values.length;
        if (value == 0.0) {
            this.values[this.size] = 0;
        } else {
            BigDecimal pow = new BigDecimal(1);
            for (long i = 0L; i < (long)this.scale_; ++i) {
                pow = pow.multiply(new BigDecimal(10));
            }
            BigDecimal dbvalue = new BigDecimal(Double.toString(value));
            this.values[this.size] = dbvalue.multiply(pow).intValue();
        }
        ++this.size;
    }

    void addRange(int[] valueList) {
        this.values = Arrays.copyOf(this.values, valueList.length + this.values.length);
        System.arraycopy(valueList, 0, this.values, this.size, valueList.length);
        this.size += valueList.length;
        this.capaticy = this.values.length;
    }

    public void addRange(double[] valueList) {
        if (this.scale_ < 0) {
            throw new RuntimeException("Please set scale first.");
        }
        int[] newIntValue = new int[valueList.length];
        for (int i = 0; i < valueList.length; ++i) {
            BigDecimal pow = new BigDecimal(1);
            for (long j = 0L; j < (long)this.scale_; ++j) {
                pow = pow.multiply(new BigDecimal(10));
            }
            BigDecimal dbvalue = new BigDecimal(Double.toString(valueList[i]));
            newIntValue[i] = dbvalue.multiply(pow).intValue();
        }
        this.values = Arrays.copyOf(this.values, newIntValue.length + this.values.length);
        System.arraycopy(newIntValue, 0, this.values, this.size, newIntValue.length);
        this.size += newIntValue.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void Append(Scalar value) throws Exception {
        if (this.scale_ < 0) {
            throw new RuntimeException("Please set scale first.");
        }
        this.add(value.getNumber().doubleValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        if (this.scale_ < 0) {
            throw new RuntimeException("Please set scale first.");
        }
        if (((BasicDecimal32Vector)value).getScale() == this.scale_) {
            this.addRange(((BasicDecimal32Vector)value).getdataArray());
        } else {
            for (int i = 0; i < value.rows(); ++i) {
                this.Append((Scalar)value.get(i));
            }
        }
    }

    public void setScale(int scale) {
        this.scale_ = scale;
    }

    public int getScale() {
        return this.scale_;
    }

    public int[] getdataArray() {
        int[] data = new int[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        return data;
    }

    @Override
    public void setExtraParamForType(int scale) {
        this.scale_ = scale;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.DENARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DECIMAL32;
    }

    @Override
    public int rows() {
        return this.size;
    }

    @Override
    public int getExtraParamForType() {
        return this.scale_;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            out.putInt(this.values[indexStart + i]);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement * 4;
    }
}

