/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractEntity;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Set;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;

public class BasicSet
extends AbstractEntity
implements Set {
    private java.util.Set<Entity> set;
    private Entity.DATA_TYPE keyType;

    public BasicSet(Entity.DATA_TYPE keyType, ExtendedDataInput in) throws IOException {
        boolean extended;
        this.keyType = keyType;
        short flag = in.readShort();
        int form = flag >> 8;
        int type = flag & 0xFF;
        boolean bl = extended = type >= 128;
        if (type >= 128) {
            type -= 128;
        }
        if (form != Entity.DATA_FORM.DF_VECTOR.ordinal()) {
            throw new IOException("The form of set keys must be vector");
        }
        if (type < 0 || type >= Entity.DATA_TYPE.DT_OBJECT.getValue()) {
            throw new IOException("Invalid key type: " + type);
        }
        Vector keys = (Vector)BasicEntityFactory.instance().createEntity(Entity.DATA_FORM.DF_VECTOR, Entity.DATA_TYPE.valueOf(type), in, extended);
        int size = keys.rows();
        int capacity = (int)((double)size / 0.75);
        this.set = new HashSet<Entity>(capacity);
        for (int i = 0; i < size; ++i) {
            this.set.add(keys.get(i));
        }
    }

    public BasicSet(Entity.DATA_TYPE keyType, int capacity) {
        if (keyType == Entity.DATA_TYPE.DT_VOID || keyType == Entity.DATA_TYPE.DT_SYMBOL || keyType.getValue() >= Entity.DATA_TYPE.DT_FUNCTIONDEF.getValue()) {
            throw new IllegalArgumentException("Invalid keyType: " + keyType.name());
        }
        this.keyType = keyType;
        this.set = new HashSet<Entity>();
    }

    public BasicSet(Entity.DATA_TYPE keyType) {
        this(keyType, 0);
    }

    @Override
    public Entity.DATA_FORM getDataForm() {
        return Entity.DATA_FORM.DF_SET;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return this.getDataCategory(this.keyType);
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return this.keyType;
    }

    @Override
    public int rows() {
        return this.set.size();
    }

    @Override
    public int columns() {
        return 1;
    }

    public Vector keys() {
        return this.keys(this.set.size());
    }

    private Vector keys(int top) {
        int size = Math.min(top, this.set.size());
        Vector keys = BasicEntityFactory.instance().createVectorWithDefaultValue(this.keyType, size);
        Iterator<Entity> it = this.set.iterator();
        int count = 0;
        try {
            while (count < size) {
                keys.set(count++, it.next());
            }
        }
        catch (Exception ex) {
            return null;
        }
        return keys;
    }

    @Override
    public boolean contains(Scalar key) {
        return this.set.contains(key);
    }

    @Override
    public boolean add(Scalar key) {
        if (key.getDataType() != this.keyType) {
            return false;
        }
        return this.set.add(key);
    }

    @Override
    public String getString() {
        return this.keys(10).getString();
    }

    @Override
    public void write(ExtendedDataOutput out) throws IOException {
        Vector keys = this.keys();
        int flag = (Entity.DATA_FORM.DF_SET.ordinal() << 8) + this.getDataType().getValue();
        out.writeShort(flag);
        keys.write(out);
    }
}

