/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicDecimal128Vector;
import com.xxdb.data.BasicDecimal32Vector;
import com.xxdb.data.BasicDecimal64Vector;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BasicArrayVector
extends AbstractVector {
    private Entity.DATA_TYPE type;
    private int[] rowIndices;
    private Vector valueVec;
    private int baseUnitLength_;
    private int rowIndicesSize;
    private int capacity;
    private int scale_ = -1;

    public BasicArrayVector(Entity.DATA_TYPE type, int size) {
        this(type, size, -1);
    }

    public BasicArrayVector(Entity.DATA_TYPE type, int size, int extra) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.rowIndices = new int[size];
        if (type.getValue() == 81 || type.getValue() == 82) {
            throw new RuntimeException("ArrayVector do not support String and Symbol");
        }
        this.type = Entity.DATA_TYPE.valueOf(type.getValue());
        this.valueVec = BasicEntityFactory.instance().createVectorWithDefaultValue(Entity.DATA_TYPE.valueOf(type.getValue() - 64), 0, extra);
        if (extra >= 0) {
            ((AbstractVector)this.valueVec).setExtraParamForType(extra);
            this.scale_ = extra;
        }
        this.baseUnitLength_ = this.valueVec.getUnitLength();
        this.rowIndicesSize = 0;
        this.capacity = this.rowIndices.length;
    }

    public BasicArrayVector(List<Vector> value) throws Exception {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (value.get(0).getDataType().getValue() + 64 == 81 || value.get(0).getDataType().getValue() + 64 == 82) {
            throw new RuntimeException("ArrayVector do not support String and Symbol");
        }
        this.type = Entity.DATA_TYPE.valueOf(value.get(0).getDataType().getValue() + 64);
        Entity.DATA_TYPE valueType = Entity.DATA_TYPE.valueOf(value.get(0).getDataType().getValue());
        if (valueType == Entity.DATA_TYPE.DT_DECIMAL32 || valueType == Entity.DATA_TYPE.DT_DECIMAL64 || valueType == Entity.DATA_TYPE.DT_DECIMAL128) {
            int scale = ((AbstractVector)value.get(0)).getExtraParamForType();
            for (int i = 0; i < value.size(); ++i) {
                int scaleCopy = ((AbstractVector)value.get(i)).getExtraParamForType();
                if (scaleCopy == scale) continue;
                throw new RuntimeException("The scale of decimal arrayVector's value is not same.");
            }
            this.scale_ = scale;
        }
        int len = 0;
        for (Vector one : value) {
            if (one.rows() > 0) {
                len += one.rows();
                continue;
            }
            ++len;
        }
        int indexPos = 0;
        int indexCount = value.size();
        this.rowIndices = new int[indexCount];
        this.valueVec = BasicEntityFactory.instance().createVectorWithDefaultValue(valueType, len, this.scale_);
        if (valueType == Entity.DATA_TYPE.DT_DECIMAL32) {
            ((BasicDecimal32Vector)this.valueVec).setScale(this.scale_);
        } else if (valueType == Entity.DATA_TYPE.DT_DECIMAL64) {
            ((BasicDecimal64Vector)this.valueVec).setScale(this.scale_);
        } else if (valueType == Entity.DATA_TYPE.DT_DECIMAL128) {
            ((BasicDecimal128Vector)this.valueVec).setScale(this.scale_);
        }
        int index = 0;
        int curRows = 0;
        for (int valuePos = 0; valuePos < indexCount; ++valuePos) {
            Vector temp = value.get(valuePos);
            int size = temp.rows();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    try {
                        this.valueVec.set(index, temp.get(i));
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to insert data, invalid data for " + temp.get(i) + " error " + e.toString());
                    }
                }
                curRows += size;
            } else {
                this.valueVec.setNull(index);
                ++index;
            }
            this.rowIndices[indexPos++] = ++curRows;
        }
        this.rowIndicesSize = this.rowIndices.length;
        this.capacity = this.rowIndices.length;
        this.baseUnitLength_ = this.valueVec.getUnitLength();
    }

    public BasicArrayVector(int[] index, Vector value) {
        super(Entity.DATA_FORM.DF_VECTOR);
        Entity.DATA_TYPE dataType = value.getDataType();
        this.type = Entity.DATA_TYPE.valueOf(dataType.getValue() + 64);
        this.valueVec = value;
        int indexCount = index.length;
        this.rowIndices = new int[indexCount];
        System.arraycopy(index, 0, this.rowIndices, 0, indexCount);
        this.baseUnitLength_ = value.getUnitLength();
        this.rowIndicesSize = this.rowIndices.length;
        this.capacity = this.rowIndices.length;
    }

    public BasicArrayVector(Entity.DATA_TYPE type, ExtendedDataInput in) throws IOException {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.type = type;
        int rows = in.readInt();
        int cols = in.readInt();
        this.rowIndices = new int[rows];
        Entity.DATA_TYPE valueType = Entity.DATA_TYPE.valueOf(type.getValue() - 64);
        if (valueType == Entity.DATA_TYPE.DT_DECIMAL32 || valueType == Entity.DATA_TYPE.DT_DECIMAL64 || valueType == Entity.DATA_TYPE.DT_DECIMAL128) {
            this.scale_ = in.readInt();
        }
        this.valueVec = BasicEntityFactory.instance().createVectorWithDefaultValue(valueType, cols, this.scale_);
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        this.baseUnitLength_ = this.valueVec.getUnitLength();
        byte[] buf = new byte[4096];
        int rowsReadInBlock = 0;
        int prevIndex = 0;
        int totalBytes = 0;
        for (int rowsRead = 0; rowsRead < rows; rowsRead += rowsReadInBlock) {
            int len;
            int blockRows = in.readUnsignedShort();
            int countBytes = in.readUnsignedByte();
            in.skipBytes(1);
            totalBytes = blockRows * countBytes;
            rowsReadInBlock = 0;
            for (int offset = 0; offset < totalBytes; offset += len) {
                int curRowCells;
                int i;
                len = Math.min(4096, totalBytes - offset);
                in.readFully(buf, 0, len);
                int curRows = len / countBytes;
                if (countBytes == 1) {
                    for (int i2 = 0; i2 < curRows; ++i2) {
                        int curRowCells2 = Byte.toUnsignedInt(buf[i2]);
                        this.rowIndices[rowsRead + rowsReadInBlock + i2] = prevIndex + curRowCells2;
                        prevIndex += curRowCells2;
                    }
                } else if (countBytes == 2) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
                    for (i = 0; i < curRows; ++i) {
                        curRowCells = Short.toUnsignedInt(byteBuffer.getShort(i * 2));
                        this.rowIndices[rowsRead + rowsReadInBlock + i] = prevIndex + curRowCells;
                        prevIndex += curRowCells;
                    }
                } else {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
                    for (i = 0; i < curRows; ++i) {
                        curRowCells = byteBuffer.getInt(i * 4);
                        this.rowIndices[rowsRead + rowsReadInBlock + i] = prevIndex + curRowCells;
                        prevIndex += curRowCells;
                    }
                }
                rowsReadInBlock += curRows;
            }
            int rowStart = rowsRead == 0 ? 0 : this.rowIndices[rowsRead - 1];
            int valueCount = this.rowIndices[rowsRead + rowsReadInBlock - 1] - rowStart;
            this.valueVec.deserialize(rowStart, valueCount, in);
        }
        this.rowIndicesSize = this.rowIndices.length;
        this.capacity = this.rowIndices.length;
    }

    @Override
    public String getString(int index) {
        StringBuilder sb = new StringBuilder("[");
        int startPosValueVec = index == 0 ? 0 : this.rowIndices[index - 1];
        int rows = this.rowIndices[index] - startPosValueVec;
        if (rows > 0) {
            sb.append(this.valueVec.getString(startPosValueVec));
        }
        for (int i = 1; i < rows; ++i) {
            sb.append(',');
            sb.append(this.valueVec.getString(startPosValueVec + i));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Vector combine(Vector vector) {
        return null;
    }

    @Override
    public Vector getSubVector(int[] indices) {
        if (indices.length == 0) {
            return null;
        }
        ArrayList<Vector> value = new ArrayList<Vector>();
        for (int i = 0; i < indices.length; ++i) {
            int start = indices[i] == 0 ? 0 : this.rowIndices[indices[i] - 1];
            int end = this.rowIndices[indices[i]];
            int[] indexs = new int[end - start];
            for (int j = 0; j < indexs.length; ++j) {
                indexs[j] = start + j;
            }
            Vector subValue = this.valueVec.getSubVector(indexs);
            value.add(subValue);
        }
        try {
            return new BasicArrayVector(value);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int asof(Scalar value) {
        return 0;
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    public void setNull(int index) {
    }

    @Override
    public Entity get(int index) {
        int startPosValueVec = index == 0 ? 0 : this.rowIndices[index - 1];
        int rows = this.rowIndices[index] - startPosValueVec;
        Entity.DATA_TYPE valueType = Entity.DATA_TYPE.valueOf(this.type.getValue() - 64);
        Vector value = BasicEntityFactory.instance().createVectorWithDefaultValue(valueType, rows, this.scale_);
        if (valueType == Entity.DATA_TYPE.DT_DECIMAL32) {
            ((BasicDecimal32Vector)value).setScale(this.scale_);
        } else if (valueType == Entity.DATA_TYPE.DT_DECIMAL64) {
            ((BasicDecimal64Vector)value).setScale(this.scale_);
        } else if (valueType == Entity.DATA_TYPE.DT_DECIMAL128) {
            ((BasicDecimal128Vector)value).setScale(this.scale_);
        }
        if (rows > 0) {
            try {
                value.set(0, this.valueVec.get(startPosValueVec));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to insert data, invalid data for " + this.valueVec.get(startPosValueVec) + " error " + e.toString());
            }
        }
        for (int i = 1; i < rows; ++i) {
            try {
                value.set(i, this.valueVec.get(startPosValueVec + i));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to insert data, invalid data for " + this.valueVec.get(startPosValueVec) + " error " + e.toString());
            }
        }
        return value;
    }

    public Vector getVectorValue(int index) {
        return (Vector)this.get(index);
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        throw new RuntimeException("BasicArrayVector.set not supported.");
    }

    @Override
    public Class<?> getElementClass() {
        return Entity.class;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        throw new RuntimeException("BasicAnyVector.serialize not supported.");
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.ARRAY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return this.type;
    }

    @Override
    public int rows() {
        return this.rowIndicesSize;
    }

    @Override
    @JsonIgnore
    public int getUnitLength() {
        throw new RuntimeException("BasicArrayVector.getUnitLength() not supported.");
    }

    public void addRange(Object[] valueList) {
        throw new RuntimeException("ArrayVector not support addRange");
    }

    @Override
    public void Append(Scalar value) throws Exception {
        throw new RuntimeException("ArrayVector not support append scalar value");
    }

    @Override
    public void Append(Vector value) throws Exception {
        if (value.isVector()) {
            int prev;
            int indexCount = this.rowIndicesSize;
            int n = prev = indexCount == 0 ? 0 : this.rowIndices[indexCount - 1];
            if (this.rowIndicesSize + 1 > this.capacity) {
                this.rowIndices = Arrays.copyOf(this.rowIndices, this.rowIndices.length * 2);
                this.capacity = this.rowIndices.length;
            }
            if (value.rows() != 0) {
                this.rowIndices[this.rowIndicesSize] = prev + value.rows();
                this.valueVec.Append(value);
            } else {
                this.rowIndices[this.rowIndicesSize] = prev + 1;
                Scalar scalar = BasicEntityFactory.instance().createScalarWithDefaultValue(value.getDataType());
                scalar.setNull();
                this.valueVec.Append(scalar);
            }
            ++this.rowIndicesSize;
        } else {
            throw new RuntimeException("Append to arrayctor must be a vector. ");
        }
    }

    @Override
    public String getJsonString(int rowIndex) {
        StringBuilder sb = new StringBuilder("[");
        Vector value = (Vector)this.get(rowIndex);
        for (int j = 0; j < value.rows(); ++j) {
            sb.append(((Scalar)value.get(j)).getJsonString());
            if (j == value.rows() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        int i;
        int prestart;
        numElementAndPartial.numElement = 0;
        numElementAndPartial.partial = 0;
        int byteSent = 0;
        AbstractVector.NumElementAndPartial tempNumElementAndPartial = new AbstractVector.NumElementAndPartial(0, 0);
        if (offect > 0) {
            int rowStart = indexStart > 0 ? this.rowIndices[indexStart - 1] : 0;
            int cellCount = this.rowIndices[indexStart] - rowStart;
            int cellCountToSerialize = Math.min(out.remaining() / this.baseUnitLength_, cellCount - offect);
            byteSent += this.valueVec.serialize(rowStart + offect, cellCount, numElementAndPartial.numElement, tempNumElementAndPartial, out);
            if (cellCountToSerialize < cellCount - offect) {
                numElementAndPartial.partial = offect + cellCountToSerialize;
                return byteSent;
            }
            --targetNumElement;
            ++numElementAndPartial.numElement;
            ++indexStart;
        }
        int remainingBytes = out.remaining() - 4;
        int curCountBytes = 1;
        int maxCount = 255;
        int n = prestart = indexStart == 0 ? 0 : this.rowIndices[indexStart - 1];
        if (targetNumElement > 65535) {
            targetNumElement = 65535;
        }
        for (i = 0; i < targetNumElement && remainingBytes > 0; ++i) {
            int curStart = this.rowIndices[indexStart + i];
            int curCount = curStart - prestart;
            int oldCountBytes = curCountBytes;
            prestart = curStart;
            int byteRequired = 0;
            while (curCount > maxCount) {
                byteRequired += i * curCountBytes;
                maxCount = Math.min(Integer.MAX_VALUE, (111 << 8 * (curCountBytes *= 2)) - 1);
            }
            if ((byteRequired += curCountBytes + curCount * this.baseUnitLength_) > remainingBytes) {
                if (numElementAndPartial.numElement == 0) {
                    numElementAndPartial.partial = (remainingBytes - curCountBytes) / this.baseUnitLength_;
                    if (numElementAndPartial.partial <= 0) {
                        numElementAndPartial.partial = 0;
                        break;
                    }
                    ++i;
                    remainingBytes -= curCountBytes + numElementAndPartial.partial * this.baseUnitLength_;
                    break;
                }
                if (oldCountBytes == curCountBytes) break;
                curCountBytes = oldCountBytes;
                break;
            }
            remainingBytes -= byteRequired;
            ++numElementAndPartial.numElement;
        }
        if (i == 0) {
            return byteSent;
        }
        int rows = i;
        out.putShort((short)rows);
        out.put((byte)curCountBytes);
        out.put((byte)0);
        byteSent += 4;
        prestart = indexStart == 0 ? 0 : this.rowIndices[indexStart - 1];
        for (int k = 0; k < rows; ++k) {
            int curStart = this.rowIndices[indexStart + k];
            int index = curStart - prestart;
            prestart = curStart;
            if (curCountBytes == 1) {
                out.put((byte)index);
                continue;
            }
            if (curCountBytes == 2) {
                out.putShort((short)index);
                continue;
            }
            out.putInt(index);
        }
        prestart = indexStart == 0 ? 0 : this.rowIndices[indexStart - 1];
        int count = (indexStart + numElementAndPartial.numElement == 0 ? 0 : this.rowIndices[indexStart + numElementAndPartial.numElement - 1]) + numElementAndPartial.partial - prestart;
        int bytes = this.valueVec.serialize(prestart, 0, count, tempNumElementAndPartial, out);
        return (byteSent += curCountBytes * i) + bytes;
    }

    public void add(Object value) {
        throw new RuntimeException("ArrayVector not support add");
    }

    @Override
    public int getExtraParamForType() {
        return this.scale_;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        int indexCount = this.rowIndicesSize;
        int maxCount = 255;
        int countBytes = 1;
        int indicesPos = 0;
        int valuesOffect = 0;
        while (indicesPos < indexCount) {
            int index;
            int indiceCount;
            int byteRequest = 4;
            int curRows = 0;
            for (indiceCount = 1; byteRequest < 4096 && indicesPos + indiceCount - 1 < indexCount && indiceCount < 65536; ++indiceCount, byteRequest += countBytes + this.baseUnitLength_ * index) {
                int curIndiceOffect = indicesPos + indiceCount - 1;
                int n = index = curIndiceOffect == 0 ? this.rowIndices[curIndiceOffect] : this.rowIndices[curIndiceOffect] - this.rowIndices[curIndiceOffect - 1];
                while (index > maxCount) {
                    byteRequest += (indiceCount - 1) * countBytes;
                    maxCount = Math.min(Integer.MAX_VALUE, (111 << 8 * (countBytes *= 2)) - 1);
                }
                curRows += index;
            }
            out.writeShort(--indiceCount);
            out.writeByte(countBytes);
            out.writeByte(0);
            for (int i = 0; i < indiceCount; ++i) {
                int n = index = indicesPos + i == 0 ? this.rowIndices[indicesPos + i] : this.rowIndices[indicesPos + i] - this.rowIndices[indicesPos + i - 1];
                if (countBytes == 1) {
                    out.writeByte(index);
                    continue;
                }
                if (countBytes == 2) {
                    out.writeShort(index);
                    continue;
                }
                out.writeInt(index);
            }
            this.valueVec.serialize(valuesOffect, curRows, out);
            indicesPos += indiceCount;
            valuesOffect += curRows;
        }
    }

    @Override
    public int columns() {
        return this.valueVec.rows();
    }
}

