/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;

public class EntityBlockReader
implements Entity {
    private Entity currentValue;
    private int size;
    private int currentIndex = 0;
    private ExtendedDataInput instream;

    public EntityBlockReader(ExtendedDataInput in) throws IOException {
        int rows = in.readInt();
        int cols = in.readInt();
        this.size = rows * cols;
        this.currentIndex = 0;
        this.instream = in;
    }

    public Entity read() throws IOException {
        boolean extended;
        if (this.currentIndex >= this.size) {
            return null;
        }
        short flag = this.instream.readShort();
        int form = flag >> 8;
        int type = flag & 0xFF;
        boolean bl = extended = type >= 128;
        if (type >= 128) {
            type -= 128;
        }
        this.currentValue = BasicEntityFactory.instance().createEntity(Entity.DATA_FORM.values()[form], Entity.DATA_TYPE.valueOf(type), this.instream, extended);
        ++this.currentIndex;
        return this.currentValue;
    }

    public void skipAll() throws IOException {
        for (int i = this.currentIndex; i < this.size; ++i) {
            boolean extended;
            short flag = this.instream.readShort();
            int form = flag >> 8;
            int type = flag & 0xFF;
            boolean bl = extended = type >= 128;
            if (type >= 128) {
                type -= 128;
            }
            this.currentValue = BasicEntityFactory.instance().createEntity(Entity.DATA_FORM.values()[form], Entity.DATA_TYPE.valueOf(type), this.instream, extended);
            ++this.currentIndex;
        }
    }

    public Boolean hasNext() {
        return this.currentIndex < this.size;
    }

    @Override
    public Entity.DATA_FORM getDataForm() {
        return Entity.DATA_FORM.DF_TABLE;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.MIXED;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_ANY;
    }

    @Override
    public int rows() {
        return 0;
    }

    @Override
    public int columns() {
        return 0;
    }

    @Override
    public String getString() {
        return null;
    }

    @Override
    public void write(ExtendedDataOutput output) throws IOException {
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isVector() {
        return false;
    }

    @Override
    public boolean isPair() {
        return false;
    }

    @Override
    public boolean isTable() {
        return true;
    }

    @Override
    public boolean isMatrix() {
        return false;
    }

    @Override
    public boolean isDictionary() {
        return false;
    }

    @Override
    public boolean isChart() {
        return false;
    }

    @Override
    public boolean isChunk() {
        return false;
    }
}

