/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.route;

import com.xxdb.DBConnection;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AutoFitTableUpsert {
    private DBConnection connection_;
    private String upsertScript_;
    private int cols_;
    private List<Entity.DATA_CATEGORY> columnCategories_ = new ArrayList<Entity.DATA_CATEGORY>();
    private List<Entity.DATA_TYPE> columnTypes_ = new ArrayList<Entity.DATA_TYPE>();
    private List<String> colNames_ = new ArrayList<String>();

    public AutoFitTableUpsert(String dbUrl, String tableName, DBConnection connection, boolean ignoreNull, String[] pkeyColNames, String[] psortColumns) throws IOException {
        String task;
        this.connection_ = connection;
        if (dbUrl.equals("")) {
            task = "schema(" + tableName + ")";
            this.upsertScript_ = "upsert!{" + tableName + "";
        } else {
            task = "schema(loadTable(\"" + dbUrl + "\", \"" + tableName + "\"))";
            this.upsertScript_ = "upsert!{loadTable('" + dbUrl + "', '" + tableName + "')";
        }
        this.upsertScript_ = this.upsertScript_ + ",";
        this.upsertScript_ = !ignoreNull ? this.upsertScript_ + ",ignoreNull=false" : this.upsertScript_ + ",ignoreNull=true";
        int ignoreParamCount = 0;
        if (pkeyColNames != null && pkeyColNames.length > 0) {
            this.upsertScript_ = this.upsertScript_ + ",keyColNames=";
            for (String one : pkeyColNames) {
                this.upsertScript_ = this.upsertScript_ + "`" + one;
            }
        } else {
            ++ignoreParamCount;
        }
        if (psortColumns != null && psortColumns.length > 0) {
            while (ignoreParamCount > 0) {
                this.upsertScript_ = this.upsertScript_ + ",";
                --ignoreParamCount;
            }
            this.upsertScript_ = this.upsertScript_ + ",sortColumns=";
            for (String one : psortColumns) {
                this.upsertScript_ = this.upsertScript_ + "`" + one;
            }
        }
        this.upsertScript_ = this.upsertScript_ + "}";
        BasicDictionary tableInfo = (BasicDictionary)this.connection_.run(task);
        BasicTable colDefs = (BasicTable)tableInfo.get(new BasicString("colDefs"));
        this.cols_ = colDefs.rows();
        BasicIntVector colTypesInt = (BasicIntVector)colDefs.getColumn("typeInt");
        BasicStringVector colNames = (BasicStringVector)colDefs.getColumn("name");
        for (int i = 0; i < this.cols_; ++i) {
            this.columnTypes_.add(Entity.DATA_TYPE.valueOf(colTypesInt.getInt(i)));
            this.columnCategories_.add(Utils.getCategory(this.columnTypes_.get(i)));
            this.colNames_.add(colNames.getString(i));
        }
    }

    public int upsert(BasicTable table) throws Exception {
        if (this.cols_ != table.columns()) {
            throw new RuntimeException("The input table columns doesn't match the columns of the target table.");
        }
        ArrayList<Vector> colums = new ArrayList<Vector>();
        for (int i = 0; i < this.cols_; ++i) {
            Vector curCol = table.getColumn(i);
            this.checkColumnType(i, curCol.getDataCategory(), curCol.getDataType());
            if (this.columnCategories_.get(i) == Entity.DATA_CATEGORY.TEMPORAL && curCol.getDataType() != this.columnTypes_.get(i)) {
                colums.add((Vector)Utils.castDateTime(curCol, this.columnTypes_.get(i)));
                continue;
            }
            colums.add(curCol);
        }
        BasicTable tableToInsert = new BasicTable(this.colNames_, colums);
        ArrayList<Entity> args = new ArrayList<Entity>();
        args.add(tableToInsert);
        Entity res = this.connection_.run(this.upsertScript_, args);
        if (res.getDataType() == Entity.DATA_TYPE.DT_INT && res.getDataForm() == Entity.DATA_FORM.DF_SCALAR) {
            return ((BasicInt)res).getInt();
        }
        return 0;
    }

    private void checkColumnType(int col, Entity.DATA_CATEGORY category, Entity.DATA_TYPE type) {
        Entity.DATA_CATEGORY expectCateGory;
        if (this.columnTypes_.get(col) != type && category != (expectCateGory = this.columnCategories_.get(col))) {
            throw new RuntimeException("column " + col + ", expect category " + (Object)((Object)expectCateGory) + ", got category " + (Object)((Object)category));
        }
    }
}

