/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.route;

import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.route.Domain;
import java.util.ArrayList;
import java.util.List;

public class ValueDomain
implements Domain {
    private Entity.DATA_TYPE type;
    private Entity.DATA_CATEGORY cat;

    public ValueDomain(Vector partitionScheme, Entity.DATA_TYPE type, Entity.DATA_CATEGORY cat) {
        this.type = partitionScheme.getDataType();
        this.cat = partitionScheme.getDataCategory();
    }

    @Override
    public List<Integer> getPartitionKeys(Vector partitionCol) {
        if (partitionCol.getDataCategory() != this.cat) {
            throw new RuntimeException("Data category incompatible.");
        }
        if (this.cat == Entity.DATA_CATEGORY.TEMPORAL && this.type != partitionCol.getDataType()) {
            Entity.DATA_TYPE old = partitionCol.getDataType();
            if ((partitionCol = (Vector)Utils.castDateTime(partitionCol, this.type)) == null) {
                throw new RuntimeException("Can't convert type from " + old.name() + " to " + this.type.name());
            }
        }
        if (this.type == Entity.DATA_TYPE.DT_LONG) {
            throw new RuntimeException("Long type value can't be used as a partition column.");
        }
        int rows = partitionCol.rows();
        ArrayList<Integer> keys = new ArrayList<Integer>(rows);
        for (int i = 0; i < rows; ++i) {
            keys.add(partitionCol.hashBucket(i, 0x100000));
        }
        return keys;
    }

    @Override
    public int getPartitionKey(Scalar partitionCol) {
        if (partitionCol.getDataCategory() != this.cat) {
            throw new RuntimeException("Data category incompatible.");
        }
        if (this.cat == Entity.DATA_CATEGORY.TEMPORAL && this.type != partitionCol.getDataType()) {
            Entity.DATA_TYPE old = partitionCol.getDataType();
            if ((partitionCol = (Scalar)Utils.castDateTime(partitionCol, this.type)) == null) {
                throw new RuntimeException("Can't convert type from " + (Object)((Object)old) + " to " + (Object)((Object)this.type));
            }
        }
        if (this.type == Entity.DATA_TYPE.DT_LONG) {
            throw new RuntimeException("Long type value can't be used as a partition column.");
        }
        int key = partitionCol.hashBucket(0x100000);
        return key;
    }
}

