/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb;

import com.xxdb.RSAUtils;
import com.xxdb.comm.SqlStdEnum;
import com.xxdb.data.BasicBoolean;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicDoubleVector;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.BasicTableSchema;
import com.xxdb.data.BasicUuid;
import com.xxdb.data.Entity;
import com.xxdb.data.EntityBlockReader;
import com.xxdb.data.EntityFactory;
import com.xxdb.data.Utils;
import com.xxdb.data.Void;
import com.xxdb.io.AbstractExtendedDataOutputStream;
import com.xxdb.io.BigEndianDataOutputStream;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.io.LittleEndianDataInputStream;
import com.xxdb.io.LittleEndianDataOutputStream;
import com.xxdb.io.ProgressListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class DBConnection {
    private static final int MAX_FORM_VALUE = Entity.DATA_FORM.values().length - 1;
    private static final int MAX_TYPE_VALUE = Entity.DATA_TYPE.DT_DECIMAL128_ARRAY.getValue();
    private static final int DEFAULT_PRIORITY = 4;
    private static final int DEFAULT_PARALLELISM = 2;
    private ReentrantLock mutex_;
    private DBConnectionImpl conn_;
    private String uid_;
    private String pwd_;
    private String initialScript_ = null;
    private boolean enableHighAvailability_;
    private List<Node> nodes_ = new ArrayList<Node>();
    private Random nodeRandom_ = new Random();
    private int connTimeout_ = 0;
    private boolean closed_ = false;
    private boolean loadBalance_ = true;
    private String runClientId_ = null;
    private long runSeqNo_ = 0L;
    private int[] serverVersion_;
    private boolean isReverseStreaming_ = false;

    private DBConnectionImpl createEnableReverseStreamingDBConnectionImpl(boolean asynTask, boolean sslEnable, boolean compress, boolean python, boolean ifUrgent, SqlStdEnum sqlStd) {
        return new DBConnectionImpl(asynTask, sslEnable, compress, python, ifUrgent, true, sqlStd);
    }

    public DBConnection() {
        this(false, false, false);
    }

    public DBConnection(SqlStdEnum sqlStd) {
        this(false, false, false, false, false, sqlStd);
    }

    public DBConnection(boolean asynchronousTask) {
        this(asynchronousTask, false, false);
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL) {
        this(asynchronousTask, useSSL, false);
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress) {
        this(asynchronousTask, useSSL, compress, false);
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress, boolean usePython) {
        this.conn_ = new DBConnectionImpl(asynchronousTask, useSSL, compress, usePython, false, false, SqlStdEnum.DolphinDB);
        this.mutex_ = new ReentrantLock();
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress, boolean usePython, SqlStdEnum sqlStd) {
        this.conn_ = new DBConnectionImpl(asynchronousTask, useSSL, compress, usePython, false, false, sqlStd);
        this.mutex_ = new ReentrantLock();
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress, boolean usePython, boolean isUrgent) {
        this.conn_ = new DBConnectionImpl(asynchronousTask, useSSL, compress, usePython, isUrgent, false, SqlStdEnum.DolphinDB);
        this.mutex_ = new ReentrantLock();
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress, boolean usePython, boolean isUrgent, SqlStdEnum sqlStd) {
        this.conn_ = new DBConnectionImpl(asynchronousTask, useSSL, compress, usePython, isUrgent, false, sqlStd);
        this.mutex_ = new ReentrantLock();
    }

    @Deprecated
    public DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress, boolean usePython, boolean isUrgent, boolean isReverseStreaming, SqlStdEnum sqlStd) {
        this.conn_ = new DBConnectionImpl(asynchronousTask, useSSL, compress, usePython, isUrgent, isReverseStreaming, sqlStd);
        this.mutex_ = new ReentrantLock();
    }

    public static DBConnection internalCreateEnableReverseStreamingDBConnection(boolean asynchronousTask, boolean useSSL, boolean compress, boolean usePython, boolean isUrgent, SqlStdEnum sqlStd) {
        return new DBConnection(asynchronousTask, useSSL, compress, usePython, isUrgent, true, sqlStd);
    }

    public boolean isBusy() {
        if (!this.mutex_.tryLock()) {
            return true;
        }
        this.mutex_.unlock();
        return false;
    }

    private int getVersionNumber(String ver) {
        try {
            String[] s = ver.split(" ");
            if (s.length >= 2) {
                String vernum = s[0].replace(".", "");
                return Integer.parseInt(vernum);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public void setLoadBalance(boolean loadBalance) {
        this.loadBalance_ = loadBalance;
    }

    public boolean connect(String hostName, int port) throws IOException {
        return this.connect(hostName, port, "", "", null, false, null);
    }

    public boolean connect(String hostName, int port, int timeout) throws IOException {
        this.connTimeout_ = timeout;
        return this.connect(hostName, port, "", "", null, false, null);
    }

    public boolean connect(String hostName, int port, int timeout, boolean reconnect) throws IOException {
        this.connTimeout_ = timeout;
        return this.connect(hostName, port, "", "", null, false, null, reconnect);
    }

    public boolean connect(String hostName, int port, String initialScript) throws IOException {
        return this.connect(hostName, port, "", "", initialScript, false, null);
    }

    public boolean connect(String hostName, int port, String initialScript, boolean enableHighAvailability) throws IOException {
        return this.connect(hostName, port, "", "", initialScript, enableHighAvailability, null);
    }

    public boolean connect(String hostName, int port, boolean enableHighAvailability) throws IOException {
        return this.connect(hostName, port, "", "", null, enableHighAvailability, null);
    }

    public boolean connect(String hostName, int port, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, "", "", null, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String initialScript, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, "", "", initialScript, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String userId, String password) throws IOException {
        return this.connect(hostName, port, userId, password, null, false, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, boolean enableHighAvailability) throws IOException {
        return this.connect(hostName, port, userId, password, null, enableHighAvailability, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, userId, password, null, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, false, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean enableHighAvailability) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, enableHighAvailability, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean enableHighAvailability, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, enableHighAvailability, highAvailabilitySites, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean enableHighAvailability, String[] highAvailabilitySites, boolean reconnect) throws IOException {
        this.mutex_.lock();
        try {
            this.uid_ = userId;
            this.pwd_ = password;
            this.initialScript_ = initialScript;
            this.enableHighAvailability_ = enableHighAvailability;
            if (enableHighAvailability) {
                this.nodes_.add(new Node(hostName, port));
                if (highAvailabilitySites != null) {
                    for (String site : highAvailabilitySites) {
                        Node node = new Node(site);
                        if (this.nodes_.contains(node)) continue;
                        this.nodes_.add(node);
                    }
                }
                Node connectedNode = new Node();
                BasicTable bt = null;
                while (!this.closed_) {
                    block12: while (!this.conn_.isConnected() && !this.closed_) {
                        for (Node one : this.nodes_) {
                            if (this.connectNode(one)) {
                                connectedNode = one;
                                continue block12;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                boolean bl = false;
                                this.mutex_.unlock();
                                return bl;
                            }
                        }
                    }
                    try {
                        bt = (BasicTable)this.conn_.run("select host,port,(memoryUsed/1024.0/1024.0/1024.0)/maxMemSize as memLoad,ratio(connectionNum,maxConnections) as connLoad,avgLoad from rpc(getControllerAlias(),getClusterPerf) where mode=0", 0L);
                        break;
                    }
                    catch (Exception e) {
                        System.out.println("ERROR getting other data nodes, exception: " + e.getMessage());
                        Node node1 = new Node();
                        if (this.isConnected()) {
                            ExceptionType type = this.parseException(e.getMessage(), node1);
                            if (type == ExceptionType.ET_IGNORE || type != ExceptionType.ET_NEWLEADER && type != ExceptionType.ET_NODENOTAVAIL) continue;
                            this.switchDataNode(node1);
                            continue;
                        }
                        this.switchDataNode(node1);
                    }
                }
                if (this.closed_) {
                    boolean e = false;
                    return e;
                }
                if (bt != null && bt.getDataForm() != Entity.DATA_FORM.DF_TABLE) {
                    throw new IOException("Run getClusterPerf() failed.");
                }
                if (bt != null && this.loadBalance_) {
                    ArrayList<Node> lowLoadNodes = new ArrayList<Node>();
                    BasicStringVector colHost = (BasicStringVector)bt.getColumn("host");
                    BasicIntVector colPort = (BasicIntVector)bt.getColumn("port");
                    BasicDoubleVector memLoad = (BasicDoubleVector)bt.getColumn("memLoad");
                    BasicDoubleVector connLoad = (BasicDoubleVector)bt.getColumn("connLoad");
                    BasicDoubleVector avgLoad = (BasicDoubleVector)bt.getColumn("avgLoad");
                    for (int i = 0; i < colHost.rows(); ++i) {
                        Node nodex = new Node(colHost.getString(i), colPort.getInt(i));
                        Node pexistNode = null;
                        if (highAvailabilitySites != null) {
                            for (Node node : this.nodes_) {
                                if (!node.hostName.equals(nodex.hostName) && !nodex.hostName.equals("localhost") || node.port != nodex.port) continue;
                                pexistNode = node;
                                break;
                            }
                            if (pexistNode == null) continue;
                        }
                        double load = (memLoad.getDouble(i) + connLoad.getDouble(i) + avgLoad.getDouble(i)) / 3.0;
                        if (pexistNode != null) {
                            pexistNode.load = load;
                        } else {
                            pexistNode = new Node(colHost.getString(i), colPort.getInt(i), load);
                            this.nodes_.add(pexistNode);
                        }
                        if (!(memLoad.getDouble(i) < 0.8) || !(connLoad.getDouble(i) < 0.9) || !(avgLoad.getDouble(i) < 0.8)) continue;
                        lowLoadNodes.add(pexistNode);
                    }
                    Node pMinNode = !lowLoadNodes.isEmpty() ? (Node)lowLoadNodes.get(this.nodeRandom_.nextInt(lowLoadNodes.size())) : this.nodes_.get(this.nodeRandom_.nextInt(this.nodes_.size()));
                    if (pMinNode != null && !pMinNode.equals(connectedNode)) {
                        System.out.println("Switch to node: " + pMinNode.hostName + ":" + pMinNode.port);
                        this.conn_.close();
                        this.switchDataNode(pMinNode);
                    }
                }
            } else if (reconnect) {
                this.nodes_.add(new Node(hostName, port));
                this.switchDataNode(new Node(hostName, port));
            } else if (!this.connectNode(new Node(hostName, port))) {
                boolean bl = false;
                return bl;
            }
            this.InitConnection();
            boolean bl = true;
            return bl;
        }
        finally {
            this.mutex_.unlock();
        }
    }

    private void InitConnection() throws IOException {
        this.runClientId_ = null;
        if (this.enableHighAvailability_ && this.getServerVersion() && this.checkClientIdValid()) {
            this.runClientId_ = BasicUuid.random().getString();
            this.runSeqNo_ = 0L;
        }
        if (this.initialScript_ != null && this.initialScript_.length() > 0) {
            this.run(this.initialScript_);
        }
    }

    public void switchDataNode(Node node) throws IOException {
        while (node.hostName == null || node.hostName.length() <= 0 || !this.connectNode(node)) {
            if (this.nodes_.isEmpty()) {
                throw new RuntimeException("Failed to connect to " + node.hostName + ":" + node.port);
            }
            int index = this.nodeRandom_.nextInt(this.nodes_.size());
            if (this.connectNode(this.nodes_.get(index))) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            if (!this.closed_) continue;
        }
        if (this.initialScript_ != null && this.initialScript_.length() > 0) {
            this.run(this.initialScript_);
        }
    }

    public boolean connectNode(Node node) throws IOException {
        System.out.println("Connect to " + node.hostName + ":" + node.port + ".");
        while (!this.closed_) {
            try {
                return this.conn_.connect(node.hostName, node.port, this.uid_, this.pwd_, this.connTimeout_);
            }
            catch (Exception e) {
                if (this.isConnected()) {
                    ExceptionType type = this.parseException(e.getMessage(), node);
                    if (type != ExceptionType.ET_NEWLEADER) {
                        if (type == ExceptionType.ET_IGNORE) {
                            return true;
                        }
                        if (type == ExceptionType.ET_NODENOTAVAIL) {
                            return false;
                        }
                        throw e;
                    }
                } else {
                    System.out.println(e.getMessage());
                    return false;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    public ExceptionType parseException(String msg, Node node) {
        if (msg == null) {
            node.hostName = "";
            node.port = 0;
            return ExceptionType.ET_UNKNOW;
        }
        int index = msg.indexOf("<NotLeader>");
        if (index != -1) {
            index = msg.indexOf(">");
            String ipport = msg.substring(index + 1);
            if (!Pattern.matches("\\d+", ipport)) {
                System.out.println("The control node you are accessing is not the leader node of the highly available (raft) cluster.");
                return ExceptionType.ET_NOTLEADER;
            }
            this.parseIpPort(ipport, node);
            System.out.println("New leader is " + node.hostName + ":" + node.port);
            return ExceptionType.ET_NEWLEADER;
        }
        index = msg.indexOf("<DataNodeNotAvail>");
        if (index != -1) {
            index = msg.indexOf(">");
            String ipport = msg.substring(index + 1);
            Node newNode = new Node();
            this.parseIpPort(ipport, newNode);
            Node lastNode = new Node();
            this.conn_.getNode(lastNode);
            node.hostName = "";
            node.port = 0;
            System.out.println(msg);
            return ExceptionType.ET_NODENOTAVAIL;
        }
        index = msg.indexOf("The datanode isn't initialized yet. Please try again later");
        if (index != -1) {
            node.hostName = "";
            node.port = 0;
            return ExceptionType.ET_NOINITIALIZED;
        }
        node.hostName = "";
        node.port = 0;
        return ExceptionType.ET_UNKNOW;
    }

    public void parseIpPort(String ipport, Node node) {
        String[] v = ipport.split(":");
        if (v.length < 2) {
            throw new RuntimeException("The ipPort '" + ipport + "' is invalid.");
        }
        node.hostName = v[0];
        node.port = Integer.parseInt(v[1]);
    }

    public boolean connected() {
        try {
            BasicInt ret = (BasicInt)this.conn_.run("1+1", 0L);
            return !ret.isNull() && ret.getInt() == 2;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void login(String userId, String password, boolean enableEncryption) throws IOException {
        this.conn_.login(userId, password, enableEncryption);
        this.uid_ = userId;
        this.pwd_ = password;
    }

    public boolean getRemoteLittleEndian() {
        return this.conn_.getRemoteLittleEndian();
    }

    public Entity tryRun(String script) throws IOException {
        return this.tryRun(script, 4, 2);
    }

    public Entity tryRun(String script, int priority, int parallelism) throws IOException {
        return this.tryRun(script, priority, parallelism, 0, false);
    }

    public Entity tryRun(String script, int priority, int parallelism, boolean clearSessionMemory) throws IOException {
        return this.tryRun(script, priority, parallelism, 0, clearSessionMemory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity tryRun(String script, int priority, int parallelism, int fetchSize, boolean clearSessionMemory) throws IOException {
        if (!this.mutex_.tryLock()) {
            return null;
        }
        try {
            Entity entity = this.run(script, null, priority, parallelism, fetchSize, clearSessionMemory);
            return entity;
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public Entity run(String script, String tableName) throws IOException {
        return this.run(script, null, 4, 2, 0, false, tableName);
    }

    public Entity run(String script) throws IOException {
        return this.run(script, (ProgressListener)null, 4, 2);
    }

    public Entity run(String script, int priority) throws IOException {
        return this.run(script, (ProgressListener)null, priority, 2);
    }

    public Entity run(String script, int priority, int parallelism) throws IOException {
        return this.run(script, (ProgressListener)null, priority, parallelism);
    }

    public Entity run(String script, ProgressListener listener) throws IOException {
        return this.run(script, listener, 4, 2);
    }

    public Entity run(String script, ProgressListener listener, boolean clearSessionMemory) throws IOException {
        return this.run(script, listener, 4, 2, 0, clearSessionMemory);
    }

    public Entity run(String script, int priority, boolean clearSessionMemory) throws IOException {
        return this.run(script, null, priority, 2, 0, clearSessionMemory);
    }

    public Entity run(String script, ProgressListener listener, int priority, int parallelism) throws IOException {
        return this.run(script, listener, priority, parallelism, 0, false);
    }

    public Entity run(String script, ProgressListener listener, int priority, int parallelism, boolean clearSessionMemory) throws IOException {
        return this.run(script, listener, priority, parallelism, 0, clearSessionMemory);
    }

    public Entity run(String script, int priority, int parallelism, boolean clearSessionMemory) throws IOException {
        return this.run(script, null, priority, parallelism, 0, clearSessionMemory);
    }

    public Entity run(String script, ProgressListener listener, int priority, int parallelism, int fetchSize) throws IOException {
        return this.run(script, listener, priority, parallelism, fetchSize, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity tryRun(String script, boolean clearSessionMemory) throws IOException {
        if (!this.mutex_.tryLock()) {
            return null;
        }
        try {
            Entity entity = this.run(script, null, 4, 2, 0, clearSessionMemory);
            return entity;
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public Entity run(String script, boolean clearSessionMemory) throws IOException {
        return this.run(script, null, 4, 2, 0, clearSessionMemory);
    }

    public Entity run(String script, ProgressListener listener, int priority, int parallelism, int fetchSize, boolean clearSessionMemory) throws IOException {
        return this.run(script, listener, priority, parallelism, fetchSize, clearSessionMemory, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Entity run(String script, ProgressListener listener, int priority, int parallelism, int fetchSize, boolean clearSessionMemory, String tableName) throws IOException {
        this.mutex_.lock();
        try {
            if (!this.nodes_.isEmpty()) {
                curSeqNo = this.newSeqNo();
                while (!this.closed_) {
                    try {
                        var10_11 = DBConnectionImpl.access$1200(this.conn_, script, listener, priority, parallelism, fetchSize, clearSessionMemory, tableName, curSeqNo);
                        return var10_11;
                    }
                    catch (IOException e) {
                        block14: {
                            block13: {
                                if (curSeqNo > 0L) {
                                    curSeqNo = -curSeqNo;
                                }
                                node = new Node();
                                if (!this.connected()) break block13;
                                type = this.parseException(e.getMessage(), node);
                                if (type == ExceptionType.ET_IGNORE) {
                                    var13_15 = new Void();
                                    this.mutex_.unlock();
                                    return var13_15;
                                }
                                ** if (type != ExceptionType.ET_UNKNOW) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    throw e;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    break block14;
                                }
                            }
                            this.parseException(e.getMessage(), node);
                        }
                        this.switchDataNode(node);
                    }
                }
                var10_12 = null;
                return var10_12;
            }
            var8_9 = DBConnectionImpl.access$1200(this.conn_, script, listener, priority, parallelism, fetchSize, clearSessionMemory, tableName, 0L);
            return var8_9;
            {
                catch (Throwable var14_16) {
                    throw var14_16;
                }
            }
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public Entity tryRun(String function, List<Entity> arguments) throws IOException {
        return this.tryRun(function, arguments, 4, 2);
    }

    public Entity tryRun(String function, List<Entity> arguments, int priority, int parallelism) throws IOException {
        return this.tryRun(function, arguments, priority, parallelism, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity tryRun(String function, List<Entity> arguments, int priority, int parallelism, int fetchSize) throws IOException {
        if (!this.mutex_.tryLock()) {
            return null;
        }
        try {
            Entity entity = this.run(function, arguments, priority, parallelism, fetchSize);
            return entity;
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public Entity run(String function, List<Entity> arguments) throws IOException {
        return this.run(function, arguments, 4, 2);
    }

    public Entity run(String function, List<Entity> arguments, int priority) throws IOException {
        return this.run(function, arguments, priority, 2);
    }

    public Entity run(String function, List<Entity> arguments, int priority, int parallelism) throws IOException {
        return this.run(function, arguments, priority, parallelism, 0);
    }

    private long newSeqNo() {
        this.mutex_.lock();
        ++this.runSeqNo_;
        if (this.runSeqNo_ <= 0L) {
            this.runSeqNo_ = 1L;
        }
        long res = this.runSeqNo_;
        this.mutex_.unlock();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Entity run(String function, List<Entity> arguments, int priority, int parallelism, int fetchSize) throws IOException {
        this.mutex_.lock();
        try {
            if (!this.nodes_.isEmpty()) {
                seqNo = this.newSeqNo();
                while (!this.closed_) {
                    try {
                        var8_9 = DBConnectionImpl.access$1300(this.conn_, function, null, arguments, priority, parallelism, fetchSize, false, seqNo);
                        return var8_9;
                    }
                    catch (IOException e) {
                        block14: {
                            block13: {
                                if (seqNo > 0L) {
                                    seqNo = -seqNo;
                                }
                                node = new Node();
                                if (!this.connected()) break block13;
                                type = this.parseException(e.getMessage(), node);
                                if (type == ExceptionType.ET_IGNORE) {
                                    var11_13 = new Void();
                                    this.mutex_.unlock();
                                    return var11_13;
                                }
                                ** if (type != ExceptionType.ET_UNKNOW) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    throw e;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    break block14;
                                }
                            }
                            this.parseException(e.getMessage(), node);
                        }
                        this.switchDataNode(node);
                    }
                }
                var8_10 = null;
                return var8_10;
            }
            var6_7 = DBConnectionImpl.access$1300(this.conn_, function, null, arguments, priority, parallelism, fetchSize, false, 0L);
            return var6_7;
            {
                catch (Throwable var12_14) {
                    throw var12_14;
                }
            }
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public void tryUpload(Map<String, Entity> variableObjectMap) throws IOException {
        if (!this.mutex_.tryLock()) {
            throw new IOException("The connection is in use.");
        }
        try {
            this.upload(variableObjectMap);
        }
        finally {
            this.mutex_.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(Map<String, Entity> variableObjectMap) throws IOException {
        block16: {
            this.mutex_.lock();
            try {
                ArrayList<String> keys = new ArrayList<String>();
                ArrayList<Entity> objs = new ArrayList<Entity>();
                if (!this.nodes_.isEmpty()) {
                    while (!this.closed_) {
                        try {
                            for (String key : variableObjectMap.keySet()) {
                                if (variableObjectMap.size() == 1) {
                                    Entity obj = variableObjectMap.get(key);
                                    this.conn_.upload(key, obj, 0L);
                                    continue;
                                }
                                keys.add(key);
                                objs.add(variableObjectMap.get(key));
                            }
                            if (variableObjectMap.size() > 1) {
                                this.conn_.upload(keys, objs, 0L);
                            }
                            break block16;
                        }
                        catch (Exception e) {
                            Node node = new Node();
                            if (this.connected()) {
                                ExceptionType type = this.parseException(e.getMessage(), node);
                                if (type == ExceptionType.ET_IGNORE) continue;
                                if (type == ExceptionType.ET_UNKNOW) {
                                    throw e;
                                }
                            } else {
                                this.parseException(e.getMessage(), node);
                            }
                            this.switchDataNode(node);
                        }
                    }
                    break block16;
                }
                for (String key : variableObjectMap.keySet()) {
                    if (variableObjectMap.size() == 1) {
                        Entity obj = variableObjectMap.get(key);
                        this.conn_.upload(key, obj, 0L);
                        continue;
                    }
                    keys.add(key);
                    objs.add(variableObjectMap.get(key));
                }
                if (variableObjectMap.size() > 1) {
                    this.conn_.upload(keys, objs, 0L);
                }
            }
            finally {
                this.mutex_.unlock();
            }
        }
    }

    public void close() {
        this.mutex_.lock();
        try {
            this.closed_ = true;
            this.conn_.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public String getHostName() {
        return this.conn_.hostName_;
    }

    public int getPort() {
        return this.conn_.port_;
    }

    public String getUserId() {
        return this.conn_.userId_;
    }

    public String getPwd() {
        return this.conn_.pwd_;
    }

    public String getSessionID() {
        return this.conn_.sessionID_;
    }

    public InetAddress getLocalAddress() {
        return this.conn_.socket_.getLocalAddress();
    }

    public Socket getSocket() {
        return this.conn_.socket_;
    }

    public ExtendedDataInput getDataInputStream() {
        return this.conn_.getDataInputStream();
    }

    public boolean isConnected() {
        return this.conn_.socket_ != null && this.conn_.socket_.isConnected();
    }

    private SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }}, new SecureRandom());
            return context.getSocketFactory();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private boolean getServerVersion() throws IOException {
        try {
            Entity ret = this.conn_.run("version()", 0L);
            if (ret == null) {
                throw new IOException("run version failed");
            }
            String version = ret.getString();
            String[] verList = version.split(" ");
            if (verList.length > 1) {
                version = verList[0];
            }
            verList = version.split("\\.");
            this.serverVersion_ = new int[4];
            int size = verList.length;
            if (size > 4) {
                size = 4;
            } else if (size < 3) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                this.serverVersion_[i] = Integer.parseInt(verList[i]);
            }
        }
        catch (Exception e) {
            throw new IOException("Run version failed error: " + e.getMessage());
        }
        return true;
    }

    private boolean compareVersionGE(int[] version) {
        for (int i = 0; i < version.length; ++i) {
            if (this.serverVersion_[i] == version[i]) continue;
            return this.serverVersion_[i] > version[i];
        }
        return true;
    }

    private boolean checkClientIdValid() {
        if (this.serverVersion_[0] == 1) {
            return this.compareVersionGE(new int[]{1, 30, 20, 5});
        }
        if (this.serverVersion_[0] == 2) {
            return this.compareVersionGE(new int[]{2, 0, 9, 0});
        }
        return true;
    }

    private class DBConnectionImpl {
        private Socket socket_;
        private String sessionID_ = "";
        private String hostName_;
        private int port_;
        private String userId_;
        private String pwd_;
        private boolean encrypted_ = true;
        private boolean isConnected_;
        private boolean sslEnable_ = false;
        private boolean asynTask_ = false;
        private boolean compress_ = false;
        private boolean ifUrgent_ = false;
        private int connTimeout_ = 0;
        private ExtendedDataInput in_;
        private ExtendedDataOutput out_;
        private boolean remoteLittleEndian_;
        private ReentrantLock lock_;
        private boolean isReverseStreaming_ = false;
        private boolean python_ = false;
        private SqlStdEnum sqlStd_;

        private DBConnectionImpl(boolean asynTask, boolean sslEnable, boolean compress, boolean python, boolean ifUrgent, boolean isReverseStreaming, SqlStdEnum sqlStd) {
            this.sslEnable_ = sslEnable;
            this.asynTask_ = asynTask;
            this.compress_ = compress;
            this.ifUrgent_ = ifUrgent;
            this.python_ = python;
            this.isReverseStreaming_ = isReverseStreaming;
            this.sqlStd_ = sqlStd;
            this.lock_ = new ReentrantLock();
        }

        private boolean connect(String hostName, int port, String userId, String password, int connTimeout) throws IOException {
            this.hostName_ = hostName;
            this.port_ = port;
            this.userId_ = userId;
            this.pwd_ = password;
            this.connTimeout_ = connTimeout;
            return this.connect();
        }

        private boolean connect() throws IOException {
            this.isConnected_ = false;
            this.socket_ = this.sslEnable_ ? DBConnection.this.getSSLSocketFactory().createSocket() : new Socket();
            if (this.connTimeout_ > 0) {
                this.socket_.connect(new InetSocketAddress(this.hostName_, this.port_), this.connTimeout_);
            } else {
                this.socket_.connect(new InetSocketAddress(this.hostName_, this.port_), 3000);
            }
            if (this.connTimeout_ > 0) {
                this.socket_.setSoTimeout(this.connTimeout_);
            }
            this.socket_.setKeepAlive(true);
            this.socket_.setTcpNoDelay(true);
            this.out_ = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket_.getOutputStream()));
            this.in_ = new LittleEndianDataInputStream(new BufferedInputStream(this.socket_.getInputStream()));
            String body = "connect\n";
            this.out_.writeBytes("API 0 ");
            this.out_.writeBytes(String.valueOf(body.length()));
            int flag = this.generateRequestFlag(false);
            this.out_.writeBytes(" / " + String.valueOf(flag) + "_1_" + String.valueOf(4) + "_" + String.valueOf(2));
            this.out_.writeByte(10);
            this.out_.writeBytes(body);
            this.out_.flush();
            String line = this.in_.readLine();
            int endPos = line.indexOf(32);
            if (endPos <= 0) {
                this.close();
                return false;
            }
            this.sessionID_ = line.substring(0, endPos);
            int startPos = endPos + 1;
            if ((endPos = line.indexOf(32, startPos)) != line.length() - 2) {
                this.close();
                return false;
            }
            String msg = this.in_.readLine();
            this.isConnected_ = true;
            if (line.charAt(endPos + 1) == '0') {
                this.remoteLittleEndian_ = false;
                this.out_ = new BigEndianDataOutputStream(new BufferedOutputStream(this.socket_.getOutputStream()));
            } else {
                this.remoteLittleEndian_ = true;
            }
            if (!this.userId_.isEmpty() && !this.pwd_.isEmpty()) {
                if (this.asynTask_) {
                    this.login(this.userId_, this.pwd_, false);
                } else {
                    this.login();
                }
            }
            return true;
        }

        private int generateRequestFlag(boolean clearSessionMemory) {
            int flag = 0;
            if (this.ifUrgent_) {
                ++flag;
            }
            if (this.asynTask_) {
                flag += 4;
            }
            if (clearSessionMemory) {
                flag += 16;
            }
            if (this.compress_) {
                flag += 64;
            }
            if (this.python_) {
                flag += 2048;
            }
            if (this.isReverseStreaming_) {
                flag += 131072;
            }
            if (Objects.nonNull((Object)this.sqlStd_)) {
                flag += this.sqlStd_.getCode() << 19;
            }
            return flag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void login(String userId, String password, boolean enableEncryption) throws IOException {
            this.lock_.lock();
            try {
                this.userId_ = userId;
                this.pwd_ = password;
                this.encrypted_ = enableEncryption;
                this.login();
            }
            finally {
                this.lock_.unlock();
            }
        }

        private void login() throws IOException {
            ArrayList<Entity> args = new ArrayList<Entity>();
            if (this.encrypted_) {
                BasicString keyCode = (BasicString)this.run("getDynamicPublicKey", new ArrayList<Entity>(), 0L);
                PublicKey key = RSAUtils.getPublicKey(keyCode.getString());
                byte[] usr = RSAUtils.encryptByPublicKey(this.userId_.getBytes(), key);
                byte[] pass = RSAUtils.encryptByPublicKey(this.pwd_.getBytes(), key);
                args.add(new BasicString(Base64.getMimeEncoder().encodeToString(usr)));
                args.add(new BasicString(Base64.getMimeEncoder().encodeToString(pass)));
                args.add(new BasicBoolean(true));
            } else {
                args.add(new BasicString(this.userId_));
                args.add(new BasicString(this.pwd_));
            }
            this.run("login", args, 0L);
        }

        private Entity run(String script, long seqNum) throws IOException {
            ArrayList<Entity> args = new ArrayList<Entity>();
            return this.run(script, "script", null, args, 4, 2, 0, false, seqNum);
        }

        private Entity run(String script, ProgressListener listener, int priority, int parallelism, int fetchSize, boolean clearMemory, String tableName, long seqNum) throws IOException {
            ArrayList<Entity> args = new ArrayList<Entity>();
            return this.run(script, "script", listener, args, priority, parallelism, fetchSize, clearMemory, tableName, seqNum);
        }

        private Entity run(String function, List<Entity> arguments, long seqNum) throws IOException {
            return this.run(function, "function", null, arguments, 4, 2, 0, false, seqNum);
        }

        private Entity run(String function, String scriptType, List<Entity> arguments, long seqNum) throws IOException {
            return this.run(function, scriptType, null, arguments, 4, 2, 0, false, seqNum);
        }

        private Entity run(String function, ProgressListener listener, List<Entity> args, int priority, int parallelism, int fetchSize, boolean clearMemory, long seqNum) throws IOException {
            return this.run(function, "function", listener, args, priority, parallelism, fetchSize, clearMemory, seqNum);
        }

        private Entity run(String script, String scriptType, ProgressListener listener, List<Entity> args, int priority, int parallelism, int fetchSize, boolean clearMemory, long seqNum) throws IOException {
            return this.run(script, scriptType, listener, args, priority, parallelism, fetchSize, clearMemory, "", seqNum);
        }

        private Entity run(String script, String scriptType, ProgressListener listener, List<Entity> args, int priority, int parallelism, int fetchSize, boolean clearMemory, String tableName, long seqNum) throws IOException {
            if (!this.isConnected_) {
                throw new IOException("Couldn't send script/function to the remote host because the connection has been closed");
            }
            if (fetchSize > 0 && fetchSize < 8192) {
                throw new IOException("fetchSize must be greater than 8192");
            }
            if (this.socket_ == null || !this.socket_.isConnected() || this.socket_.isClosed()) {
                if (this.sessionID_.isEmpty()) {
                    throw new IOException("Database connection is not established yet.");
                }
                this.socket_ = new Socket(this.hostName_, this.port_);
                this.socket_.setKeepAlive(true);
                this.socket_.setTcpNoDelay(true);
                this.out_ = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket_.getOutputStream()));
            }
            if (!tableName.equals("")) {
                script = tableName + "=" + script;
                this.run(script, 0L);
                BasicDictionary schema = (BasicDictionary)this.run(tableName + ".schema()", 0L);
                BasicTable colDefs = (BasicTable)schema.get(new BasicString("colDefs"));
                BasicStringVector colDefsName = (BasicStringVector)colDefs.getColumn("name");
                BasicIntVector colDefsTypeInt = (BasicIntVector)colDefs.getColumn("typeInt");
                int cols = colDefs.rows();
                int rows = ((BasicInt)this.run("rows(" + tableName + ")", 0L)).getInt();
                HashMap<Integer, Entity.DATA_TYPE> types2Index = new HashMap<Integer, Entity.DATA_TYPE>();
                HashMap<Integer, String> name2Index = new HashMap<Integer, String>();
                for (int i = 0; i < cols; ++i) {
                    types2Index.put(types2Index.size(), Entity.DATA_TYPE.valueOf(colDefsTypeInt.getInt(i)));
                    name2Index.put(name2Index.size(), colDefsName.getString(i));
                }
                return new BasicTableSchema(types2Index, name2Index, rows, cols, tableName, DBConnection.this);
            }
            StringBuilder body = new StringBuilder();
            int argCount = args.size();
            if (scriptType == "script") {
                body.append("script\n" + script);
            } else {
                body.append(scriptType + "\n" + script);
                body.append("\n" + String.valueOf(argCount));
                body.append("\n");
                body.append(this.remoteLittleEndian_ ? "1" : "0");
            }
            try {
                this.out_.writeBytes((listener != null ? "API2 " : "API ") + this.sessionID_ + " ");
                this.out_.writeBytes(String.valueOf(AbstractExtendedDataOutputStream.getUTFlength(body.toString(), 0, 0)));
                int flag = this.generateRequestFlag(clearMemory);
                HashMap<Property, Object> properties = new HashMap<Property, Object>();
                properties.put(Property.flag, flag);
                properties.put(Property.cancel, 1);
                properties.put(Property.priority, priority);
                properties.put(Property.parallelism, parallelism);
                if (fetchSize > 0) {
                    properties.put(Property.fetchSize, fetchSize);
                }
                if (DBConnection.this.enableHighAvailability_ && DBConnection.this.runClientId_ != null && seqNum != 0L) {
                    properties.put(Property.clientId, DBConnection.this.runClientId_);
                    properties.put(Property.seqNo, seqNum);
                }
                int lastNotNullValue = -1;
                StringBuilder sbProp = new StringBuilder(" / ");
                for (Property key : Property.values()) {
                    Object value = properties.get((Object)key);
                    if (value != null) {
                        sbProp.append(value);
                        lastNotNullValue = sbProp.length();
                    }
                    sbProp.append("_");
                }
                sbProp.delete(lastNotNullValue, sbProp.length());
                sbProp.append('\n');
                this.out_.writeBytes(sbProp.toString());
                this.out_.writeBytes(body.toString());
                if (argCount > 0) {
                    for (int i = 0; i < args.size(); ++i) {
                        if (this.compress_ && args.get(i).isTable()) {
                            args.get(i).writeCompressed(this.out_);
                            continue;
                        }
                        args.get(i).write(this.out_);
                    }
                    this.out_.flush();
                } else {
                    this.out_.flush();
                }
            }
            catch (IOException ex) {
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Couldn't send script/function to the remote host because the connection has been closed");
            }
            if (this.asynTask_) {
                return null;
            }
            String header = null;
            try {
                header = this.in_.readLine();
                while (header.equals("MSG")) {
                    String msg = this.in_.readString();
                    if (listener != null) {
                        listener.progress(msg);
                    }
                    header = this.in_.readLine();
                }
            }
            catch (IOException ex) {
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Failed to read response header from the socket with IO error " + ex.getMessage());
            }
            String[] headers = header.split(" ");
            if (headers.length != 3) {
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Received invalid header");
            }
            int numObject = Integer.parseInt(headers[1]);
            try {
                header = this.in_.readLine();
            }
            catch (IOException ex) {
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Failed to read response header from the socket with IO error " + ex.getMessage());
            }
            if (!header.equals("OK")) {
                if (scriptType == "script") {
                    throw new IOException(this.hostName_ + ":" + this.port_ + " Server response: '" + header + "' script: '" + script + "'");
                }
                throw new IOException(this.hostName_ + ":" + this.port_ + " Server response: '" + header + "' " + scriptType + ": '" + script + "'");
            }
            if (numObject == 0) {
                return new Void();
            }
            try {
                boolean extended;
                short flag = this.in_.readShort();
                int form = flag >> 8;
                int type = flag & 0xFF;
                boolean bl = extended = type >= 128;
                if (type >= 128) {
                    type -= 128;
                }
                if (form < 0 || form > MAX_FORM_VALUE) {
                    throw new IOException("Invalid form value: " + form);
                }
                if (type < 0 || type > MAX_TYPE_VALUE) {
                    throw new IOException("Invalid type value: " + type);
                }
                Entity.DATA_FORM df = Entity.DATA_FORM.values()[form];
                Entity.DATA_TYPE dt = Entity.DATA_TYPE.valueOf(type);
                if (fetchSize > 0 && df == Entity.DATA_FORM.DF_VECTOR && dt == Entity.DATA_TYPE.DT_ANY) {
                    return new EntityBlockReader(this.in_);
                }
                EntityFactory factory = BasicEntityFactory.instance();
                return factory.createEntity(df, dt, this.in_, extended);
            }
            catch (IOException ex) {
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Failed to read object flag from the socket with IO error type " + ex.getMessage());
            }
        }

        public void upload(String name, Entity obj, long seqNum) throws IOException {
            if (!Utils.isVariableCandidate(name)) {
                throw new RuntimeException(name + " is not a qualified variable name.");
            }
            ArrayList<Entity> args = new ArrayList<Entity>();
            args.add(obj);
            this.run(name, "variable", args, seqNum);
        }

        public void upload(List<String> names, List<Entity> objs, long seqNum) throws IOException {
            if (names.size() != objs.size()) {
                throw new RuntimeException("the size of variable names doesn't match the size of objects.");
            }
            if (names.isEmpty()) {
                return;
            }
            StringBuilder varNames = new StringBuilder();
            for (int i = 0; i < names.size(); ++i) {
                if (!Utils.isVariableCandidate(names.get(i))) {
                    throw new RuntimeException(names.get(i) + " is not a qualified variable name.");
                }
                if (i > 0) {
                    varNames.append(",");
                }
                varNames.append(names.get(i));
            }
            this.run(varNames.toString(), "variable", objs, seqNum);
        }

        public void close() {
            this.lock_.lock();
            try {
                if (this.socket_ != null) {
                    this.socket_.close();
                    this.socket_ = null;
                    this.sessionID_ = "";
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                this.lock_.unlock();
            }
            this.isConnected_ = false;
        }

        public boolean isConnected() {
            return this.isConnected_;
        }

        public void getNode(Node node) {
            node.hostName = this.hostName_;
            node.port = this.port_;
        }

        public boolean getRemoteLittleEndian() {
            return this.remoteLittleEndian_;
        }

        public ExtendedDataInput getDataInputStream() {
            return this.in_;
        }

        static /* synthetic */ Entity access$1200(DBConnectionImpl x0, String x1, ProgressListener x2, int x3, int x4, int x5, boolean x6, String x7, long x8) throws IOException {
            return x0.run(x1, x2, x3, x4, x5, x6, x7, x8);
        }

        static /* synthetic */ Entity access$1300(DBConnectionImpl x0, String x1, ProgressListener x2, List x3, int x4, int x5, int x6, boolean x7, long x8) throws IOException {
            return x0.run(x1, x2, x3, x4, x5, x6, x7, x8);
        }
    }

    static enum Property {
        flag,
        cancel,
        priority,
        parallelism,
        jobId,
        fetchSize,
        offset,
        clientId,
        seqNo;

    }

    private static class Node {
        private String hostName;
        private int port;
        private double load = -1.0;

        public Node() {
            this.load = -1.0;
        }

        public Node(String hostName, int port, double load) {
            this.hostName = hostName;
            this.port = port;
            this.load = load;
        }

        public Node(String hostName, int port) {
            this.hostName = hostName;
            this.port = port;
            this.load = -1.0;
        }

        public Node(String ipPort, double loadValue) {
            String[] v = ipPort.split(":");
            if (v.length < 2) {
                throw new RuntimeException("The ipPort '" + ipPort + "' is invalid.");
            }
            this.hostName = v[0];
            this.port = Integer.parseInt(v[1]);
        }

        public Node(String ipPort) {
            String[] v = ipPort.split(":");
            if (v.length < 2) {
                throw new RuntimeException("The ipPort '" + ipPort + "' is invalid.");
            }
            this.hostName = v[0];
            this.port = Integer.parseInt(v[1]);
            this.load = -1.0;
        }

        public boolean equals(Object o) {
            if (o instanceof Node) {
                Node node = (Node)o;
                if (node.hostName == null || this.hostName == null) {
                    return false;
                }
                int diff = this.hostName.compareTo(node.hostName);
                if (diff != 0) {
                    return false;
                }
                return this.port == node.port;
            }
            return false;
        }
    }

    private static enum ExceptionType {
        ET_IGNORE(0),
        ET_UNKNOW(1),
        ET_NEWLEADER(2),
        ET_NODENOTAVAIL(3),
        ET_NOINITIALIZED(4),
        ET_NOTLEADER(5);

        public int value;

        private ExceptionType(int value) {
            this.value = value;
        }
    }

    private static enum ServerExceptionState {
        NEW_LEADER,
        WAIT,
        CONN_FAIL,
        OTHER_EXCEPTION,
        DATA_NODE_NOT_AVAILABLE;

    }
}

