/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb;

import com.xxdb.BasicDBTask;
import com.xxdb.DBConnection;
import com.xxdb.DBConnectionPool;
import com.xxdb.DBTask;
import com.xxdb.data.BasicStringVector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ExclusiveDBConnectionPool
implements DBConnectionPool {
    private List<AsyncWorker> workers_ = new ArrayList<AsyncWorker>();
    private final LinkedList<DBTask> taskLists_ = new LinkedList();
    private int tasksCount_ = 0;
    private final Object finishedTasklock_ = new Object();
    private int finishedTaskCount_ = 0;

    public ExclusiveDBConnectionPool(String host, int port, String uid, String pwd, int count, boolean loadBalance, boolean enableHighAvailability) throws IOException {
        this(host, port, uid, pwd, count, loadBalance, enableHighAvailability, null, "", false, false, false);
    }

    public ExclusiveDBConnectionPool(String host, int port, String uid, String pwd, int count, boolean loadBalance, boolean enableHighAvailability, String[] highAvailabilitySites, String initialScript, boolean compress, boolean useSSL, boolean usePython) throws IOException {
        if (count <= 0) {
            throw new RuntimeException("The thread count can not be less than 0");
        }
        if (!loadBalance) {
            for (int i = 0; i < count; ++i) {
                DBConnection conn = new DBConnection(false, useSSL, compress, usePython);
                conn.setLoadBalance(false);
                if (!conn.connect(host, port, uid, pwd, initialScript, enableHighAvailability, highAvailabilitySites)) {
                    throw new RuntimeException("Can't connect to the specified host.");
                }
                this.workers_.add(new AsyncWorker(conn));
            }
        } else {
            int i;
            BasicStringVector nodes = null;
            if (highAvailabilitySites != null) {
                nodes = new BasicStringVector(highAvailabilitySites);
            } else {
                DBConnection entryPoint = new DBConnection(false, useSSL, compress, usePython);
                if (!entryPoint.connect(host, port, uid, pwd)) {
                    throw new RuntimeException("Can't connect to the specified host.");
                }
                nodes = (BasicStringVector)entryPoint.run("rpc(getControllerAlias(), getClusterLiveDataNodes{false})");
                entryPoint.close();
            }
            int nodeCount = nodes.rows();
            String[] hosts = new String[nodeCount];
            int[] ports = new int[nodeCount];
            for (i = 0; i < nodeCount; ++i) {
                String[] fields = nodes.getString(i).split(":");
                if (fields.length < 2) {
                    throw new RuntimeException("Invalid data node address: " + nodes.getString(i));
                }
                hosts[i] = fields[0];
                ports[i] = Integer.parseInt(fields[1]);
            }
            for (i = 0; i < count; ++i) {
                DBConnection conn = new DBConnection(false, useSSL, compress, usePython);
                conn.setLoadBalance(false);
                if (!conn.connect(hosts[i % nodeCount], ports[i % nodeCount], uid, pwd, initialScript, enableHighAvailability, highAvailabilitySites)) {
                    throw new RuntimeException("Can't connect to the host " + nodes.getString(i));
                }
                this.workers_.add(new AsyncWorker(conn));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(List<DBTask> tasks) {
        LinkedList<DBTask> linkedList = this.taskLists_;
        synchronized (linkedList) {
            this.tasksCount_ += tasks.size();
            this.taskLists_.addAll(tasks);
            this.taskLists_.notifyAll();
        }
        for (DBTask task : tasks) {
            ((BasicDBTask)task).waitFor(-1);
        }
    }

    @Override
    public void execute(DBTask task) {
        this.execute(task, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DBTask task, int timeOut) {
        LinkedList<DBTask> linkedList = this.taskLists_;
        synchronized (linkedList) {
            ++this.tasksCount_;
            this.taskLists_.add(task);
            this.taskLists_.notify();
        }
        ((BasicDBTask)task).waitFor(timeOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForThreadCompletion() {
        try {
            Object object = this.finishedTasklock_;
            synchronized (object) {
                System.out.println("Waiting for tasks to complete, remain Task: " + (this.tasksCount_ - this.finishedTaskCount_));
                while (this.finishedTaskCount_ >= 0) {
                    if (this.finishedTaskCount_ < this.tasksCount_) {
                        this.finishedTasklock_.wait();
                        continue;
                    }
                    if (this.finishedTaskCount_ != this.tasksCount_) continue;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getConnectionCount() {
        return this.workers_.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.waitForThreadCompletion();
        for (AsyncWorker one : this.workers_) {
            Thread thread = one.workThread_;
            synchronized (thread) {
                one.workThread_.interrupt();
            }
        }
    }

    private class AsyncWorker
    implements Runnable {
        private DBConnection conn_;
        private final Thread workThread_;

        public AsyncWorker(DBConnection conn) {
            this.conn_ = conn;
            this.workThread_ = new Thread(this);
            this.workThread_.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.workThread_.isInterrupted()) {
                DBTask task = null;
                Object object = ExclusiveDBConnectionPool.this.taskLists_;
                synchronized (object) {
                    if (ExclusiveDBConnectionPool.this.taskLists_.size() == 0) {
                        try {
                            ExclusiveDBConnectionPool.this.taskLists_.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
                while (true) {
                    object = ExclusiveDBConnectionPool.this.taskLists_;
                    synchronized (object) {
                        task = (DBTask)ExclusiveDBConnectionPool.this.taskLists_.pollLast();
                    }
                    if (task == null) break;
                    try {
                        task.setDBConnection(this.conn_);
                        task.call();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ((BasicDBTask)task).finish();
                    object = ExclusiveDBConnectionPool.this.finishedTasklock_;
                    synchronized (object) {
                        ExclusiveDBConnectionPool.this.finishedTaskCount_++;
                    }
                }
                object = ExclusiveDBConnectionPool.this.finishedTasklock_;
                synchronized (object) {
                    ExclusiveDBConnectionPool.this.finishedTasklock_.notify();
                }
            }
            this.conn_.close();
            System.out.println("ExclusiveDBConnectionPool AsyncWorker terminated peacefully.");
        }
    }
}

