/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.temporal.Temporal;

public class BasicDecimal32
extends AbstractScalar
implements Comparable<BasicDecimal32> {
    private int scale_ = 0;
    private int value_;

    public BasicDecimal32(ExtendedDataInput in) throws IOException {
        this.scale_ = in.readInt();
        this.value_ = in.readInt();
    }

    public BasicDecimal32(int value, int scale) {
        this.scale_ = scale;
        this.value_ = value * (int)Math.pow(10.0, this.scale_);
    }

    public BasicDecimal32(String value, int scale) {
        value = value.trim();
        if (Utils.isEmpty(value)) {
            throw new RuntimeException("value is empty!");
        }
        if (scale < 0 || scale > 9) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,9].");
        }
        this.scale_ = scale;
        if ("0".equals(value)) {
            this.value_ = 0;
        } else {
            BigDecimal bd = new BigDecimal(value);
            BigDecimal pow = BigDecimal.TEN.pow(this.scale_);
            BigDecimal multipliedValue = bd.multiply(pow);
            if ((long)multipliedValue.intValue() != multipliedValue.longValue()) {
                throw new RuntimeException("Decimal math overflow!");
            }
            this.value_ = multipliedValue.intValue();
        }
    }

    @Deprecated
    public BasicDecimal32(double value, int scale) {
        this.scale_ = scale;
        if (value == 0.0) {
            this.value_ = 0;
        } else {
            BigDecimal pow = new BigDecimal(1);
            for (long i = 0L; i < (long)this.scale_; ++i) {
                pow = pow.multiply(new BigDecimal(10));
            }
            BigDecimal dbvalue = new BigDecimal(Double.toString(value));
            BigDecimal multipliedValue = dbvalue.multiply(pow);
            if ((long)multipliedValue.intValue() != multipliedValue.longValue()) {
                throw new RuntimeException("Decimal math overflow!");
            }
            this.value_ = multipliedValue.intValue();
        }
    }

    BasicDecimal32(int[] all) {
        this.scale_ = all[0];
        this.value_ = all[1];
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeInt(this.scale_);
        out.writeInt(this.value_);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.DENARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DECIMAL32;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        BigDecimal pow = new BigDecimal(1);
        for (long i = 0L; i < (long)this.scale_; ++i) {
            pow = pow.multiply(new BigDecimal(10));
        }
        if (this.value_ < 0 && (long)this.value_ / pow.longValue() == 0L) {
            sb.append("-");
        }
        sb.append((long)this.value_ / pow.longValue());
        if (pow.intValue() != 1) {
            int sign = this.value_ < 0 ? -1 : 1;
            BigDecimal result = new BigDecimal((long)this.value_ % pow.longValue() * (long)sign);
            sb.append(".");
            String s = result.toString();
            int nowLen = sb.length();
            while (sb.length() - nowLen < this.scale_ - s.length()) {
                sb.append("0");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public boolean isNull() {
        return this.value_ == Integer.MIN_VALUE;
    }

    @Override
    public void setNull() {
        this.value_ = Integer.MIN_VALUE;
    }

    @Override
    public Number getNumber() throws Exception {
        if (this.isNull()) {
            return Integer.MIN_VALUE;
        }
        BigDecimal pow = new BigDecimal(1);
        for (long i = 0L; i < (long)this.scale_; ++i) {
            pow = pow.multiply(new BigDecimal(10));
        }
        BigDecimal dbvalue = new BigDecimal(this.value_);
        double num = dbvalue.divide(pow).doubleValue();
        if (num % 1.0 == 0.0) {
            return (int)num;
        }
        return num;
    }

    @Override
    public int getScale() {
        return this.scale_;
    }

    @Override
    @JsonIgnore
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public int hashBucket(int buckets) {
        return 0;
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return this.getString();
    }

    @Override
    public int compareTo(BasicDecimal32 o) {
        double a = Double.parseDouble(this.getString());
        double b = Double.parseDouble(o.getString());
        return Double.compare(a, b);
    }

    public int getInt() {
        return this.value_;
    }
}

