/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.route;

import com.xxdb.DBConnection;
import com.xxdb.data.BasicBoolean;
import com.xxdb.data.BasicDateHourVector;
import com.xxdb.data.BasicDateTimeVector;
import com.xxdb.data.BasicDateVector;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicMinuteVector;
import com.xxdb.data.BasicMonthVector;
import com.xxdb.data.BasicNanoTimeVector;
import com.xxdb.data.BasicNanoTimestampVector;
import com.xxdb.data.BasicSecondVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.BasicTimeVector;
import com.xxdb.data.BasicTimestampVector;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;

public class AutoFitTableAppender {
    String dbUrl_;
    String tableName_;
    boolean async_;
    DBConnection con_;
    APPEND_ACTION _action;

    public AutoFitTableAppender(String dbUrl, String tableName, DBConnection conn) {
        this.dbUrl_ = dbUrl;
        this.tableName_ = tableName;
        this.con_ = conn;
        this._action = APPEND_ACTION.fitColumnType;
    }

    public AutoFitTableAppender(String dbUrl, String tableName, DBConnection conn, APPEND_ACTION action) {
        this.dbUrl_ = dbUrl;
        this.tableName_ = tableName;
        this.con_ = conn;
        this._action = action;
    }

    public String getDTString(Entity.DATA_TYPE type) {
        switch (type) {
            case DT_ANY: {
                return "ANY";
            }
            case DT_BLOB: {
                return "BLOB";
            }
            case DT_BOOL: {
                return "BOOL";
            }
            case DT_BYTE: {
                return "BYTE";
            }
            case DT_CODE: {
                return "CODE";
            }
            case DT_COMPRESS: {
                return "COMPRESSED";
            }
            case DT_DATASOURCE: {
                return "DATASOURCE";
            }
            case DT_DATE: {
                return "DATE";
            }
            case DT_DATEHOUR: {
                return "DATEHOUR";
            }
            case DT_DATEMINUTE: {
                return "DATEMINUTE";
            }
            case DT_DATETIME: {
                return "DATETIME";
            }
            case DT_DICTIONARY: {
                return "DICTIONARY";
            }
            case DT_DOUBLE: {
                return "DOUBLE";
            }
            case DT_FLOAT: {
                return "FLOAT";
            }
            case DT_FUNCTIONDEF: {
                return "FUNCTIONDEF";
            }
            case DT_HANDLE: {
                return "HANDLE";
            }
            case DT_INT: {
                return "INT";
            }
            case DT_INT128: {
                return "INT128";
            }
            case DT_IPADDR: {
                return "IPADDR";
            }
            case DT_LONG: {
                return "LONG";
            }
            case DT_MINUTE: {
                return "MINUTE";
            }
            case DT_MONTH: {
                return "MONTH";
            }
            case DT_NANOTIME: {
                return "NANOTIME";
            }
            case DT_NANOTIMESTAMP: {
                return "NANOTIMESTAMP";
            }
            case DT_OBJECT: {
                return "OBJECT";
            }
            case DT_STRING: {
                return "STRING";
            }
            case DT_RESOURCE: {
                return "RESOURCE";
            }
            case DT_SECOND: {
                return "SECOND";
            }
            case DT_SHORT: {
                return "SHORT";
            }
            case DT_SYMBOL: {
                return "SYMBOL";
            }
            case DT_TIME: {
                return "TIME";
            }
            case DT_TIMESTAMP: {
                return "TIMESTAMP";
            }
            case DT_UUID: {
                return "UUID";
            }
            case DT_VOID: {
                return "VOID";
            }
        }
        return "Unrecognized type";
    }

    public Entity append(BasicTable table) {
        Entity ret = new BasicBoolean(false);
        try {
            String runScript = this.dbUrl_ == "" ? "schema(" + this.tableName_ + ")" : "schema(loadTable(\"" + this.dbUrl_ + "\",\"" + this.tableName_ + "\"))";
            ret = this.con_.run(runScript);
            int columns = table.columns();
            BasicTable schema = (BasicTable)((BasicDictionary)ret).get(new BasicString("colDefs"));
            BasicStringVector typeList = (BasicStringVector)schema.getColumn("typeString");
            BasicStringVector nameList = (BasicStringVector)schema.getColumn("name");
            ArrayList<String> colName = new ArrayList<String>();
            ArrayList<Vector> cols = new ArrayList<Vector>();
            for (int i = 0; i < columns; ++i) {
                colName.add(nameList.getString(i));
            }
            int rowSize = table.rows();
            for (int i = 0; i < columns; ++i) {
                Vector dstVector;
                String name = nameList.getString(i);
                String dstType = typeList.get(i).getString();
                Vector colOrigin = table.getColumn(name);
                block13 : switch (dstType) {
                    case "DATE": {
                        int j;
                        Object[] buffer = new int[rowSize];
                        switch (colOrigin.getDataType()) {
                            case DT_DATE: {
                                dstVector = (BasicDateVector)colOrigin;
                                break block13;
                            }
                            case DT_DATETIME: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = ((BasicDateTimeVector)colOrigin).getInt(j) / 86400;
                                }
                                dstVector = new BasicDateVector((int[])buffer);
                                break block13;
                            }
                            case DT_TIMESTAMP: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicTimestampVector)colOrigin).getLong(j) / 86400000L);
                                }
                                dstVector = new BasicDateVector((int[])buffer);
                                break block13;
                            }
                            case DT_NANOTIMESTAMP: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicNanoTimestampVector)colOrigin).getLong(j) / 86400000000000L);
                                }
                                dstVector = new BasicDateVector((int[])buffer);
                                break block13;
                            }
                            case DT_DATEHOUR: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = ((BasicDateHourVector)colOrigin).getInt(j) / 24;
                                }
                                dstVector = new BasicDateVector((int[])buffer);
                                break block13;
                            }
                        }
                        throw new InterruptedException("Can't convert from " + dstType + " into " + this.getDTString(colOrigin.getDataType()));
                    }
                    case "MONTH": {
                        int j;
                        Object[] buffer = new int[rowSize];
                        switch (colOrigin.getDataType()) {
                            case DT_DATE: {
                                LocalDate localTmp;
                                int tmp;
                                for (j = 0; j < rowSize; ++j) {
                                    tmp = ((BasicDateVector)colOrigin).getInt(j);
                                    localTmp = Utils.parseDate(tmp);
                                    buffer[j] = localTmp.getYear() * 12 + localTmp.getMonthValue() - 1;
                                }
                                dstVector = new BasicMonthVector((int[])buffer);
                                break block13;
                            }
                            case DT_DATETIME: {
                                LocalDate localTmp;
                                int tmp;
                                for (j = 0; j < rowSize; ++j) {
                                    tmp = ((BasicDateTimeVector)colOrigin).getInt(j) / 86400;
                                    localTmp = Utils.parseDate(tmp);
                                    buffer[j] = localTmp.getYear() * 12 + localTmp.getMonthValue() - 1;
                                }
                                dstVector = new BasicMonthVector((int[])buffer);
                                break block13;
                            }
                            case DT_DATEHOUR: {
                                LocalDate localTmp;
                                int tmp;
                                for (j = 0; j < rowSize; ++j) {
                                    tmp = ((BasicDateHourVector)colOrigin).getInt(j) / 24;
                                    localTmp = Utils.parseDate(tmp);
                                    buffer[j] = localTmp.getYear() * 12 + localTmp.getMonthValue() - 1;
                                }
                                dstVector = new BasicMonthVector((int[])buffer);
                                break block13;
                            }
                            case DT_MONTH: {
                                dstVector = colOrigin;
                                break block13;
                            }
                            case DT_TIMESTAMP: {
                                LocalDate localTmp;
                                int tmp;
                                for (j = 0; j < rowSize; ++j) {
                                    tmp = (int)(((BasicTimestampVector)colOrigin).getLong(j) / 86400000L);
                                    localTmp = Utils.parseDate(tmp);
                                    buffer[j] = localTmp.getYear() * 12 + localTmp.getMonthValue() - 1;
                                }
                                dstVector = new BasicMonthVector((int[])buffer);
                                break block13;
                            }
                            case DT_NANOTIMESTAMP: {
                                LocalDate localTmp;
                                int tmp;
                                for (j = 0; j < rowSize; ++j) {
                                    tmp = (int)(((BasicNanoTimestampVector)colOrigin).getLong(j) / 86400000000000L);
                                    localTmp = Utils.parseDate(tmp);
                                    buffer[j] = localTmp.getYear() * 12 + localTmp.getMonthValue() - 1;
                                }
                                dstVector = new BasicMonthVector((int[])buffer);
                                break block13;
                            }
                        }
                        throw new InterruptedException("Can't convert from " + dstType + " into " + this.getDTString(colOrigin.getDataType()));
                    }
                    case "TIME": {
                        int j;
                        Object[] buffer = new int[rowSize];
                        switch (colOrigin.getDataType()) {
                            case DT_TIME: {
                                dstVector = colOrigin;
                                break block13;
                            }
                            case DT_NANOTIME: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicNanoTimeVector)colOrigin).getLong(j) / 1000000L);
                                }
                                dstVector = new BasicTimeVector((int[])buffer);
                                break block13;
                            }
                            case DT_TIMESTAMP: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicTimestampVector)colOrigin).getLong(j) % 86400000L);
                                }
                                dstVector = new BasicTimeVector((int[])buffer);
                                break block13;
                            }
                            case DT_NANOTIMESTAMP: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicNanoTimestampVector)colOrigin).getLong(j) % 86400000000000L / 1000000L);
                                }
                                dstVector = new BasicTimeVector((int[])buffer);
                                break block13;
                            }
                        }
                        throw new InterruptedException("Can't convert from " + dstType + " into " + this.getDTString(colOrigin.getDataType()));
                    }
                    case "MINUTE": {
                        int j;
                        Object[] buffer = new int[rowSize];
                        switch (colOrigin.getDataType()) {
                            case DT_TIME: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = ((BasicTimeVector)colOrigin).getInt(j) / 60000;
                                }
                                dstVector = new BasicMinuteVector((int[])buffer);
                                break block13;
                            }
                            case DT_SECOND: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = ((BasicSecondVector)colOrigin).getInt(j) / 60;
                                }
                                dstVector = new BasicMinuteVector((int[])buffer);
                                break block13;
                            }
                            case DT_MINUTE: {
                                dstVector = colOrigin;
                                break block13;
                            }
                            case DT_DATETIME: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = ((BasicDateTimeVector)colOrigin).getInt(j) % 86400 / 60;
                                }
                                dstVector = new BasicMinuteVector((int[])buffer);
                                break block13;
                            }
                            case DT_NANOTIME: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicNanoTimeVector)colOrigin).getLong(j) / 60000000000L);
                                }
                                dstVector = new BasicMinuteVector((int[])buffer);
                                break block13;
                            }
                            case DT_TIMESTAMP: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicTimestampVector)colOrigin).getLong(j) / 60000L % 1440L);
                                }
                                dstVector = new BasicMinuteVector((int[])buffer);
                                break block13;
                            }
                            case DT_NANOTIMESTAMP: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicNanoTimestampVector)colOrigin).getLong(j) / 60000000000L % 1440L);
                                }
                                dstVector = new BasicMinuteVector((int[])buffer);
                                break block13;
                            }
                        }
                        throw new InterruptedException("Can't convert from " + dstType + " into " + this.getDTString(colOrigin.getDataType()));
                    }
                    case "SECOND": {
                        int j;
                        Object[] buffer = new int[rowSize];
                        switch (colOrigin.getDataType()) {
                            case DT_TIME: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = ((BasicTimeVector)colOrigin).getInt(j) / 1000;
                                }
                                dstVector = new BasicSecondVector((int[])buffer);
                                break block13;
                            }
                            case DT_SECOND: {
                                dstVector = colOrigin;
                                break block13;
                            }
                            case DT_DATETIME: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = ((BasicDateTimeVector)colOrigin).getInt(j) % 86400;
                                }
                                dstVector = new BasicSecondVector((int[])buffer);
                                break block13;
                            }
                            case DT_NANOTIME: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicNanoTimeVector)colOrigin).getLong(j) / 1000000000L);
                                }
                                dstVector = new BasicSecondVector((int[])buffer);
                                break block13;
                            }
                            case DT_TIMESTAMP: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicTimestampVector)colOrigin).getLong(j) / 1000L % 86400L);
                                }
                                dstVector = new BasicSecondVector((int[])buffer);
                                break block13;
                            }
                            case DT_NANOTIMESTAMP: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicNanoTimestampVector)colOrigin).getLong(j) / 1000000000L % 86400L);
                                }
                                dstVector = new BasicSecondVector((int[])buffer);
                                break block13;
                            }
                        }
                        throw new InterruptedException("Can't convert from " + dstType + " into " + this.getDTString(colOrigin.getDataType()));
                    }
                    case "DATETIME": {
                        int j;
                        Object[] buffer = new int[rowSize];
                        switch (colOrigin.getDataType()) {
                            case DT_DATETIME: {
                                dstVector = colOrigin;
                                break block13;
                            }
                            case DT_TIMESTAMP: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicTimestampVector)colOrigin).getLong(j) / 1000L);
                                }
                                dstVector = new BasicDateTimeVector((int[])buffer);
                                break block13;
                            }
                            case DT_NANOTIMESTAMP: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicNanoTimestampVector)colOrigin).getLong(j) / 1000000000L);
                                }
                                dstVector = new BasicDateTimeVector((int[])buffer);
                                break block13;
                            }
                        }
                        throw new InterruptedException("Can't convert from " + dstType + " into " + this.getDTString(colOrigin.getDataType()));
                    }
                    case "TIMESTAMP": {
                        int j;
                        Object[] buffer = new long[rowSize];
                        switch (colOrigin.getDataType()) {
                            case DT_TIMESTAMP: {
                                dstVector = colOrigin;
                                break block13;
                            }
                            case DT_NANOTIMESTAMP: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicNanoTimestampVector)colOrigin).getLong(j) / 1000000L);
                                }
                                dstVector = new BasicTimestampVector((long[])buffer);
                                break block13;
                            }
                        }
                        throw new InterruptedException("Can't convert from " + dstType + " into " + this.getDTString(colOrigin.getDataType()));
                    }
                    case "NANOTIME": {
                        int j;
                        Object[] buffer = new long[rowSize];
                        switch (colOrigin.getDataType()) {
                            case DT_NANOTIME: {
                                dstVector = colOrigin;
                                break block13;
                            }
                            case DT_NANOTIMESTAMP: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicNanoTimestampVector)colOrigin).getLong(j) % 86400000000000L);
                                }
                                dstVector = new BasicNanoTimeVector((long[])buffer);
                                break block13;
                            }
                        }
                        throw new InterruptedException("Can't convert from " + dstType + " into " + this.getDTString(colOrigin.getDataType()));
                    }
                    case "NANOTIMESTAMP": {
                        Object[] buffer = new int[rowSize];
                        switch (colOrigin.getDataType()) {
                            case DT_NANOTIMESTAMP: {
                                dstVector = colOrigin;
                                break block13;
                            }
                        }
                        throw new InterruptedException("Can't convert from " + dstType + " into " + this.getDTString(colOrigin.getDataType()));
                    }
                    case "DATEHOUR": {
                        int j;
                        Object[] buffer = new int[rowSize];
                        switch (colOrigin.getDataType()) {
                            case DT_DATETIME: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = ((BasicDateTimeVector)colOrigin).getInt(j) % 3600;
                                }
                                dstVector = new BasicDateHourVector((int[])buffer);
                                break;
                            }
                            case DT_DATEHOUR: {
                                dstVector = colOrigin;
                                break;
                            }
                            case DT_TIMESTAMP: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicTimestampVector)colOrigin).getLong(j) % 3600000L);
                                }
                                dstVector = new BasicDateHourVector((int[])buffer);
                                break;
                            }
                            case DT_NANOTIMESTAMP: {
                                for (j = 0; j < rowSize; ++j) {
                                    buffer[j] = (int)(((BasicNanoTimestampVector)colOrigin).getLong(j) % 3600000000000L);
                                }
                                dstVector = new BasicDateHourVector((int[])buffer);
                                break;
                            }
                            default: {
                                throw new InterruptedException("Can't convert from " + dstType + " into " + this.getDTString(colOrigin.getDataType()));
                            }
                        }
                    }
                    default: {
                        dstVector = colOrigin;
                    }
                }
                cols.add(dstVector);
            }
            ArrayList<Entity> param = new ArrayList<Entity>();
            BasicTable paramTable = new BasicTable(colName, cols);
            param.add(paramTable);
            ret = this.dbUrl_ == "" ? this.con_.run("append!{" + this.tableName_ + "}", param) : this.con_.run("append!{loadTable(\"" + this.dbUrl_ + "\",\"" + this.tableName_ + "\"), }", param);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    static enum APPEND_ACTION {
        fitColumnType;

    }
}

