/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.DBConnection;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicString;
import com.xxdb.data.Entity;
import com.xxdb.data.Vector;
import com.xxdb.streaming.client.AbstractClient;
import com.xxdb.streaming.client.IMessage;
import com.xxdb.streaming.client.StreamDeserializer;
import com.xxdb.streaming.client.TopicPoller;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public class PollingClient
extends AbstractClient {
    TopicPoller topicPoller = null;
    private HashMap<List<String>, List<String>> users = new HashMap();

    public PollingClient() throws SocketException {
        super(0);
    }

    public PollingClient(int subscribePort) throws SocketException {
        super(subscribePort);
    }

    public PollingClient(String subscribeHost, int subscribePort) throws SocketException {
        super(subscribeHost, subscribePort);
    }

    @Override
    protected boolean doReconnect(AbstractClient.Site site) {
        try {
            Thread.sleep(1000L);
            BlockingQueue<List<IMessage>> queue = this.subscribeInternal(site.host, site.port, site.tableName, site.actionName, null, site.msgId + 1L, true, site.filter, site.deserializer, site.allowExistTopic, site.userName, site.passWord, site.msgAstable);
            System.out.println("Successfully reconnected and subscribed " + site.host + ":" + site.port + ":" + site.tableName);
            this.topicPoller.setQueue(queue);
            return true;
        }
        catch (Exception ex) {
            System.out.println("Unable to subscribe table. Will try again after 1 seconds.");
            ex.printStackTrace();
            return false;
        }
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName, long offset, boolean reconnect, Vector filter, StreamDeserializer deserializer, String userName, String passWord) throws IOException {
        return this.subscribe(host, port, tableName, actionName, offset, reconnect, filter, deserializer, userName, passWord, false);
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName, long offset, boolean reconnect, Vector filter, StreamDeserializer deserializer, String userName, String passWord, boolean msgAsTable) throws IOException {
        BlockingQueue<List<IMessage>> queue = this.subscribeInternal(host, port, tableName, actionName, null, offset, reconnect, filter, deserializer, false, userName, passWord, msgAsTable);
        List<String> tp = Arrays.asList(host, String.valueOf(port), tableName, actionName);
        List<String> usr = Arrays.asList(userName, passWord);
        this.users.put(tp, usr);
        this.topicPoller = new TopicPoller(queue);
        return this.topicPoller;
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName, long offset, boolean reconnect, Vector filter, String userName, String passWord) throws IOException {
        return this.subscribe(host, port, tableName, actionName, offset, reconnect, filter, null, userName, passWord);
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName, long offset, boolean reconnect, Vector filter, StreamDeserializer deserializer) throws IOException {
        return this.subscribe(host, port, tableName, actionName, offset, reconnect, filter, deserializer, "", "");
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName, long offset, boolean reconnect, Vector filter) throws IOException {
        return this.subscribe(host, port, tableName, actionName, offset, reconnect, filter, null);
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName, long offset, boolean reconnect) throws IOException {
        return this.subscribe(host, port, tableName, actionName, offset, reconnect, null);
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName, long offset, Vector filter) throws IOException {
        return this.subscribe(host, port, tableName, actionName, offset, false, filter);
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName, long offset) throws IOException {
        return this.subscribe(host, port, tableName, actionName, offset, false);
    }

    public TopicPoller subscribe(String host, int port, String tableName, long offset) throws IOException {
        return this.subscribe(host, port, tableName, "javaStreamingApi", offset);
    }

    public TopicPoller subscribe(String host, int port, String tableName, long offset, boolean reconnect) throws IOException {
        return this.subscribe(host, port, tableName, "javaStreamingApi", offset, reconnect);
    }

    public TopicPoller subscribe(String host, int port, String tableName) throws IOException {
        return this.subscribe(host, port, tableName, -1L);
    }

    public TopicPoller subscribe(String host, int port, String tableName, boolean reconnect) throws IOException {
        return this.subscribe(host, port, tableName, -1L, reconnect);
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName) throws IOException {
        return this.subscribe(host, port, tableName, actionName, -1L);
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName, boolean reconnect) throws IOException {
        return this.subscribe(host, port, tableName, actionName, -1L, reconnect);
    }

    public void unsubscribe(String host, int port, String tableName, String actionName) throws IOException {
        this.unsubscribeInternal(host, port, tableName, actionName);
    }

    public void unsubscribe(String host, int port, String tableName) throws IOException {
        this.unsubscribeInternal(host, port, tableName, "javaStreamingApi");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unsubscribeInternal(String host, int port, String tableName, String actionName) throws IOException {
        DBConnection dbConn = new DBConnection();
        List<String> tp = Arrays.asList(host, String.valueOf(port), tableName, actionName);
        List<String> usr = this.users.get(tp);
        String user = usr.get(0);
        String pwd = usr.get(1);
        if (!user.equals("")) {
            dbConn.connect(host, port, user, pwd);
        } else {
            dbConn.connect(host, port);
        }
        try {
            String localIP = this.listeningHost;
            if (localIP.equals("")) {
                localIP = dbConn.getLocalAddress().getHostAddress();
            }
            ArrayList<Entity> params = new ArrayList<Entity>();
            params.add(new BasicString(localIP));
            params.add(new BasicInt(this.listeningPort));
            params.add(new BasicString(tableName));
            params.add(new BasicString(actionName));
            dbConn.run("stopPublishTable", params);
            String topic = null;
            String fullTableName = host + ":" + port + "/" + tableName + "/" + actionName;
            Object object = this.tableNameToTrueTopic;
            synchronized (object) {
                topic = (String)this.tableNameToTrueTopic.get(fullTableName);
            }
            object = this.trueTopicToSites;
            synchronized (object) {
                AbstractClient.Site[] sites = (AbstractClient.Site[])this.trueTopicToSites.get(topic);
                if (sites == null || sites.length == 0) {
                    // empty if block
                }
                for (int i = 0; i < sites.length; ++i) {
                    sites[i].closed = true;
                }
            }
            object = this.queueManager;
            synchronized (object) {
                this.queueManager.removeQueue(topic);
            }
            System.out.println("Successfully unsubscribed table " + fullTableName);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            dbConn.close();
        }
    }
}

