/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractMatrix;
import com.xxdb.data.BasicDecimal128;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicLong;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;

public class BasicDecimal128Matrix
extends AbstractMatrix {
    private BigInteger[] values;
    private static final BigInteger BIGINT_MIN_VALUE = new BigInteger("-170141183460469231731687303715884105728");
    private static final BigInteger BIGINT_MAX_VALUE = new BigInteger("170141183460469231731687303715884105728");
    private static final BigDecimal DECIMAL128_MIN_VALUE = new BigDecimal("-170141183460469231731687303715884105728");
    private static final BigDecimal DECIMAL128_MAX_VALUE = new BigDecimal("170141183460469231731687303715884105728");

    public BasicDecimal128Matrix(int rows, int columns, int scale) {
        super(rows, columns, scale);
        if (scale < 0 || scale > 38) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,38].");
        }
        this.values = new BigInteger[rows * columns];
        Arrays.fill(this.values, BigInteger.ZERO);
    }

    public BasicDecimal128Matrix(int rows, int columns, List<?> listOfArrays, int scale) throws Exception {
        super(rows, columns);
        if (scale < 0 || scale > 38) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,38].");
        }
        this.scale = scale;
        this.values = new BigInteger[rows * columns];
        if (listOfArrays == null || listOfArrays.size() != columns) {
            throw new Exception("input list of arrays does not have " + columns + " columns");
        }
        for (int i = 0; i < columns; ++i) {
            Object[] newArray;
            Object array = listOfArrays.get(i);
            if (array instanceof String[]) {
                newArray = (String[])array;
                BigInteger[] tempArr = new BigInteger[newArray.length];
                if (newArray.length == 0 || newArray.length != rows) {
                    throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
                }
                for (int j = 0; j < newArray.length; ++j) {
                    BigInteger unscaledValue;
                    BigDecimal bd = new BigDecimal((String)newArray[j]);
                    Utils.checkDecimal128Range(bd, scale);
                    BigDecimal multipliedValue = bd.scaleByPowerOfTen(scale).setScale(0, RoundingMode.HALF_UP);
                    tempArr[j] = unscaledValue = multipliedValue.toBigInteger();
                }
                System.arraycopy(tempArr, 0, this.values, i * rows, rows);
                continue;
            }
            if (array instanceof BigInteger[]) {
                newArray = (BigInteger[])listOfArrays.get(i);
                if (newArray.length == 0 || newArray.length != rows) {
                    throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
                }
                for (int j = 0; j < newArray.length; ++j) {
                    newArray[j] = ((BigInteger)newArray[j]).multiply(BigInteger.TEN.pow(scale));
                }
                System.arraycopy(newArray, 0, this.values, i * rows, rows);
                continue;
            }
            throw new RuntimeException("BasicDecimal128Matrix 'listOfArrays' param only support String[] or BigInteger[].");
        }
    }

    public BasicDecimal128Matrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    @Override
    public boolean isNull(int row, int column) {
        return this.values[this.getIndex(row, column)] == BIGINT_MIN_VALUE;
    }

    @Override
    public void setNull(int row, int column) {
        this.values[this.getIndex((int)row, (int)column)] = BIGINT_MIN_VALUE;
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicDecimal128(this.scale, this.values[this.getIndex(row, column)]);
    }

    public void set(int row, int column, Entity value) {
        if (!value.getDataForm().equals((Object)Entity.DATA_FORM.DF_SCALAR) || value.getDataType() != Entity.DATA_TYPE.DT_DECIMAL128) {
            throw new RuntimeException("The value type is not BasicDecimal128!");
        }
        int newScale = ((Scalar)value).getScale();
        Entity.DATA_TYPE type = value.getDataType();
        if (this.scale < 0) {
            throw new RuntimeException("scale cannot less than 0.");
        }
        if (((Scalar)value).isNull()) {
            this.values[this.getIndex((int)row, (int)column)] = BIGINT_MIN_VALUE;
        } else if (this.scale != newScale) {
            BigInteger newValue = type == Entity.DATA_TYPE.DT_LONG ? BigInteger.valueOf(((BasicLong)value).getLong()) : (type == Entity.DATA_TYPE.DT_INT ? BigInteger.valueOf(((BasicInt)value).getInt()) : ((BasicDecimal128)value).unscaledValue());
            BigInteger pow = BigInteger.TEN;
            if (newScale - this.scale > 0) {
                pow = pow.pow(newScale - this.scale);
                newValue = newValue.divide(pow);
            } else {
                pow = pow.pow(this.scale - newScale);
                newValue = newValue.multiply(pow);
            }
            this.values[this.getIndex((int)row, (int)column)] = newValue;
        } else {
            this.values[this.getIndex((int)row, (int)column)] = ((BasicDecimal128)value).unscaledValue();
        }
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.DENARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DECIMAL128;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDecimal128.class;
    }

    @Override
    protected void readMatrixFromInputStream(int rows, int columns, ExtendedDataInput in) throws IOException {
        int len;
        int size = rows * columns;
        this.values = new BigInteger[size];
        long totalBytes = (long)size * 16L;
        this.scale = in.readInt();
        for (long off = 0L; off < totalBytes; off += (long)len) {
            byte[] val = new byte[16];
            len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(this.buf, 0, len);
            if (in.isLittleEndian()) {
                BasicDecimal128Matrix.reverseByteArrayEvery8Byte(this.buf);
            }
            int start = (int)(off / 16L);
            int end = len / 16;
            for (int i = 0; i < end; ++i) {
                System.arraycopy(this.buf, i * 16, val, 0, 16);
                this.values[i + start] = new BigInteger(val);
            }
        }
    }

    public static void reverseByteArrayEvery8Byte(byte[] array) {
        int start = 0;
        for (int end = start + 15; end < array.length; end += 16) {
            for (int i = 0; i < 8; ++i) {
                byte temp = array[start + i];
                array[start + i] = array[end - i];
                array[end - i] = temp;
            }
            start += 16;
        }
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeInt(this.scale);
        byte[] newArray = new byte[16 * this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            BigInteger unscaledValue = this.values[i];
            if (unscaledValue.compareTo(BIGINT_MIN_VALUE) < 0) {
                throw new RuntimeException("Decimal128 " + unscaledValue + " cannot be less than " + BIGINT_MIN_VALUE);
            }
            if (unscaledValue.compareTo(BIGINT_MAX_VALUE) > 0) {
                throw new RuntimeException("Decimal128 " + unscaledValue + " cannot exceed " + BIGINT_MAX_VALUE);
            }
            byte[] originalArray = unscaledValue.toByteArray();
            if (originalArray.length > 16) {
                throw new RuntimeException("byte length of Decimal128 " + originalArray.length + " exceed 16");
            }
            if (originalArray[0] >= 0) {
                System.arraycopy(originalArray, 0, newArray, 16 - originalArray.length + 16 * i, originalArray.length);
                continue;
            }
            System.arraycopy(originalArray, 0, newArray, 16 - originalArray.length + 16 * i, originalArray.length);
            int newaindex = i * 16;
            for (int j = 0; j < 16 - originalArray.length; ++j) {
                newArray[j + newaindex] = -1;
            }
        }
        BasicDecimal128Matrix.reverseByteArrayEvery8Byte(newArray);
        out.write(newArray);
    }
}

