/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicDecimal64;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicLong;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class BasicDecimal64Vector
extends AbstractVector {
    private int scale_ = -1;
    private long[] values;
    private int size;
    private int capaticy;
    private static final BigDecimal DECIMAL64_MIN_VALUE = new BigDecimal("-9223372036854775808");
    private static final BigDecimal DECIMAL64_MAX_VALUE = new BigDecimal("9223372036854775807");

    public BasicDecimal64Vector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicDecimal64Vector(int size, int scale) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (scale < 0 || scale > 18) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,18].");
        }
        this.scale_ = scale;
        this.values = new long[size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    BasicDecimal64Vector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new long[size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    BasicDecimal64Vector(long[] dataValue, int scale) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (scale < 0 || scale > 18) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,18].");
        }
        this.scale_ = scale;
        this.values = dataValue;
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicDecimal64Vector(String[] data, int scale) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (scale < 0 || scale > 18) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,18].");
        }
        this.scale_ = scale;
        int length = data.length;
        this.values = new long[length];
        for (int i = 0; i < length; ++i) {
            BigDecimal bd = new BigDecimal(data[i]);
            BigDecimal multipliedValue = bd.scaleByPowerOfTen(scale).setScale(0, RoundingMode.HALF_UP);
            if (!this.checkDecimal64Range(multipliedValue)) continue;
            this.values[i] = multipliedValue.longValue();
        }
        this.size = length;
        this.capaticy = length;
    }

    public BasicDecimal64Vector(Entity.DATA_FORM df, ExtendedDataInput in, int extra) throws IOException {
        super(df);
        int len;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new long[size];
        this.scale_ = extra != -1 ? extra : in.readInt();
        long totalBytes = (long)size * 8L;
        boolean little = in.isLittleEndian();
        ByteOrder bo = little ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        for (long off = 0L; off < totalBytes; off += (long)len) {
            len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(buf, 0, len);
            int start = (int)(off / 8L);
            int end = len / 8;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                long value;
                this.values[i + start] = value = byteBuffer.getLong(i * 8);
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Deprecated
    public BasicDecimal64Vector(double[] data, int scale) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (scale < 0 || scale > 18) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,18].");
        }
        this.scale_ = scale;
        long[] newIntValue = new long[data.length];
        for (int i = 0; i < data.length; ++i) {
            BigDecimal pow = new BigDecimal(1);
            for (long j = 0L; j < (long)this.scale_; ++j) {
                pow = pow.multiply(new BigDecimal(10));
            }
            BigDecimal dbvalue = new BigDecimal(Double.toString(data[i]));
            newIntValue[i] = dbvalue.multiply(pow).longValue();
        }
        this.values = newIntValue;
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        long totalBytes = (long)count * 8L;
        long off = 0L;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        while (off < totalBytes) {
            int len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(buf, 0, len);
            int end = len / 8;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getLong(i * 8);
            }
            off += (long)len;
            start += end;
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        long[] data = new long[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        out.writeInt(this.scale_);
        out.writeLongArray(data);
    }

    @Override
    public void setExtraParamForType(int scale) {
        this.scale_ = scale;
    }

    @Override
    public Vector combine(Vector vector) {
        return null;
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        long[] sub = new long[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicDecimal64Vector(sub, this.scale_);
    }

    @Override
    public int asof(Scalar value) {
        return 0;
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == Long.MIN_VALUE;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = Long.MIN_VALUE;
    }

    @Override
    public Entity get(int index) {
        return new BasicDecimal64(this.scale_, this.values[index]);
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        if (!value.getDataForm().equals((Object)Entity.DATA_FORM.DF_SCALAR) || value.getDataType() != Entity.DATA_TYPE.DT_DECIMAL64) {
            throw new RuntimeException("value type is not BasicDecimal64!");
        }
        int newScale = ((Scalar)value).getScale();
        Entity.DATA_TYPE type = value.getDataType();
        if (this.scale_ < 0) {
            this.scale_ = newScale;
        }
        if (((Scalar)value).isNull()) {
            this.values[index] = Long.MIN_VALUE;
        } else if (this.scale_ != newScale) {
            BigInteger newValue = type == Entity.DATA_TYPE.DT_LONG ? BigInteger.valueOf(((BasicLong)value).getLong()) : (type == Entity.DATA_TYPE.DT_INT ? BigInteger.valueOf(((BasicInt)value).getInt()) : BigInteger.valueOf(((BasicDecimal64)value).getLong()));
            BigInteger pow = BigInteger.valueOf(10L);
            if (newScale - this.scale_ > 0) {
                pow = pow.pow(newScale - this.scale_);
                newValue = newValue.divide(pow);
            } else {
                pow = pow.pow(this.scale_ - newScale);
                newValue = newValue.multiply(pow);
            }
            this.values[index] = newValue.intValue();
        } else {
            this.values[index] = ((BasicDecimal64)value).getLong();
        }
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDecimal64.class;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeLong(this.values[start + i]);
        }
    }

    @Override
    public int getUnitLength() {
        return 8;
    }

    public void add(String value) {
        if (this.size + 1 > this.capaticy && this.values.length > 0) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        } else if (this.values.length <= 0) {
            this.values = new long[1];
        }
        this.capaticy = this.values.length;
        if (value.equals("0.0")) {
            this.values[this.size] = 0L;
        } else if (value.equals("")) {
            this.values[this.size] = Long.MIN_VALUE;
        } else {
            BigDecimal pow = BigDecimal.TEN.pow(this.scale_);
            BigDecimal bd = new BigDecimal(value);
            if (this.checkDecimal64Range(bd)) {
                this.values[this.size] = bd.multiply(pow).longValue();
            }
        }
        ++this.size;
    }

    @Deprecated
    public void add(double value) {
        if (this.size + 1 > this.capaticy && this.values.length > 0) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        } else if (this.values.length <= 0) {
            this.values = Arrays.copyOf(this.values, this.values.length + 1);
        }
        this.capaticy = this.values.length;
        if (value == 0.0) {
            this.values[this.size] = 0L;
        } else {
            BigDecimal pow = new BigDecimal(1);
            for (long i = 0L; i < (long)this.scale_; ++i) {
                pow = pow.multiply(new BigDecimal(10));
            }
            BigDecimal dbvalue = new BigDecimal(Double.toString(value));
            this.values[this.size] = dbvalue.multiply(pow).longValue();
        }
        ++this.size;
    }

    void addRange(long[] valueList) {
        this.values = Arrays.copyOf(this.values, valueList.length + this.values.length);
        System.arraycopy(valueList, 0, this.values, this.size, valueList.length);
        this.size += valueList.length;
        this.capaticy = this.values.length;
    }

    public void addRange(String[] valueList) {
        long[] newLongValue = new long[valueList.length];
        BigDecimal pow = BigDecimal.TEN.pow(this.scale_);
        for (int i = 0; i < valueList.length; ++i) {
            BigDecimal bd = new BigDecimal(valueList[i]);
            if (!this.checkDecimal64Range(bd)) continue;
            newLongValue[i] = bd.multiply(pow).longValue();
        }
        this.values = Arrays.copyOf(this.values, newLongValue.length + this.values.length);
        System.arraycopy(newLongValue, 0, this.values, this.size, newLongValue.length);
        this.size += newLongValue.length;
        this.capaticy = this.values.length;
    }

    @Deprecated
    public void addRange(double[] valueList) {
        long[] newLongValue = new long[valueList.length];
        for (int i = 0; i < valueList.length; ++i) {
            BigDecimal pow = new BigDecimal(1);
            for (long j = 0L; j < (long)this.scale_; ++j) {
                pow = pow.multiply(new BigDecimal(10));
            }
            BigDecimal dbvalue = new BigDecimal(Double.toString(valueList[i]));
            newLongValue[i] = dbvalue.multiply(pow).longValue();
        }
        this.values = Arrays.copyOf(this.values, newLongValue.length + this.values.length);
        System.arraycopy(newLongValue, 0, this.values, this.size, newLongValue.length);
        this.size += newLongValue.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getString());
    }

    @Override
    public void Append(Vector value) throws Exception {
        if (((BasicDecimal64Vector)value).getScale() == this.scale_) {
            this.addRange(((BasicDecimal64Vector)value).getdataArray());
        } else {
            for (int i = 0; i < value.rows(); ++i) {
                this.Append((Scalar)value.get(i));
            }
        }
    }

    @JsonIgnore
    public long[] getdataArray() {
        long[] data = new long[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        return data;
    }

    public void setScale(int scale) {
        this.scale_ = scale;
    }

    public int getScale() {
        return this.scale_;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.DENARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DECIMAL64;
    }

    @Override
    public int rows() {
        return this.size;
    }

    @Override
    public int getExtraParamForType() {
        return this.scale_;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            out.putLong(this.values[indexStart + i]);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement * 8;
    }

    private boolean checkDecimal64Range(BigDecimal value) {
        return value.compareTo(DECIMAL64_MIN_VALUE) > 0 && value.compareTo(DECIMAL64_MAX_VALUE) < 0;
    }
}

