/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.DBConnection;
import com.xxdb.streaming.client.MessageDispatcher;
import com.xxdb.streaming.client.MessageParser;
import com.xxdb.streaming.client.Site;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Daemon
implements Runnable {
    private int listeningPort = 0;
    private MessageDispatcher dispatcher;
    private Thread runningThread_ = null;
    private LinkedBlockingQueue<DBConnection> connList = new LinkedBlockingQueue();
    private static final Logger log = LoggerFactory.getLogger(Daemon.class);

    public Daemon(int port, MessageDispatcher dispatcher, LinkedBlockingQueue<DBConnection> connections) {
        this.listeningPort = port;
        this.dispatcher = dispatcher;
        this.connList = connections;
    }

    public void setRunningThread(Thread runningThread) {
        this.runningThread_ = runningThread;
    }

    @Override
    public void run() {
        ServerSocket ssocket = null;
        try {
            ssocket = new ServerSocket(this.listeningPort);
            ssocket.setSoTimeout(1000);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ReconnectDetector rcDetector = new ReconnectDetector(this.dispatcher);
        Thread rcThread = new Thread(rcDetector);
        rcDetector.setRunningThread(rcThread);
        rcThread.start();
        HashSet<Socket> threadSet = new HashSet<Socket>();
        while (!this.runningThread_.isInterrupted()) {
            try {
                Socket socket = null;
                MessageParser.DBConnectionAndSocket dBConnectionAndSocket = new MessageParser.DBConnectionAndSocket();
                if (this.listeningPort > 0) {
                    dBConnectionAndSocket.socket = socket = ssocket.accept();
                    dBConnectionAndSocket.conn = null;
                } else {
                    DBConnection conn = this.connList.take();
                    socket = conn.getSocket();
                    dBConnectionAndSocket.socket = null;
                    dBConnectionAndSocket.conn = conn;
                }
                socket.setKeepAlive(true);
                MessageParser listener = new MessageParser(dBConnectionAndSocket, this.dispatcher, this.listeningPort);
                Thread listeningThread = new Thread(listener);
                threadSet.add(socket);
                listeningThread.start();
            }
            catch (Exception ex) {
                try {
                    if (this.runningThread_.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException iEx) {
                    break;
                }
            }
        }
        try {
            assert (ssocket != null);
            ssocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        rcThread.interrupt();
        try {
            ssocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Iterator it = threadSet.iterator();
        while (it.hasNext()) {
            try {
                ((Socket)it.next()).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class ReconnectDetector
    implements Runnable {
        MessageDispatcher dispatcher = null;
        private Thread pThread = null;

        public ReconnectDetector(MessageDispatcher d) {
            this.dispatcher = d;
        }

        public void setRunningThread(Thread runningThread) {
            this.pThread = runningThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.pThread.isInterrupted()) {
                Set<String> waitReconnectTopic;
                for (String string : this.dispatcher.getAllReconnectSites()) {
                    if (this.dispatcher.getNeedReconnect(string) == 1) {
                        Site s = this.dispatcher.getSiteByName(string);
                        this.dispatcher.activeCloseConnection(s);
                        String lastTopic = "";
                        for (String topic : this.dispatcher.getAllTopicsBySite(string)) {
                            log.info("try to reconnect topic " + topic);
                            this.dispatcher.tryReconnect(topic);
                            lastTopic = topic;
                        }
                        this.dispatcher.setNeedReconnect(lastTopic, 2);
                        continue;
                    }
                    long ts = this.dispatcher.getReconnectTimestamp(string);
                    if (System.currentTimeMillis() < ts + 3000L) continue;
                    Site s = this.dispatcher.getSiteByName(string);
                    this.dispatcher.activeCloseConnection(s);
                    for (String topic : this.dispatcher.getAllTopicsBySite(string)) {
                        log.info("try to reconnect topic " + topic);
                        this.dispatcher.tryReconnect(topic);
                    }
                    this.dispatcher.setReconnectTimestamp(string, System.currentTimeMillis());
                }
                Set<String> set = waitReconnectTopic = this.dispatcher.getAllReconnectTopic();
                synchronized (set) {
                    for (String topic : waitReconnectTopic) {
                        this.dispatcher.tryReconnect(topic);
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }
}

