/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.SymbolBase;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SymbolBaseCollection {
    private Map<Integer, SymbolBase> symbaseMap = new HashMap<Integer, SymbolBase>();
    private Map<SymbolBase, Integer> existingBases;
    private SymbolBase lastSymbase = null;

    public SymbolBase add(ExtendedDataInput in) throws IOException {
        int id = in.readInt();
        if (this.symbaseMap.containsKey(id)) {
            int size = in.readInt();
            if (size != 0) {
                throw new IOException("Invalid symbol base.");
            }
            this.lastSymbase = this.symbaseMap.get(id);
        } else {
            SymbolBase cur = new SymbolBase(id, in);
            this.symbaseMap.put(id, cur);
            this.lastSymbase = cur;
        }
        return this.lastSymbase;
    }

    public void write(ExtendedDataOutput out, SymbolBase base) throws IOException {
        boolean existing = false;
        int id = 0;
        if (this.existingBases == null) {
            this.existingBases = new HashMap<SymbolBase, Integer>();
            this.existingBases.put(base, 0);
        } else {
            Integer curId = this.existingBases.get(base);
            if (curId != null) {
                existing = true;
                id = curId;
            } else {
                id = this.existingBases.size();
                this.existingBases.put(base, id);
            }
        }
        out.writeInt(id);
        if (existing) {
            out.writeInt(0);
        } else {
            int size = base.size();
            out.writeInt(size);
            for (int i = 0; i < size; ++i) {
                out.writeString(base.getSymbol(i));
            }
        }
    }

    public SymbolBase getLastSymbolBase() {
        return this.lastSymbase;
    }

    public void clear() {
        this.symbaseMap.clear();
        this.lastSymbase = null;
    }
}

