/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractMatrix;
import com.xxdb.data.BasicDecimal32;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class BasicDecimal32Matrix
extends AbstractMatrix {
    private int[] values;
    private static final int MIN_VALUE = Integer.MIN_VALUE;
    private static final int MAX_VALUE = Integer.MAX_VALUE;

    public BasicDecimal32Matrix(int rows, int columns, int scale) {
        super(rows, columns, scale);
        if (scale < 0 || scale > 9) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,9].");
        }
        this.values = new int[rows * columns];
    }

    public BasicDecimal32Matrix(int rows, int columns, List<?> listOfArrays, int scale) throws Exception {
        super(rows, columns);
        if (scale < 0 || scale > 9) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,9].");
        }
        this.scale = scale;
        this.values = new int[rows * columns];
        if (listOfArrays == null || listOfArrays.size() != columns) {
            throw new Exception("input list of arrays does not have " + columns + " columns");
        }
        for (int i = 0; i < columns; ++i) {
            Object[] newArray;
            Object array = listOfArrays.get(i);
            if (array instanceof String[]) {
                newArray = (String[])array;
                int[] tempArr = new int[newArray.length];
                if (newArray.length == 0 || newArray.length != rows) {
                    throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
                }
                for (int j = 0; j < newArray.length; ++j) {
                    BigDecimal bd = new BigDecimal(newArray[j]);
                    BigDecimal multipliedValue = bd.scaleByPowerOfTen(scale).setScale(0, RoundingMode.HALF_UP);
                    if (multipliedValue.intValue() <= Integer.MIN_VALUE || multipliedValue.intValue() >= Integer.MAX_VALUE) continue;
                    tempArr[j] = multipliedValue.intValue();
                }
                System.arraycopy(tempArr, 0, this.values, i * rows, rows);
                continue;
            }
            if (array instanceof int[]) {
                newArray = (int[])listOfArrays.get(i);
                if (newArray.length == 0 || newArray.length != rows) {
                    throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
                }
                for (int j = 0; j < newArray.length; ++j) {
                    newArray[j] = newArray[j] * (int)Math.pow(10.0, this.scale);
                }
                System.arraycopy(newArray, 0, this.values, i * rows, rows);
                continue;
            }
            throw new RuntimeException("BasicDecimal32Matrix 'listOfArrays' param only support String[] or int[].");
        }
    }

    public BasicDecimal32Matrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    @Override
    public boolean isNull(int row, int column) {
        return this.values[this.getIndex(row, column)] == Integer.MIN_VALUE;
    }

    @Override
    public void setNull(int row, int column) {
        this.values[this.getIndex((int)row, (int)column)] = Integer.MIN_VALUE;
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicDecimal32(new int[]{this.scale, this.values[this.getIndex(row, column)]});
    }

    public void set(int row, int column, Entity value) {
        if (!value.getDataForm().equals((Object)Entity.DATA_FORM.DF_SCALAR) || value.getDataType() != Entity.DATA_TYPE.DT_DECIMAL32) {
            throw new RuntimeException("The value type is not BasicDecimal32!");
        }
        int newScale = ((Scalar)value).getScale();
        if (this.scale < 0) {
            this.scale = newScale;
        }
        if (((Scalar)value).isNull()) {
            this.values[this.getIndex((int)row, (int)column)] = Integer.MIN_VALUE;
        } else if (this.scale != newScale) {
            BigInteger newValue = BigInteger.valueOf(((BasicDecimal32)value).getInt());
            BigInteger pow = BigInteger.valueOf(10L);
            if (newScale - this.scale > 0) {
                pow = pow.pow(newScale - this.scale);
                newValue = newValue.divide(pow);
            } else {
                pow = pow.pow(this.scale - newScale);
                newValue = newValue.multiply(pow);
            }
            this.values[this.getIndex((int)row, (int)column)] = newValue.intValue();
        } else {
            this.values[this.getIndex((int)row, (int)column)] = ((BasicDecimal32)value).getInt();
        }
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.DENARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DECIMAL32;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDecimal32.class;
    }

    @Override
    protected void readMatrixFromInputStream(int rows, int columns, ExtendedDataInput in) throws IOException {
        int len;
        int size = rows * columns;
        this.values = new int[size];
        long totalBytes = (long)size * 4L;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        this.scale = in.readInt();
        for (long off = 0L; off < totalBytes; off += (long)len) {
            len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int start = (int)(off / 4L);
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getInt(i * 4);
            }
        }
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeInt(this.scale);
        out.writeIntArray(this.values);
    }
}

