/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicFloat;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;

public class BasicFloatVector
extends AbstractVector {
    private float[] values;
    private int size;
    private int capaticy;

    public BasicFloatVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicFloatVector(List<Float> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new float[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i) != null ? list.get(i).floatValue() : -3.4028235E38f;
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicFloatVector(float[] array) {
        this(array, true);
    }

    public BasicFloatVector(float[] array, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = copy ? (float[])array.clone() : array;
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicFloatVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new float[size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicFloatVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new float[size];
        long totalBytes = (long)size * 4L;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        for (long off = 0L; off < totalBytes; off += (long)len) {
            len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(buf, 0, len);
            int start = (int)(off / 4L);
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getFloat(i * 4);
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        long totalBytes = (long)count * 4L;
        long off = 0L;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        while (off < totalBytes) {
            int len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(buf, 0, len);
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getFloat(i * 4);
            }
            off += (long)len;
            start += end;
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeFloat(this.values[start + i]);
        }
    }

    @Override
    public int getUnitLength() {
        return 4;
    }

    public void add(float value) {
        if (this.size + 1 > this.capaticy && this.values.length > 0) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        } else if (this.values.length <= 0) {
            this.values = Arrays.copyOf(this.values, this.values.length + 1);
        }
        this.capaticy = this.values.length;
        this.values[this.size] = value;
        ++this.size;
    }

    public void addRange(float[] valueList) {
        this.values = Arrays.copyOf(this.values, valueList.length + this.values.length);
        System.arraycopy(valueList, 0, this.values, this.size, valueList.length);
        this.size += valueList.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().floatValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicFloatVector)value).getdataArray());
    }

    public float[] getdataArray() {
        float[] data = new float[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        return data;
    }

    @Override
    public Entity get(int index) {
        return new BasicFloat(this.values[index]);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        float[] sub = new float[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicFloatVector(sub, false);
    }

    public float getFloat(int index) {
        return this.values[index];
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        this.values[index] = ((Scalar)value).isNull() ? -3.4028235E38f : ((Scalar)value).getNumber().floatValue();
    }

    public void setFloat(int index, float value) {
        this.values[index] = value;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicFloatVector v = (BasicFloatVector)vector;
        int newSize = this.rows() + v.rows();
        float[] newValue = new float[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicFloatVector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == -3.4028235E38f;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = -3.4028235E38f;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.FLOATING;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_FLOAT;
    }

    @Override
    public int rows() {
        return this.size;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicFloat.class;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        float[] data = new float[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        out.writeFloatArray(data);
    }

    @Override
    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        float[] data = new float[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        for (float val : data) {
            buffer.putFloat(val);
        }
        return buffer;
    }

    @Override
    public int asof(Scalar value) {
        float target;
        try {
            target = value.getNumber().floatValue();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        int start = 0;
        int end = this.size - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.values[mid] <= target) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return end;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            out.putFloat(this.values[indexStart + i]);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement * 4;
    }

    public float[] getValues() {
        return this.values;
    }
}

