/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicLong;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;

public class BasicNanoTime
extends BasicLong {
    public BasicNanoTime(LocalDateTime value) {
        super(Utils.countNanoseconds(value.toLocalTime()));
    }

    public BasicNanoTime(LocalTime value) {
        super(Utils.countNanoseconds(value));
    }

    public BasicNanoTime(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public BasicNanoTime(long value) {
        super(value);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_NANOTIME;
    }

    public LocalTime getNanoTime() {
        if (this.isNull()) {
            return null;
        }
        return Utils.parseNanoTime(this.getLong());
    }

    @Override
    public Temporal getTemporal() throws Exception {
        return this.getNanoTime();
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        return this.getNanoTime().format(DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSSSSS"));
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return "\"" + this.getString() + "\"";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BasicNanoTime) || o == null) {
            return false;
        }
        return this.getLong() == ((BasicNanoTime)o).getLong();
    }
}

