/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.compression;

import com.xxdb.compression.AbstractDecoder;
import com.xxdb.io.BigEndianDataInputStream;
import com.xxdb.io.DdbByteArrayInputStream;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.LittleEndianDataInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.LinkedList;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;

public class LZ4Decoder
extends AbstractDecoder {
    private LZ4SafeDecompressor decompressor = null;

    @Override
    public ExtendedDataInput decompress(DataInput in, int length, int unitLength, int elementCount, boolean isLittleEndian, int extra, int type, short scale) throws IOException {
        if (this.decompressor == null) {
            LZ4Factory factory = LZ4Factory.fastestInstance();
            this.decompressor = factory.safeDecompressor();
        }
        byte[] lengthMsg = this.createLZ4ColumnVector(elementCount, isLittleEndian, extra, type, scale).array();
        LinkedList<byte[]> buffers = new LinkedList<byte[]>();
        buffers.add(lengthMsg);
        while (length > 0) {
            int blockSize = in.readInt();
            if (blockSize < 0) {
                blockSize &= Integer.MAX_VALUE;
            }
            if ((blockSize = Math.min(blockSize, length -= 4)) == 0) break;
            byte[] src = new byte[blockSize];
            in.readFully(src);
            byte[] ret = this.decompressor.decompress(src, 65536);
            buffers.add(ret);
            length -= blockSize;
        }
        return isLittleEndian ? new LittleEndianDataInputStream(new DdbByteArrayInputStream(buffers)) : new BigEndianDataInputStream(new DdbByteArrayInputStream(buffers));
    }
}

