/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.compression;

import com.xxdb.compression.Encoder;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;

public class LZ4Encoder
implements Encoder {
    LZ4Compressor compressor;
    private static final int DEFAULT_BLOCK_SIZE = 65536;

    @Override
    public ByteBuffer compress(AbstractVector input, int elementCount, int unitLength, int maxCompressedLength, ByteBuffer out) throws IOException {
        boolean isLittleEndian;
        if (this.compressor == null) {
            LZ4Factory factory = LZ4Factory.fastestInstance();
            this.compressor = factory.fastCompressor();
        }
        int byteCount = 0;
        int dataCount = input.rows();
        int dataIndex = 0;
        ByteBuffer dataBufer = ByteBuffer.allocate(65536);
        boolean bl = isLittleEndian = out.order() == ByteOrder.LITTLE_ENDIAN;
        if (isLittleEndian) {
            dataBufer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            dataBufer.order(ByteOrder.BIG_ENDIAN);
        }
        AbstractVector.NumElementAndPartial numElementAndPartial = new AbstractVector.NumElementAndPartial(0, 0);
        while (dataCount > dataIndex) {
            int blockSize;
            for (int readBytes = input.serialize(dataIndex, numElementAndPartial.partial, dataCount - dataIndex, numElementAndPartial, dataBufer); readBytes > 0; readBytes -= blockSize) {
                blockSize = Math.min(65536, dataBufer.position());
                byte[] srcBuf = new byte[blockSize];
                dataBufer.flip();
                dataBufer.get(srcBuf, 0, blockSize);
                byte[] ret = this.compressor.compress(srcBuf);
                if (ret.length + 4 > out.remaining()) {
                    out = Utils.reAllocByteBuffer(out, (out.position() + ret.length + 4) * 2);
                }
                out.putInt(ret.length);
                out.put(ret);
                byteCount += ret.length + 32;
            }
            dataIndex += numElementAndPartial.numElement;
            dataBufer.clear();
        }
        return out;
    }
}

