/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicIntMatrix;
import com.xxdb.data.BasicMinute;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalTime;
import java.util.List;

public class BasicMinuteMatrix
extends BasicIntMatrix {
    public BasicMinuteMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public BasicMinuteMatrix(int rows, int columns, List<int[]> listOfArrays) throws Exception {
        super(rows, columns, listOfArrays);
    }

    public BasicMinuteMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setMinute(int row, int column, LocalTime value) {
        this.setInt(row, column, Utils.countMinutes(value));
    }

    public LocalTime getMinute(int row, int column) {
        return Utils.parseMinute(this.getInt(row, column));
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicMinute(this.getInt(row, column));
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_MINUTE;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicMinute.class;
    }
}

