/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client.cep;

import com.xxdb.comm.ErrorCodeInfo;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicDecimal128;
import com.xxdb.data.BasicDecimal128Vector;
import com.xxdb.data.BasicDecimal32;
import com.xxdb.data.BasicDecimal32Vector;
import com.xxdb.data.BasicDecimal64;
import com.xxdb.data.BasicDecimal64Vector;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.LittleEndianDataInputStream;
import com.xxdb.io.LittleEndianDataOutputStream;
import com.xxdb.streaming.client.BasicMessage;
import com.xxdb.streaming.client.IMessage;
import com.xxdb.streaming.client.cep.AttributeSerializer;
import com.xxdb.streaming.client.cep.EventInfo;
import com.xxdb.streaming.client.cep.EventSchema;
import com.xxdb.streaming.client.cep.EventSchemaEx;
import com.xxdb.streaming.client.cep.FastArrayAttributeSerializer;
import com.xxdb.streaming.client.cep.ScalarAttributeSerializer;
import com.xxdb.streaming.client.cep.StringScalarAttributeSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EventHandler {
    private Map<String, EventInfo> eventInfos = new HashMap<String, EventInfo>();
    private boolean isNeedEventTime = false;
    private int outputColNums = 0;
    private int commonKeySize = 0;

    public EventHandler(List<EventSchema> eventSchemas, List<String> eventTimeKeys, List<String> commonKeys) {
        StringBuilder errMsg;
        String funcName = "createEventSender";
        if (Objects.isNull(eventSchemas) || eventSchemas.isEmpty()) {
            throw new IllegalArgumentException("eventSchema must be non-null and non-empty.");
        }
        ArrayList<EventSchema> expandEventSchemas = new ArrayList<EventSchema>(eventSchemas);
        for (EventSchema event : expandEventSchemas) {
            if (Utils.isEmpty(event.getEventType())) {
                throw new IllegalArgumentException("eventType must be non-empty.");
            }
            HashSet<String> set = new HashSet<String>();
            for (String fieldName : event.getFieldNames()) {
                if (Utils.isEmpty(fieldName)) {
                    throw new IllegalArgumentException("fieldName must be non-null and non-empty.");
                }
                if (set.add(fieldName)) continue;
                throw new IllegalArgumentException("EventSchema cannot has duplicated fieldName in fieldNames.");
            }
            for (Entity.DATA_FORM fieldForm : event.getFieldForms()) {
                if (Objects.isNull((Object)fieldForm)) {
                    throw new IllegalArgumentException("fieldForm must be non-null.");
                }
                if (fieldForm == Entity.DATA_FORM.DF_SCALAR || fieldForm == Entity.DATA_FORM.DF_VECTOR) continue;
                throw new IllegalArgumentException("fieldForm only can be DF_SCALAR or DF_VECTOR.");
            }
            int length = event.getFieldNames().size();
            if (event.getFieldExtraParams().isEmpty()) {
                event.setFieldExtraParams(Collections.nCopies(length, 0));
            }
            if (length == 0) {
                throw new IllegalArgumentException("eventKey in eventSchema must be non-empty.");
            }
            if (!event.getFieldExtraParams().isEmpty() && length != event.getFieldExtraParams().size() || length != event.getFieldForms().size() || length != event.getFieldTypes().size()) {
                throw new IllegalArgumentException("the number of eventKey, eventTypes, eventForms and eventExtraParams (if set) must have the same length.");
            }
            if (!Objects.nonNull(event.getFieldExtraParams()) || event.getFieldExtraParams().isEmpty()) continue;
            for (int i = 0; i < event.getFieldTypes().size(); ++i) {
                Entity.DATA_TYPE fieldType = event.getFieldTypes().get(i);
                Integer scale = event.getFieldExtraParams().get(i);
                if (fieldType == Entity.DATA_TYPE.DT_DECIMAL32 && (scale < 0 || scale > 9)) {
                    throw new IllegalArgumentException((Object)((Object)fieldType) + " scale " + scale + " is out of bounds, it must be in [0,9].");
                }
                if (fieldType == Entity.DATA_TYPE.DT_DECIMAL64 && (scale < 0 || scale > 18)) {
                    throw new IllegalArgumentException((Object)((Object)fieldType) + " scale " + scale + " is out of bounds, it must be in [0,18].");
                }
                if (fieldType != Entity.DATA_TYPE.DT_DECIMAL128 || scale >= 0 && scale <= 38) continue;
                throw new IllegalArgumentException((Object)((Object)fieldType) + " scale " + scale + " is out of bounds, it must be in [0,38].");
            }
        }
        int eventNum = eventSchemas.size();
        List<String> expandTimeKeys = new ArrayList<String>();
        if (!eventTimeKeys.isEmpty()) {
            if (eventTimeKeys.size() == 1) {
                expandTimeKeys = Collections.nCopies(eventNum, eventTimeKeys.get(0));
            } else {
                if (eventTimeKeys.size() != eventNum) {
                    throw new IllegalArgumentException(funcName + "the number of eventTimeKey is inconsistent with the number of events in eventSchemas.");
                }
                expandTimeKeys = new ArrayList<String>(eventTimeKeys);
            }
            this.isNeedEventTime = true;
        }
        if (!this.checkSchema(expandEventSchemas, expandTimeKeys, commonKeys, errMsg = new StringBuilder())) {
            throw new IllegalArgumentException(errMsg.toString());
        }
        this.commonKeySize = commonKeys.size();
    }

    public boolean checkInputTable(String tableName, BasicTable outputTable, StringBuilder errMsg) {
        int n = this.outputColNums = this.isNeedEventTime ? 3 + this.commonKeySize : 2 + this.commonKeySize;
        if (this.outputColNums != outputTable.columns()) {
            errMsg.append("Incompatible ").append(tableName).append(" columns, expected: ").append(this.outputColNums).append(", got: ").append(outputTable.columns());
            return false;
        }
        int colIdx = 0;
        if (this.isNeedEventTime && Entity.typeToCategory(outputTable.getColumn(0).getDataType()) != Entity.DATA_CATEGORY.TEMPORAL) {
            errMsg.append("First column of outputTable should be temporal if specified eventTimeKey.");
            return false;
        }
        int n2 = ++colIdx;
        int typeIdx = n2;
        int n3 = ++colIdx;
        ++colIdx;
        int blobIdx_ = n3;
        if (outputTable.getColumn(typeIdx).getDataType() != Entity.DATA_TYPE.DT_STRING && outputTable.getColumn(typeIdx).getDataType() != Entity.DATA_TYPE.DT_SYMBOL) {
            errMsg.append("The eventType column must be a string or symbol column");
            return false;
        }
        if (outputTable.getColumn(blobIdx_).getDataType() != Entity.DATA_TYPE.DT_BLOB) {
            errMsg.append("The event column must be a blob column");
            return false;
        }
        return true;
    }

    public boolean serializeEvent(String eventType, List<Entity> attributes, List<Entity> serializedEvent, StringBuilder errMsg) {
        EventInfo info = this.eventInfos.get(eventType);
        if (info == null) {
            errMsg.append("unknown eventType ").append(eventType);
            return false;
        }
        if (attributes.size() != info.getAttributeSerializers().size()) {
            errMsg.append("the number of event values does not match ").append(eventType);
            return false;
        }
        for (int i = 0; i < attributes.size(); ++i) {
            Entity attribute;
            if (info.getEventSchema().getSchema().getFieldTypes().get(i) != attributes.get(i).getDataType()) {
                if (info.getEventSchema().getSchema().getFieldTypes().get(i) == Entity.DATA_TYPE.DT_SYMBOL && attributes.get(i).getDataType() == Entity.DATA_TYPE.DT_STRING) continue;
                errMsg.append("Expected type for the field ").append(info.getEventSchema().getSchema().getFieldNames().get(i)).append(" of ").append(eventType).append(":").append(info.getEventSchema().getSchema().getFieldTypes().get(i).toString()).append(", but now it is ").append(attributes.get(i).getDataType().toString());
                return false;
            }
            if (info.getEventSchema().getSchema().getFieldForms().get(i) != attributes.get(i).getDataForm()) {
                errMsg.append("Expected form for the field ").append(info.getEventSchema().getSchema().getFieldNames().get(i)).append(" of ").append(eventType).append(":").append(", but now it is ").append(attributes.get(i).getDataForm().toString());
                return false;
            }
            EventInfo eventInfo = this.eventInfos.get(eventType);
            EventSchemaEx eventSchema = eventInfo.getEventSchema();
            EventSchema schema = eventSchema.getSchema();
            List<Integer> fieldExtraParams = schema.getFieldExtraParams();
            if (fieldExtraParams.isEmpty() || !((attribute = attributes.get(i)).isScalar() ? attribute.getDataType() == Entity.DATA_TYPE.DT_DECIMAL32 && ((BasicDecimal32)attribute).getScale() != fieldExtraParams.get(i).intValue() || attribute.getDataType() == Entity.DATA_TYPE.DT_DECIMAL64 && ((BasicDecimal64)attribute).getScale() != fieldExtraParams.get(i).intValue() || attribute.getDataType() == Entity.DATA_TYPE.DT_DECIMAL128 && ((BasicDecimal128)attribute).getScale() != fieldExtraParams.get(i).intValue() : attribute.isVector() && (attribute.getDataType() == Entity.DATA_TYPE.DT_DECIMAL32 && ((BasicDecimal32Vector)attribute).getScale() != fieldExtraParams.get(i).intValue() || attribute.getDataType() == Entity.DATA_TYPE.DT_DECIMAL64 && ((BasicDecimal64Vector)attribute).getScale() != fieldExtraParams.get(i).intValue() || attribute.getDataType() == Entity.DATA_TYPE.DT_DECIMAL128 && ((BasicDecimal128Vector)attribute).getScale() != fieldExtraParams.get(i).intValue()))) continue;
            throw new IllegalArgumentException("The decimal attribute' scale doesn't match to schema fieldExtraParams scale.");
        }
        if (this.isNeedEventTime) {
            try {
                serializedEvent.add(attributes.get(info.getEventSchema().getTimeIndex()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            serializedEvent.add(new BasicString(eventType));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
        LittleEndianDataOutputStream out = new LittleEndianDataOutputStream(memoryStream);
        for (int i = 0; i < attributes.size(); ++i) {
            try {
                info.getAttributeSerializers().get(i).serialize(attributes.get(i), out);
                continue;
            }
            catch (IOException e) {
                errMsg.append("Failed to serialize the field ").append(info.getEventSchema().getSchema().getFieldNames().get(i)).append(", ").append(e);
                throw new RuntimeException(e);
            }
        }
        try {
            serializedEvent.add(new BasicString(memoryStream.toByteArray(), true));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (int commonIndex : info.getEventSchema().getCommonKeyIndex()) {
            try {
                serializedEvent.add(attributes.get(commonIndex));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public boolean deserializeEvent(List<IMessage> msgs, List<String> eventTypes, List<List<Entity>> attributes, ErrorCodeInfo errorInfo) {
        int x = 0;
        for (IMessage msg : msgs) {
            ++x;
            Entity obj = ((BasicMessage)msg).getMsg();
            int eventTypeIndex = this.isNeedEventTime ? 1 : 0;
            int blobIndex = this.isNeedEventTime ? 2 : 1;
            Entity eventType = ((BasicAnyVector)obj).get(eventTypeIndex);
            Entity blob = ((BasicAnyVector)obj).get(blobIndex);
            EventInfo eventInfo = this.eventInfos.get(eventType.getString());
            if (eventInfo == null) {
                errorInfo.set(ErrorCodeInfo.Code.EC_InvalidParameter, "Unknown eventType" + eventType);
                return false;
            }
            byte[] blobValues = ((BasicString)blob).getBlobValue();
            ByteArrayInputStream memoryStream = new ByteArrayInputStream(blobValues);
            LittleEndianDataInputStream input = new LittleEndianDataInputStream(memoryStream);
            EventSchema schema = eventInfo.getEventSchema().getSchema();
            int attrCount = schema.getFieldTypes().size();
            ArrayList<Entity> datas = new ArrayList<Entity>(attrCount);
            for (int i = 0; i < attrCount; ++i) {
                Entity.DATA_FORM form = schema.getFieldForms().get(i);
                Entity.DATA_TYPE type = schema.getFieldTypes().get(i);
                int extraParam = Objects.nonNull(schema.getFieldExtraParams().get(i)) ? schema.getFieldExtraParams().get(i) : -1;
                try {
                    if (form == Entity.DATA_FORM.DF_SCALAR) {
                        if (type == Entity.DATA_TYPE.DT_ANY) {
                            datas.add(this.deserializeAny(type, form, input));
                        } else {
                            datas.add(this.deserializeScalar(type, extraParam, input));
                        }
                    } else if (form == Entity.DATA_FORM.DF_VECTOR) {
                        if (type.getValue() < 64 && type != Entity.DATA_TYPE.DT_SYMBOL && type != Entity.DATA_TYPE.DT_STRING) {
                            datas.add(this.deserializeFastArray(type, extraParam, input));
                        } else {
                            datas.add(this.deserializeAny(type, form, input));
                        }
                    } else {
                        datas.add(this.deserializeAny(type, form, input));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (datas.get(i) != null) continue;
                errorInfo.set(ErrorCodeInfo.Code.EC_InvalidObject, "Deserialize blob error.");
                return false;
            }
            eventTypes.add(eventType.getString());
            attributes.add(datas);
        }
        return true;
    }

    private boolean checkSchema(List<EventSchema> eventSchemas, List<String> expandTimeKeys, List<String> commonKeys, StringBuilder errMsg) {
        int index = 0;
        for (EventSchema schema : eventSchemas) {
            if (this.eventInfos.containsKey(schema.getEventType())) {
                errMsg.append("EventType must be unique.");
                return false;
            }
            EventSchemaEx schemaEx = new EventSchemaEx();
            schemaEx.setSchema(schema);
            if (this.isNeedEventTime) {
                int timeIndex = schema.getFieldNames().indexOf(expandTimeKeys.get(index));
                if (timeIndex == -1) {
                    errMsg.append("Event ").append(schema.getEventType()).append(" doesn't contain eventTimeKey ").append(expandTimeKeys.get(index)).append(".");
                    return false;
                }
                schemaEx.setTimeIndex(timeIndex);
            }
            for (String commonKey : commonKeys) {
                int commonKeyIndex = schema.getFieldNames().indexOf(commonKey);
                if (commonKeyIndex == -1) {
                    errMsg.append("Event ").append(schema.getEventType()).append(" doesn't contain commonKey ").append(commonKey);
                    return false;
                }
                schemaEx.getCommonKeyIndex().add(commonKeyIndex);
            }
            ArrayList<AttributeSerializer> serls = new ArrayList<AttributeSerializer>();
            int length = schema.getFieldNames().size();
            for (int j = 0; j < length; ++j) {
                Entity.DATA_TYPE type = schema.getFieldTypes().get(j);
                Entity.DATA_FORM form = schema.getFieldForms().get(j);
                if (Objects.isNull((Object)type)) {
                    errMsg.append("fieldType must be non-null.");
                    return false;
                }
                if (type.getValue() < Entity.DATA_TYPE.DT_VOID.getValue() || type.getValue() > Entity.DATA_TYPE.DT_DECIMAL128_ARRAY.getValue()) {
                    errMsg.append("Invalid data type for the field " + schema.getFieldNames().get(j) + " of event " + schema.getEventType());
                    return false;
                }
                if ((form == Entity.DATA_FORM.DF_SCALAR || form == Entity.DATA_FORM.DF_VECTOR) && type.getValue() < Entity.DATA_TYPE.DT_DECIMAL128_ARRAY.getValue() && type != Entity.DATA_TYPE.DT_ANY) {
                    if (type.getValue() > 0) {
                        if (form == Entity.DATA_FORM.DF_SCALAR) {
                            serls.add(new ScalarAttributeSerializer(1));
                            continue;
                        }
                        serls.add(new FastArrayAttributeSerializer(1));
                        continue;
                    }
                    int unitLen = AbstractVector.getUnitLength(type);
                    if (type == Entity.DATA_TYPE.DT_SYMBOL) {
                        unitLen = -1;
                    }
                    if (unitLen > 0) {
                        if (form == Entity.DATA_FORM.DF_SCALAR) {
                            serls.add(new ScalarAttributeSerializer(unitLen));
                            continue;
                        }
                        serls.add(new FastArrayAttributeSerializer(unitLen));
                        continue;
                    }
                    if (unitLen < 0 && form != Entity.DATA_FORM.DF_VECTOR) {
                        serls.add(new StringScalarAttributeSerializer(type == Entity.DATA_TYPE.DT_BLOB));
                        continue;
                    }
                }
                serls.add(new AttributeSerializer(0, form));
            }
            EventInfo info = new EventInfo(serls, schemaEx);
            this.eventInfos.put(schema.getEventType(), info);
            ++index;
        }
        return true;
    }

    private Entity deserializeScalar(Entity.DATA_TYPE type, int extraParam, ExtendedDataInput input) throws IOException {
        BasicEntityFactory factory = new BasicEntityFactory();
        if (type == Entity.DATA_TYPE.DT_DECIMAL32) {
            return new BasicDecimal32(input, extraParam);
        }
        if (type == Entity.DATA_TYPE.DT_DECIMAL64) {
            return new BasicDecimal64(input, extraParam);
        }
        if (type == Entity.DATA_TYPE.DT_DECIMAL128) {
            return new BasicDecimal128(input, extraParam);
        }
        return factory.createEntity(Entity.DATA_FORM.DF_SCALAR, type, input, false);
    }

    private Entity deserializeFastArray(Entity.DATA_TYPE type, int extraParam, ExtendedDataInput input) throws IOException {
        BasicEntityFactory factory = new BasicEntityFactory();
        input.readShort();
        return factory.createEntity(Entity.DATA_FORM.DF_VECTOR, type, input, false);
    }

    private Entity deserializeAny(Entity.DATA_TYPE type, Entity.DATA_FORM form, ExtendedDataInput input) throws IOException {
        BasicEntityFactory factory = new BasicEntityFactory();
        return factory.createEntity(form, type, input, false);
    }
}

