/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.compression;

import com.xxdb.compression.DeltaOfDeltaBlockEncoder;
import com.xxdb.compression.Encoder;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DeltaOfDeltaEncoder
implements Encoder {
    private static final int DEFAULT_BLOCK_SIZE = 65536;

    @Override
    public ByteBuffer compress(AbstractVector in, int elementCount, int unitLength, int maxCompressedLength, ByteBuffer out) throws IOException {
        boolean isLittleEndian;
        DeltaOfDeltaBlockEncoder blockEncoder = new DeltaOfDeltaBlockEncoder(unitLength);
        int count = 0;
        int dataCount = in.rows();
        int dataIndex = 0;
        ByteBuffer dataBufer = ByteBuffer.allocate(65536);
        boolean bl = isLittleEndian = out.order() == ByteOrder.LITTLE_ENDIAN;
        if (isLittleEndian) {
            dataBufer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            dataBufer.order(ByteOrder.BIG_ENDIAN);
        }
        AbstractVector.NumElementAndPartial numElementAndPartial = new AbstractVector.NumElementAndPartial(0, 0);
        while (dataCount > dataIndex) {
            int targetNum = Math.min(dataCount - dataIndex, 65536 / unitLength);
            int readBytes = in.serialize(dataIndex, numElementAndPartial.partial, targetNum, numElementAndPartial, dataBufer);
            dataIndex += numElementAndPartial.numElement;
            while (readBytes > 0) {
                int blockSize = Math.min(readBytes, 65536);
                long[] compressed = blockEncoder.compress(dataBufer, blockSize);
                out.putInt(compressed.length * 8);
                for (long l : compressed) {
                    if (out.remaining() < 8) {
                        out = Utils.reAllocByteBuffer(out, out.capacity() * 2);
                    }
                    out.putLong(l);
                }
                count += 4 + compressed.length * 8;
                readBytes -= blockSize;
                dataBufer.clear();
            }
        }
        return out;
    }
}

