/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicByte;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class BasicByteVector
extends AbstractVector {
    private byte[] values;
    private int size;
    private int capaticy;

    public BasicByteVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicByteVector(List<Byte> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i) != null ? list.get(i) : (byte)-128;
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicByteVector(byte[] array) {
        this(array, true);
    }

    protected BasicByteVector(byte[] array, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = copy ? (byte[])array.clone() : array;
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicByteVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new byte[size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicByteVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new byte[size];
        for (int off = 0; off < size; off += len) {
            len = Math.min(4096, size - off);
            in.readFully(this.values, off, len);
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        in.readFully(this.values, start, count);
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeByte(this.values[start + i]);
        }
    }

    @Override
    public Vector combine(Vector vector) {
        BasicByteVector v = (BasicByteVector)vector;
        int newSize = this.rows() + v.rows();
        byte[] newValue = new byte[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicByteVector(newValue);
    }

    @Override
    public Entity get(int index) {
        return new BasicByte(this.values[index]);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        byte[] sub = new byte[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicByteVector(sub, false);
    }

    public byte getByte(int index) {
        return this.values[index];
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        this.values[index] = ((Scalar)value).isNull() ? -128 : ((Scalar)value).getNumber().byteValue();
    }

    public void setByte(int index, byte value) {
        this.values[index] = value;
    }

    @Override
    public int hashBucket(int index, int buckets) {
        byte value = this.values[index];
        if (value >= 0) {
            return value % buckets;
        }
        if (value == -128) {
            return -1;
        }
        return (int)((0x100000000L + (long)value) % (long)buckets);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == -128;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = -128;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_BYTE;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicByte.class;
    }

    @Override
    public int rows() {
        return this.size;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        byte[] data = new byte[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        out.write(data);
    }

    @Override
    public int getUnitLength() {
        return 1;
    }

    public void add(byte value) {
        if (this.size + 1 > this.capaticy && this.values.length > 0) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        } else if (this.values.length <= 0) {
            this.values = Arrays.copyOf(this.values, this.values.length + 1);
        }
        this.capaticy = this.values.length;
        this.values[this.size] = value;
        ++this.size;
    }

    public void addRange(byte[] valueList) {
        this.values = Arrays.copyOf(this.values, valueList.length + this.values.length);
        System.arraycopy(valueList, 0, this.values, this.size, valueList.length);
        this.size += valueList.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().byteValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicByteVector)value).getdataArray());
    }

    public byte[] getdataArray() {
        byte[] data = new byte[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        return data;
    }

    @Override
    public int asof(Scalar value) {
        byte target;
        try {
            target = value.getNumber().byteValue();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        int start = 0;
        int end = this.size - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.values[mid] <= target) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return end;
    }

    @Override
    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        byte[] data = new byte[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        for (byte val : data) {
            buffer.put(val);
        }
        return buffer;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            out.put(this.values[indexStart + i]);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement;
    }

    public byte[] getValues() {
        return this.values;
    }
}

