/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicLongVector;
import com.xxdb.data.BasicNanoTimestamp;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;

public class BasicNanoTimestampVector
extends BasicLongVector {
    public BasicNanoTimestampVector(int size) {
        super(size);
    }

    public BasicNanoTimestampVector(List<Long> list) {
        super(list);
    }

    public BasicNanoTimestampVector(long[] array) {
        super(array);
    }

    protected BasicNanoTimestampVector(long[] array, boolean copy) {
        super(array, copy);
    }

    protected BasicNanoTimestampVector(Entity.DATA_FORM df, int size) {
        super(df, size);
    }

    protected BasicNanoTimestampVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df, in);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_NANOTIMESTAMP;
    }

    @Override
    public Entity get(int index) {
        return new BasicNanoTimestamp(this.getLong(index));
    }

    @Override
    public Vector getSubVector(int[] indices) {
        return new BasicNanoTimestampVector(this.getSubArray(indices), false);
    }

    public LocalDateTime getNanoTimestamp(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return Utils.parseNanoTimestamp(this.getLong(index));
    }

    public void setNanoTimestamp(int index, LocalDateTime dt) {
        this.setLong(index, Utils.countDTNanoseconds(dt));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicNanoTimestamp.class;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicNanoTimestampVector v = (BasicNanoTimestampVector)vector;
        int newSize = this.rows() + v.rows();
        long[] newValue = new long[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicNanoTimestampVector(newValue);
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().longValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicNanoTimestampVector)value).getdataArray());
    }
}

